/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util;

public class CRegExp {
    private static final int MATCH_PATTERN = 6;
    private static final int MATCH_LITERAL = 5;
    private static final int MATCH_RANGE = 4;
    private static final int MATCH_ABORT = 3;
    private static final int MATCH_END = 2;
    private static final int MATCH_VALID = 1;
    private static final int PATTERN_VALID = 0;
    private static final int PATTERN_ESC = -1;
    private static final int PATTERN_RANGE = -2;
    private static final int PATTERN_CLOSE = -3;
    private static final int PATTERN_EMPTY = -4;
    private static final char MATCH_CHAR_SINGLE = '?';
    private static final char MATCH_CHAR_KLEENE_CLOSURE = '*';
    private static final char MATCH_CHAR_RANGE_OPEN = '[';
    private static final char MATCH_CHAR_RANGE = '-';
    private static final char MATCH_CHAR_RANGE_CLOSE = ']';
    private static final char MATCH_CHAR_CARAT_NEGATE = '^';
    private static final char MATCH_CHAR_EXCLAMATION_NEGATE = '!';

    public static boolean isMatch(String pattern, String text) {
        return CRegExp.matche(pattern, text) == 1;
    }

    private static int matche(String pattern, String text) {
        int p2 = 0;
        int t2 = 0;
        int result = 0;
        int plen = pattern.length();
        int tlen = text.length();
        while (result == 0 && p2 < plen) {
            if (t2 >= tlen) {
                if (pattern.charAt(p2) == '*' && p2 >= plen - 1) {
                    return 1;
                }
                return 3;
            }
            switch (pattern.charAt(p2)) {
                case '*': {
                    result = CRegExp.matchAfterStar(pattern.substring(p2), text.substring(t2));
                    break;
                }
                case '[': {
                    boolean invert = false;
                    if (pattern.charAt(++p2) == '!' || pattern.charAt(p2) == '^') {
                        invert = true;
                        ++p2;
                    }
                    if (pattern.charAt(p2) == ']') {
                        return 6;
                    }
                    boolean memberMatch = false;
                    boolean loop = true;
                    while (loop && pattern.charAt(p2) != ']') {
                        int rangeEnd;
                        int rangeStart = rangeEnd = p2++;
                        if (p2 >= plen) {
                            return 6;
                        }
                        if (pattern.charAt(p2) == '-') {
                            rangeEnd = ++p2;
                            if (p2 >= plen || pattern.charAt(rangeEnd) == ']') {
                                return 6;
                            }
                            ++p2;
                        }
                        if (p2 >= plen) {
                            return 6;
                        }
                        if (rangeStart < rangeEnd) {
                            if (text.charAt(t2) < pattern.charAt(rangeStart) || text.charAt(t2) > pattern.charAt(rangeEnd)) continue;
                            memberMatch = true;
                            loop = false;
                            continue;
                        }
                        if (text.charAt(t2) < pattern.charAt(rangeEnd) || text.charAt(t2) > pattern.charAt(rangeStart)) continue;
                        memberMatch = true;
                        loop = false;
                    }
                    if (invert && memberMatch || !invert && !memberMatch) {
                        return 4;
                    }
                    if (memberMatch) {
                        while (p2 < plen && pattern.charAt(p2) != ']') {
                            ++p2;
                        }
                    }
                    if (p2 < plen) break;
                    return 6;
                }
                default: {
                    if (pattern.charAt(p2) == '?' || pattern.charAt(p2) == text.charAt(t2)) break;
                    result = 5;
                }
            }
            ++p2;
            ++t2;
        }
        if (result == 0) {
            if (t2 < tlen) {
                return 2;
            }
            return 1;
        }
        return result;
    }

    private static int matchAfterStar(String pattern, String text) {
        int p2 = 0;
        int t2 = 0;
        int result = 0;
        if (CRegExp.matche(pattern.substring(1), text) == 1) {
            return 1;
        }
        int plen = pattern.length();
        int tlen = text.length();
        while (t2 < tlen && p2 < plen && (pattern.charAt(p2) == '?' || pattern.charAt(p2) == '*')) {
            if (pattern.charAt(p2) == '?') {
                ++t2;
            }
            ++p2;
        }
        if (t2 >= tlen) {
            return 3;
        }
        if (p2 >= plen) {
            return 1;
        }
        do {
            if (pattern.charAt(p2) == text.charAt(t2) || pattern.charAt(p2) == '[') {
                pattern = pattern.substring(p2);
                text = text.substring(t2);
                plen = pattern.length();
                tlen = text.length();
                t2 = 0;
                p2 = 0;
                result = CRegExp.matche(pattern, text);
                if (result == 1) {
                    return result;
                }
                result = 0;
            }
            if (++t2 < tlen) continue;
            return 3;
        } while (result == 0);
        return result != 0 ? result : 3;
    }

    public static void main(String[] args) {
        System.out.println("The match result (1): " + CRegExp.isMatch("BLA", "BLA"));
        System.out.println("The match result (2): " + CRegExp.isMatch("A*", "ABBA"));
        System.out.println("The match result (3): " + CRegExp.isMatch("[A-Z,_]*[A-Z,0-9,_]*0?7*", "AGENT_007"));
    }
}

