/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CIniFile {
    private CItemArray sections = new CItemArray();
    private URL url = null;

    public CIniFile() {
    }

    public CIniFile(String fileName) throws IOException {
        this(new File(fileName));
    }

    public CIniFile(File file) throws IOException {
        this(file.toURL());
    }

    public CIniFile(URL url) throws IOException {
        this.url = url;
        this.loadFromStream(url.openStream());
    }

    private OutputStream createOutputStream() throws IOException {
        if (this.url.getProtocol().equals("file")) {
            return new FileOutputStream(this.url.getFile());
        }
        return this.url.openConnection().getOutputStream();
    }

    private CItemArray addSection(String section) {
        CItemArray a2 = new CItemArray();
        this.sections.putValue(section, a2);
        return a2;
    }

    public void clear() {
        this.sections.clear();
    }

    public void deleteKey(String section, String ident) {
        CItemArray a2 = (CItemArray)this.sections.getValue(section);
        if (a2 != null) {
            a2.removeValue(ident);
        }
    }

    public void eraseSection(String section) {
        this.sections.removeValue(section);
    }

    public boolean valueExists(String section, String ident) {
        CItemArray a2 = this.readSection(section);
        return a2 != null && a2.getValue(ident) != null;
    }

    public boolean isSectionExists(String section) {
        return this.readSection(section) != null;
    }

    private String readLine(InputStream stream) throws IOException {
        int c2;
        String line = "";
        do {
            if ((c2 = stream.read()) < 0 || c2 == 10 || c2 == 13) continue;
            line = line + (char)c2;
        } while (c2 >= 0 && c2 != 10);
        return c2 >= 0 || line.length() > 0 ? line.trim() : null;
    }

    private String[] splitLine(String line) {
        String[] result = new String[3];
        int part = 0;
        boolean inString = false;
        result[0] = "";
        result[1] = "";
        result[2] = "";
        int i2 = 0;
        while (i2 < line.length()) {
            char c2 = line.charAt(i2);
            if (c2 == '=' && part == 0) {
                part = 1;
            } else if (c2 == ';' && !inString && part < 2) {
                part = 2;
            } else {
                if (c2 == '\"' && part == 1) {
                    inString = !inString;
                }
                int n2 = part;
                result[n2] = result[n2] + c2;
            }
            ++i2;
        }
        return result;
    }

    public void loadFromStream(InputStream stream) throws IOException {
        this.sections.clear();
        String s2 = this.readLine(stream);
        if (s2 == null) {
            return;
        }
        CItemArray section = new CItemArray();
        this.sections.putValue("", section);
        while (s2 != null) {
            if (s2.startsWith("[")) {
                if ((s2 = s2.substring(1)).endsWith("]")) {
                    s2 = s2.substring(0, s2.length() - 1);
                }
                section = new CItemArray();
                this.sections.putValue(s2, section);
            } else {
                String[] parts = this.splitLine(s2);
                section.putValue(parts[0].toUpperCase(), s2);
            }
            s2 = this.readLine(stream);
        }
    }

    private CItemArray readSection(String section) {
        return (CItemArray)this.sections.getValue(section);
    }

    private CItemArray readSections() {
        return this.sections;
    }

    public String unwrapString(String s2) {
        if ((s2 = s2.trim()).startsWith("\"") && s2.length() > 0) {
            String result = "";
            int i2 = 1;
            while (i2 < s2.length()) {
                if (s2.charAt(i2) == '\\') {
                    ++i2;
                }
                if (s2.charAt(i2) != '\"' || s2.charAt(i2 - 1) == '\\') {
                    result = result + s2.charAt(i2);
                }
                ++i2;
            }
            return result;
        }
        return s2;
    }

    public String readString(String section, String ident, String def) {
        CItemArray a2 = (CItemArray)this.sections.getValue(section);
        if (a2 == null) {
            return def;
        }
        String line = (String)a2.getValue(ident);
        if (line == null) {
            return def;
        }
        String[] parts = this.splitLine(line);
        return this.unwrapString(parts[1]);
    }

    public void rename(String fileName, boolean reload) throws IOException {
        this.rename(new File(fileName), reload);
    }

    public void rename(File file, boolean reload) throws IOException {
        this.rename(file.toURL(), reload);
    }

    public void rename(URL url, boolean reload) throws IOException {
        this.url = url;
        if (reload) {
            this.loadFromStream(url.openStream());
        }
    }

    private void writeLine(OutputStream stream, String line) throws IOException {
        stream.write(line.getBytes());
    }

    public void saveToStream(OutputStream stream) throws IOException {
        boolean first = true;
        int i2 = 0;
        while (i2 < this.sections.size()) {
            String s2 = this.sections.getKey(i2);
            String line = "[" + s2 + "]";
            if (!line.equals("[]")) {
                if (!first) {
                    line = "\r\n" + line;
                }
                this.writeLine(stream, line);
                first = false;
            }
            CItemArray a2 = (CItemArray)this.sections.getValue(i2);
            int j2 = 0;
            while (j2 < a2.size()) {
                line = (String)a2.getValue(j2);
                if (!first) {
                    line = "\r\n" + line;
                }
                this.writeLine(stream, line);
                first = false;
                ++j2;
            }
            ++i2;
        }
    }

    public void flush() throws IOException {
        this.saveToStream(this.createOutputStream());
    }

    private String wrapString(String s2) {
        if (s2.indexOf(32) >= 0 || s2.indexOf(9) >= 0 || s2.indexOf(34) >= 0 || s2.indexOf(59) >= 0) {
            String result = "\"";
            int i2 = 0;
            while (i2 < s2.length()) {
                if (s2.charAt(i2) == '\"' || s2.charAt(i2) == '\\') {
                    result = result + '\\';
                }
                result = result + s2.charAt(i2);
                ++i2;
            }
            return result + "\"";
        }
        return s2;
    }

    public void writeString(String section, String ident, String value) {
        String line;
        CItemArray a2 = (CItemArray)this.sections.getValue(section);
        if (a2 == null) {
            a2 = this.addSection(section);
        }
        if ((line = (String)a2.getValue(ident)) == null) {
            line = ident + "=" + this.wrapString(value);
        } else {
            String[] parts = this.splitLine(line);
            line = parts[0] + "=" + this.wrapString(value);
            if (parts[2].length() > 0) {
                line = line + ";" + parts[2];
            }
        }
        a2.putValue(ident, line);
    }

    public int readInteger(String section, String ident, int def) {
        String s2 = this.readString(section, ident, new Integer(def).toString());
        try {
            return new Integer(s2);
        }
        catch (Exception e2) {
            return def;
        }
    }

    public void writeInteger(String section, String ident, int value) {
        this.writeString(section, ident, new Integer(value).toString());
    }

    public boolean readBool(String section, String ident, boolean def) {
        return this.readInteger(section, ident, def ? 1 : 0) != 0;
    }

    public void writeBool(String section, String ident, boolean value) {
        this.writeString(section, ident, value ? "1" : "0");
    }

    public double readFloat(String section, String ident, double def) {
        String s2 = this.readString(section, ident, new Double(def).toString());
        try {
            return new Double(s2);
        }
        catch (Exception e2) {
            return def;
        }
    }

    public void writeFloat(String section, String ident, double value) {
        this.writeString(section, ident, new Double(value).toString());
    }

    public Date readDateTime(String section, String ident, Date def) {
        String s2 = this.readString(section, ident, def.toString());
        try {
            return new SimpleDateFormat().parse(s2);
        }
        catch (Exception e2) {
            return def;
        }
    }

    public void writeDateTime(String section, String ident, Date value) {
        this.writeString(section, ident, new SimpleDateFormat().format(value));
    }

    public static void main(String[] args) {
        try {
            CIniFile iniFile = new CIniFile("test.ini");
            boolean boolVal = iniFile.readBool("Main", "BoolVal", false);
            System.out.println("BoolVal = " + boolVal);
            iniFile.writeBool("Main", "BoolVal", !boolVal);
            System.out.println("Param1 = " + iniFile.readString("Other X", "Param1", ""));
            System.out.println("Param2 = " + iniFile.readInteger("Other X", "param2", 123));
            System.out.println("Param3 = " + iniFile.readDateTime("Other X", "param3", new Date()));
            iniFile.writeString("Other x", "param1", "..\"xxx\"...");
            iniFile.writeDateTime("Other x", "param3", new Date());
            iniFile.flush();
        }
        catch (Exception e2) {
            System.out.println("Ooopps..");
            System.out.println(e2.getMessage());
        }
    }

    private class CItemArray
    extends ArrayList {
        private CItemArray() {
        }

        private String normalizeKey(String key) {
            boolean last = false;
            String s2 = "";
            int i2 = 0;
            while (i2 < key.length()) {
                if (!last || key.charAt(i2) != ' ' && key.charAt(i2) != '\t') {
                    s2 = s2 + key.charAt(i2);
                }
                last = key.charAt(i2) == ' ' || key.charAt(i2) == '\t';
                ++i2;
            }
            return s2;
        }

        public String getKey(int index) {
            return ((CItemHolder)this.get((int)index)).key;
        }

        public Object getValue(int index) {
            return ((CItemHolder)this.get((int)index)).value;
        }

        public Object getValue(String key) {
            key = this.normalizeKey(key);
            int i2 = 0;
            while (i2 < this.size()) {
                CItemHolder current = (CItemHolder)this.get(i2);
                if (current.key.equalsIgnoreCase(key)) {
                    return current.value;
                }
                ++i2;
            }
            return null;
        }

        public void putValue(String key, Object value) {
            if ((key = this.normalizeKey(key)).length() > 0) {
                int i2 = 0;
                while (i2 < this.size()) {
                    CItemHolder current = (CItemHolder)this.get(i2);
                    if (current.key.equalsIgnoreCase(key)) {
                        current.value = value;
                        this.set(i2, current);
                        return;
                    }
                    ++i2;
                }
            }
            this.add(new CItemHolder(key, value));
        }

        public void removeValue(int index) {
            this.remove(index);
        }

        public void removeValue(String key) {
            key = this.normalizeKey(key);
            int i2 = 0;
            while (i2 < this.size()) {
                CItemHolder current = (CItemHolder)this.get(i2);
                if (current.key.equalsIgnoreCase(key)) {
                    this.remove(i2);
                    return;
                }
                ++i2;
            }
        }

        private class CItemHolder {
            public String key;
            public Object value;

            public CItemHolder(String key, Object value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

