/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.comedia.text.CNumericDocument;
import org.comedia.ui.CDataTable;
import org.comedia.ui.CEncodedIcon;

public class CTableNavigator
extends JPanel
implements ListSelectionListener,
TableModelListener,
ActionListener,
FocusListener {
    JLabel captionLabel = new JLabel();
    JButton firstButton = new JButton();
    JButton priorButton = new JButton();
    JTextField recordText = new JTextField();
    JButton nextButton = new JButton();
    JButton lastButton = new JButton();
    JButton lastNewButton = new JButton();
    JLabel recordLabel = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    Border border1;
    JPanel splitPanel1 = new JPanel();
    JPanel splitPanel2 = new JPanel();
    JTable table = null;
    private int lastSelection = 0;
    private CNumericDocument document = new CNumericDocument();

    public CTableNavigator() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public CTableNavigator(JTable table) {
        this();
        this.setTable(table);
    }

    private void jbInit() throws Exception {
        this.captionLabel.setText("  Record:  ");
        this.priorButton.setPreferredSize(new Dimension(21, 17));
        this.priorButton.setActionCommand("Prior");
        this.firstButton.setPreferredSize(new Dimension(21, 17));
        this.firstButton.setActionCommand("First");
        this.recordText.setPreferredSize(new Dimension(80, 19));
        this.nextButton.setPreferredSize(new Dimension(21, 17));
        this.nextButton.setActionCommand("Next");
        this.lastButton.setPreferredSize(new Dimension(21, 17));
        this.lastButton.setActionCommand("Last");
        this.lastNewButton.setPreferredSize(new Dimension(21, 17));
        this.lastNewButton.setActionCommand("LastNew");
        this.recordLabel.setText("  of 0");
        this.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.splitPanel1.setPreferredSize(new Dimension(5, 10));
        this.splitPanel2.setPreferredSize(new Dimension(5, 10));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 19));
        this.setMinimumSize(new Dimension(270, 19));
        this.setPreferredSize(new Dimension(270, 19));
        this.add((Component)this.captionLabel, null);
        this.add((Component)this.firstButton, null);
        this.add((Component)this.priorButton, null);
        this.add((Component)this.splitPanel1, null);
        this.add((Component)this.recordText, null);
        this.add((Component)this.splitPanel2, null);
        this.add((Component)this.nextButton, null);
        this.add((Component)this.lastButton, null);
        this.add((Component)this.lastNewButton, null);
        this.add((Component)this.recordLabel, null);
        this.recordText.setEnabled(false);
        this.recordText.setHorizontalAlignment(4);
        this.recordText.addActionListener(this);
        this.recordText.setActionCommand("Goto");
        this.recordText.addFocusListener(this);
        this.recordText.setDocument(this.document);
        this.recordText.setText("0");
        this.initButton(this.firstButton, CEncodedIcon.FIRST_SIGN);
        this.initButton(this.priorButton, CEncodedIcon.PRIOR_SIGN);
        this.initButton(this.nextButton, CEncodedIcon.NEXT_SIGN);
        this.initButton(this.lastButton, CEncodedIcon.LAST_SIGN);
        this.initButton(this.lastNewButton, CEncodedIcon.LAST_NEW_SIGN);
    }

    private void initButton(JButton button, CEncodedIcon icon) {
        button.setIcon(icon);
        icon = new CEncodedIcon(icon.getImageArray(), icon.getIconWidth(), icon.getIconHeight());
        icon.setEnabled(false);
        button.setDisabledIcon(icon);
        button.setEnabled(false);
        button.addActionListener(this);
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
    }

    public void valueChanged(ListSelectionEvent e2) {
        this.updateContent();
    }

    public void tableChanged(TableModelEvent e2) {
        this.updateContent();
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        if (this.table != null) {
            this.table.getSelectionModel().removeListSelectionListener(this);
            this.table.getModel().removeTableModelListener(this);
        }
        this.table = table;
        int n2 = this.lastSelection = table.getSelectedRow() >= 0 ? table.getSelectedRow() : 0;
        if (this.table != null) {
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.getModel().addTableModelListener(this);
            this.updateContent();
        }
    }

    private void updateContent() {
        int currentRow;
        if (this.table == null) {
            this.firstButton.setEnabled(false);
            this.priorButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
            this.lastNewButton.setEnabled(false);
            this.recordText.setEnabled(false);
            this.recordLabel.setText("  of 0");
            this.validate();
            return;
        }
        int n2 = currentRow = this.table.getSelectedRow() >= 0 ? this.table.getSelectedRow() : 0;
        if (this.table.getSelectedRowCount() > 1) {
            currentRow = this.lastSelection;
        } else {
            this.lastSelection = currentRow;
        }
        int insertRow = this.table instanceof CDataTable && ((CDataTable)this.table).isInsert() ? this.table.getRowCount() - 1 : -1;
        int rowCount = insertRow >= 0 ? this.table.getRowCount() - 1 : this.table.getRowCount();
        this.firstButton.setEnabled(currentRow > 0);
        this.priorButton.setEnabled(this.firstButton.isEnabled());
        this.lastButton.setEnabled(currentRow < rowCount - 1);
        this.lastNewButton.setEnabled(insertRow >= 0 && currentRow != insertRow);
        this.nextButton.setEnabled(this.lastButton.isEnabled() || this.lastNewButton.isEnabled());
        this.recordText.setEnabled(rowCount > 0);
        this.recordText.setText(new Integer(currentRow + 1).toString());
        this.recordLabel.setText("  of " + new Integer(rowCount).toString());
        this.validate();
    }

    public void actionPerformed(ActionEvent e2) {
        int rowCount;
        int currentRow;
        String cmd = e2.getActionCommand();
        int n2 = currentRow = this.table.getSelectedRow() >= 0 ? this.table.getSelectedRow() : 0;
        if (this.table.getSelectedRowCount() > 1) {
            currentRow = this.lastSelection;
        } else {
            this.lastSelection = currentRow;
        }
        int insertRow = this.table instanceof CDataTable && ((CDataTable)this.table).isInsert() ? this.table.getRowCount() - 1 : -1;
        int n3 = rowCount = insertRow >= 0 ? this.table.getRowCount() - 1 : this.table.getRowCount();
        if (cmd.equals("First")) {
            this.gotoRow(0);
        } else if (cmd.equals("Prior")) {
            this.gotoRow(currentRow - 1);
        } else if (cmd.equals("Next")) {
            this.gotoRow(currentRow + 1);
        } else if (cmd.equals("Last")) {
            this.gotoRow(rowCount - 1);
        } else if (cmd.equals("LastNew")) {
            this.gotoRow(insertRow);
        } else if (cmd.equals("Goto")) {
            int row = new Integer(this.recordText.getText());
            this.gotoRow(row - 1);
        }
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
        if (this.document.isModified()) {
            this.recordText.postActionEvent();
        }
    }

    private void gotoRow(int row) {
        if (this.table != null && row >= 0 && row < this.table.getRowCount()) {
            Rectangle cellRect;
            this.table.removeEditor();
            this.table.setRowSelectionInterval(row, row);
            if (this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(row, this.table.getSelectedColumn(), false)) != null) {
                this.table.scrollRectToVisible(cellRect);
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Comedia Data Grid Test");
        JTable table = new JTable(new String[][]{{"1x1", "1x2", "1x3"}, {"2x1", "2x2", "2x3"}, {"3x1", "3x2", "3x3"}, {"4x1", "4x2", "4x3"}}, new String[]{"Column 1", "Column 2", "Column 3"});
        frame.getContentPane().add((Component)table, "Center");
        CTableNavigator navigator = new CTableNavigator(table);
        frame.getContentPane().add((Component)navigator, "South");
        frame.setLocation(100, 100);
        frame.setSize(500, 300);
        frame.setDefaultCloseOperation(3);
        frame.show();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(navigator);
        }
        catch (Exception e2) {}
    }
}

