/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.comedia.text.CAbstractHighlighter;
import org.comedia.text.CJavaHighlighter;
import org.comedia.text.CSyntaxDocument;
import org.comedia.text.CSyntaxEditorKit;
import org.comedia.ui.CEditor;

public class CSyntaxEditor
extends CEditor
implements DocumentListener {
    private boolean indent = true;
    private int tabSpace = 2;
    private CHighlightThread thread = null;
    private CAbstractHighlighter syntaxHighlighter = null;

    public CSyntaxEditor() {
        this.setEditorKit(new CSyntaxEditorKit());
        this.setFont(new Font("Monospaced", 0, 12));
    }

    public CSyntaxEditor(CSyntaxDocument doc) {
        this();
        this.setDocument(doc);
    }

    public void setDocument(Document doc) {
        if (!(doc instanceof CSyntaxDocument)) {
            return;
        }
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
        super.setDocument(doc);
        if (this.getDocument() != null) {
            this.getDocument().addDocumentListener(this);
            this.performHighlight();
        }
    }

    public void changedUpdate(DocumentEvent e2) {
        block3: {
            if (this.syntaxHighlighter == null || this.thread != null && this.thread.ready) break block3;
            try {
                int pos = this.getCaretPosition();
                String text = this.getDocument().getText(0, this.getDocument().getLength());
                int start = text.lastIndexOf(10, pos - 2);
                start = start < 0 ? 0 : start;
                int end = text.indexOf(10, pos - 1);
                end = end < 0 ? text.length() - 1 : end;
                int unclosedComment = this.syntaxHighlighter.locateUnclosedComment(text, start);
                int n2 = start = unclosedComment >= 0 ? unclosedComment : start;
                if (this.thread == null) {
                    this.thread = new CHighlightThread();
                    this.thread.start();
                }
                this.thread.start = start;
                this.thread.end = end;
                this.thread.ready = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void insertUpdate(DocumentEvent e2) {
        this.changedUpdate(e2);
    }

    public void removeUpdate(DocumentEvent e2) {
        this.changedUpdate(e2);
    }

    public void performHighlight() {
        this.performHighlight(0, this.getDocument().getLength() - 1);
    }

    public synchronized void performHighlight(int start, int end) {
        if (this.getDocument() instanceof CSyntaxDocument && this.syntaxHighlighter != null) {
            ((CSyntaxDocument)this.getDocument()).performHighlight(this.syntaxHighlighter, start, end);
        }
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public int getTabSpace() {
        return this.tabSpace;
    }

    public void setTabSpace(int tabSpace) {
        this.tabSpace = tabSpace;
    }

    public CAbstractHighlighter getSyntaxHighlighter() {
        return this.syntaxHighlighter;
    }

    public void setSyntaxHighlighter(CAbstractHighlighter highlighter) {
        this.syntaxHighlighter = highlighter;
    }

    protected EditorKit createDefaultEditorKit() {
        return new CSyntaxEditorKit();
    }

    private static String extractLineFromEnd(String text) {
        int pos = text.lastIndexOf(10);
        if (pos < 0) {
            return text;
        }
        if (pos >= text.length() - 1) {
            return "";
        }
        return text.substring(pos + 1);
    }

    private static int defineIndent(String line) {
        int indent = 0;
        while (indent < line.length() && line.charAt(indent) == ' ') {
            ++indent;
        }
        return indent;
    }

    private static String removeLastLine(String text) {
        int pos = text.lastIndexOf(10);
        return pos > 0 ? text.substring(0, pos) : "";
    }

    private String createString(String piece, int repeat) {
        String result = "";
        int i2 = 0;
        while (i2 < repeat) {
            result = result + piece;
            ++i2;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processKeyEvent(KeyEvent e2) {
        block32: {
            block31: {
                block30: {
                    block29: {
                        int PIECE_LENGTH = 1024;
                        if (e2.isAltDown() || e2.isMetaDown() || e2.isAltGraphDown()) break block29;
                        if (e2.getID() == 401) break block30;
                    }
                    super.processKeyEvent(e2);
                    return;
                }
                if (e2.getKeyCode() == 10) break block31;
                if (e2.getKeyCode() == 8) break block31;
                if (e2.getKeyCode() != 9) break block32;
            }
            if (!e2.isShiftDown() && !e2.isControlDown() && this.indent) {
                int pos = this.getCaretPosition();
                String piece = "";
                try {
                    piece = this.getDocument().getText(0, pos);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                String line = CSyntaxEditor.extractLineFromEnd(piece);
                int currIndent = CSyntaxEditor.defineIndent(line);
                piece = CSyntaxEditor.removeLastLine(piece.substring(0, piece.length() - line.length()));
                if (e2.getKeyCode() == 10) {
                    try {
                        while (piece.length() > 0 && currIndent > 0 && currIndent == line.length()) {
                            line = CSyntaxEditor.extractLineFromEnd(piece);
                            currIndent = CSyntaxEditor.defineIndent(line);
                            piece = CSyntaxEditor.removeLastLine(piece.substring(0, piece.length() - line.length()));
                        }
                        this.getDocument().insertString(this.getCaretPosition(), "\n" + this.createString(" ", currIndent), null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (e2.getKeyCode() == 8) {
                    if (currIndent == line.length()) {
                        String lastLine = CSyntaxEditor.extractLineFromEnd(piece);
                        int lastIndent = CSyntaxEditor.defineIndent(lastLine);
                        piece = CSyntaxEditor.removeLastLine(piece.substring(0, piece.length() - lastLine.length()));
                        while (piece.length() > 0 && lastIndent > 0 && lastIndent >= currIndent) {
                            lastLine = CSyntaxEditor.extractLineFromEnd(piece);
                            lastIndent = CSyntaxEditor.defineIndent(lastLine);
                            piece = CSyntaxEditor.removeLastLine(piece.substring(0, piece.length() - lastLine.length()));
                        }
                        if (currIndent > lastIndent) {
                            try {
                                this.getDocument().remove(this.getCaretPosition() - currIndent + lastIndent + 1, currIndent - lastIndent - 1);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else if (currIndent <= lastIndent) {
                            try {
                                this.getDocument().remove(this.getCaretPosition() - currIndent + 1, currIndent - 1);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                } else if (e2.getKeyCode() == 9) {
                    try {
                        this.getDocument().insertString(this.getCaretPosition(), this.createString(" ", this.tabSpace), null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                e2.consume();
                return;
            }
        }
        super.processKeyEvent(e2);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Comedia Syntax Editor Test");
        CSyntaxEditor editor = new CSyntaxEditor();
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(editor);
        try {
            editor.setSyntaxHighlighter(new CJavaHighlighter());
            editor.read(new FileReader("d:\\test.java"), null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        frame.getContentPane().add((Component)scroll, "Center");
        frame.setLocation(100, 100);
        frame.setSize(305, 320);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    private class CHighlightThread
    extends Thread {
        public int start = -1;
        public int end = -1;
        public boolean ready = false;

        private CHighlightThread() {
        }

        public void run() {
            try {
                while (true) {
                    if (this.ready) {
                        CSyntaxEditor.this.performHighlight(this.start, this.end);
                        this.ready = false;
                    } else {
                        Thread.sleep(150L);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
        }
    }
}

