/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.comedia.event.CSpinEvent;
import org.comedia.event.CSpinListener;
import org.comedia.text.CNumericDocument;
import org.comedia.ui.CSpinButton;

public class CSpinEdit
extends JComponent
implements CSpinListener,
KeyListener,
ActionListener,
FocusListener {
    private JTextField text = new JTextField();
    private CSpinButton spin = new CInternalSpin();
    private CNumericDocument document = new CNumericDocument();
    private int maximum = 100;
    private int minimum = 0;

    public CSpinEdit() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "Center");
        this.add((Component)this.spin, "East");
        this.setPreferredSize(new Dimension(70, 21));
        this.spin.setRequestFocusEnabled(false);
        this.spin.addSpinListener(this);
        this.text.setDocument(this.document);
        this.text.setText("0");
        this.text.setHorizontalAlignment(4);
        this.text.addKeyListener(this);
        this.text.addActionListener(this);
        this.text.addFocusListener(this);
    }

    private int getTextValue() {
        String temp = this.text.getText();
        int result = this.minimum;
        try {
            result = new Integer(temp);
        }
        catch (Exception e2) {}
        return result;
    }

    private void setTextValue(int value) {
        if (value > this.maximum) {
            value = this.maximum;
        }
        if (value < this.minimum) {
            value = this.minimum;
        }
        this.text.setText(new Integer(value).toString());
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
        this.setTextValue(this.getTextValue());
    }

    public void actionPerformed(ActionEvent e2) {
        int value = this.getTextValue();
        this.setTextValue(value);
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        block4: {
            block5: {
                int keycode;
                block3: {
                    block2: {
                        keycode = e2.getKeyCode();
                        if (keycode == 38) break block2;
                        if (keycode == 33) break block2;
                        if (keycode != 36) break block3;
                    }
                    this.spin.keyPressed(e2);
                    e2.consume();
                    break block4;
                }
                if (keycode == 40) break block5;
                if (keycode == 34) break block5;
                if (keycode != 35) break block4;
            }
            this.spin.keyPressed(e2);
            e2.consume();
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void spinEventPerformed(CSpinEvent event) {
        int value = this.getTextValue();
        if (event.getSpinCommand() == 0) {
            this.setTextValue(value + 1);
        }
        if (event.getSpinCommand() == 1) {
            this.setTextValue(value - 1);
        }
    }

    public int getValue() {
        return this.getTextValue();
    }

    public void setValue(int value) {
        this.setTextValue(value);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        if (maximum <= this.minimum) {
            maximum = this.minimum + 1;
        }
        this.maximum = maximum;
        this.setTextValue(this.getTextValue());
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        if (minimum >= this.maximum) {
            minimum = this.maximum - 1;
        }
        this.minimum = minimum;
        this.setTextValue(this.getTextValue());
    }

    public void setEnabled(boolean enabled) {
        this.spin.setEnabled(enabled);
        this.text.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public JTextField getTextField() {
        return this.text;
    }

    public CSpinButton getSpinButton() {
        return this.spin;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Comedia CSpinButton Test");
        CSpinEdit spinEdit = new CSpinEdit();
        spinEdit.setValue(50);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(spinEdit);
        frame.setLocation(100, 100);
        frame.setSize(150, 100);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    private class CInternalSpin
    extends CSpinButton {
        private CInternalSpin() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

