/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.comedia.event.CSpinEvent;
import org.comedia.event.CSpinListener;

public class CSpinButton
extends JComponent
implements KeyListener,
AdjustmentListener {
    protected EventListenerList listenerList = new EventListenerList();
    private JScrollBar scrollBar = new JScrollBar(1, 1, 0, 0, 2);
    private int maximum = 100;
    private int minimum = 0;
    private int value = 0;
    static /* synthetic */ Class class$org$comedia$event$CSpinListener;

    public CSpinButton() {
        this.setLayout(new BorderLayout());
        this.setRequestFocusEnabled(true);
        this.setPreferredSize(new Dimension(16, 21));
        this.addKeyListener(this);
        this.add(this.scrollBar);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setRequestFocusEnabled(false);
    }

    public void addSpinListener(CSpinListener l2) {
        this.listenerList.add(class$org$comedia$event$CSpinListener == null ? (class$org$comedia$event$CSpinListener = CSpinButton.class$("org.comedia.event.CSpinListener")) : class$org$comedia$event$CSpinListener, l2);
    }

    public void removeSpinListener(CSpinListener l2) {
        this.listenerList.remove(class$org$comedia$event$CSpinListener == null ? (class$org$comedia$event$CSpinListener = CSpinButton.class$("org.comedia.event.CSpinListener")) : class$org$comedia$event$CSpinListener, l2);
    }

    public void fireSpinChanged(CSpinEvent e2) {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == (class$org$comedia$event$CSpinListener == null ? CSpinButton.class$("org.comedia.event.CSpinListener") : class$org$comedia$event$CSpinListener)) {
                ((CSpinListener)listeners[i2 + 1]).spinEventPerformed(e2);
            }
            i2 -= 2;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    private void performSpinUp() {
        if (this.value < this.maximum) {
            ++this.value;
        }
        this.fireSpinChanged(new CSpinEvent(this, 0));
    }

    private void performSpinDown() {
        if (this.value > this.minimum) {
            --this.value;
        }
        this.fireSpinChanged(new CSpinEvent(this, 1));
    }

    public void adjustmentValueChanged(AdjustmentEvent e2) {
        switch (e2.getValue()) {
            case 0: {
                this.performSpinUp();
                break;
            }
            case 2: {
                this.performSpinDown();
            }
        }
        e2.getAdjustable().setValue(1);
        this.requestFocus();
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        block4: {
            block5: {
                int keycode;
                block3: {
                    block2: {
                        keycode = e2.getKeyCode();
                        if (keycode == 38) break block2;
                        if (keycode == 33) break block2;
                        if (keycode != 36) break block3;
                    }
                    this.performSpinUp();
                    e2.consume();
                    break block4;
                }
                if (keycode == 40) break block5;
                if (keycode == 34) break block5;
                if (keycode != 35) break block4;
            }
            this.performSpinDown();
            e2.consume();
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public void setEnabled(boolean enabled) {
        this.scrollBar.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Comedia CSpinButton Test");
        final CSpinButton spin = new CSpinButton();
        final JTextField text = new JTextField("0                 ");
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(text);
        frame.getContentPane().add(spin);
        spin.addSpinListener(new CSpinListener(){

            public void spinEventPerformed(CSpinEvent event) {
                text.setText(new Integer(spin.getValue()).toString());
            }
        });
        frame.setLocation(100, 100);
        frame.setSize(150, 100);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

