/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class COutlookBar
extends JComponent
implements ActionListener {
    private ArrayList items = new ArrayList();
    private int currentIndex = -1;
    private int animationSpeed = 20;

    public COutlookBar() {
        this.setLayout(new BorderLayout());
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JButton) {
            int index = this.getPanelIndex(((JButton)e2.getSource()).getText());
            if (this.currentIndex >= 0 && this.currentIndex != index) {
                this.sweepBar(index);
            }
        }
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public int getSelectedIndex() {
        return this.currentIndex;
    }

    public void setSelectedIndex(int index) {
        if (this.currentIndex != index) {
            this.currentIndex = index;
            this.updateContent();
        }
    }

    public int getPanelIndex(String name) {
        int i2 = 0;
        while (i2 < this.items.size()) {
            COutlookBarItem current = (COutlookBarItem)this.items.get(i2);
            if (current.getButton().getText().equals(name)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int getPanelIndex(Component component) {
        int i2 = 0;
        while (i2 < this.items.size()) {
            COutlookBarItem current = (COutlookBarItem)this.items.get(i2);
            if (current.getComponent() == component) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int getPanelCount() {
        return this.items.size();
    }

    public Component getPanel(int index) {
        return ((COutlookBarItem)this.items.get(index)).getComponent();
    }

    public Component getPanel(String name) {
        int i2 = 0;
        while (i2 < this.items.size()) {
            COutlookBarItem current = (COutlookBarItem)this.items.get(i2);
            if (current.getButton().getText().equals(name)) {
                return current.getComponent();
            }
            ++i2;
        }
        return null;
    }

    public String getPanelTitle(int index) {
        return ((COutlookBarItem)this.items.get(index)).getButton().getText();
    }

    public Component addPanel(String name) {
        return this.addPanel(name, new JPanel());
    }

    public Component addPanel(String name, Component component) {
        COutlookBarItem item = new COutlookBarItem(name, component);
        this.items.add(item);
        item.getButton().addActionListener(this);
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        }
        this.updateContent();
        return component;
    }

    public void removePanel(int index) {
        if (this.currentIndex >= index) {
            --this.currentIndex;
        }
        if (this.currentIndex < 0 && this.items.size() > 0) {
            this.currentIndex = 0;
        }
        this.items.remove(index);
        this.updateContent();
    }

    public void removePanel(String name) {
        this.removePanel(this.getPanelIndex(name));
    }

    public void removePanel(Component component) {
        this.removePanel(this.getPanelIndex(component));
    }

    private void updateContent() {
        super.removeAll();
        if (this.items.size() >= 0 && this.currentIndex >= 0 && this.currentIndex < this.items.size()) {
            JPanel topPanel = null;
            JPanel bottomPanel = null;
            int topItems = this.currentIndex + 1;
            int bottomItems = this.items.size() - topItems;
            if (topItems > 0) {
                topPanel = new JPanel();
                topPanel.setLayout(new GridLayout(topItems, 1));
                super.add((Component)topPanel, "North");
            } else {
                topPanel = null;
            }
            if (bottomItems > 0) {
                bottomPanel = new JPanel();
                bottomPanel.setLayout(new GridLayout(bottomItems, 1));
                super.add((Component)bottomPanel, "South");
            }
            super.add(((COutlookBarItem)this.items.get(this.currentIndex)).getComponent(), "Center");
            int i2 = 0;
            while (i2 < this.items.size()) {
                COutlookBarItem current = (COutlookBarItem)this.items.get(i2);
                if (i2 <= this.currentIndex) {
                    topPanel.add(current.getButton());
                } else {
                    bottomPanel.add(current.getButton());
                }
                ++i2;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        int i2 = 0;
        while (i2 < this.items.size()) {
            COutlookBarItem current = (COutlookBarItem)this.items.get(i2);
            SwingUtilities.updateComponentTreeUI(current.getButton());
            if (current.getComponent() instanceof JComponent) {
                SwingUtilities.updateComponentTreeUI((JComponent)current.getComponent());
            }
            ++i2;
        }
        super.updateUI();
    }

    private void sweepBar(int index) {
        super.removeAll();
        JPanel topPanel = new JPanel();
        JPanel centralPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        int i2 = 0;
        while (i2 < this.items.size()) {
            COutlookBarItem current = (COutlookBarItem)this.items.get(i2);
            JButton button = new JButton(current.getButton().getText());
            if (i2 <= index && i2 <= this.currentIndex) {
                topPanel.add(button);
            } else if (i2 > index && i2 > this.currentIndex) {
                bottomPanel.add(button);
            } else {
                centralPanel.add(button);
            }
            ++i2;
        }
        if (topPanel.getComponentCount() > 0) {
            topPanel.setLayout(new GridLayout(topPanel.getComponentCount(), 1));
            super.add((Component)topPanel, "North");
        }
        if (bottomPanel.getComponentCount() > 0) {
            bottomPanel.setLayout(new GridLayout(bottomPanel.getComponentCount(), 1));
            super.add((Component)bottomPanel, "South");
        }
        if (centralPanel.getComponentCount() > 0) {
            centralPanel.setLayout(new GridLayout(centralPanel.getComponentCount(), 1));
        }
        Component first = ((COutlookBarItem)this.items.get(this.currentIndex)).getComponent();
        Component second = ((COutlookBarItem)this.items.get(index)).getComponent();
        CSweepPanel sweep = new CSweepPanel();
        sweep.reset(first, second, centralPanel, this.currentIndex - index);
        super.add((Component)sweep, "Center");
        this.revalidate();
        this.repaint();
        this.currentIndex = index;
        CSweepThread thread = new CSweepThread(sweep);
        try {
            thread.start();
        }
        catch (Exception e2) {}
    }

    public static void main(String[] args) {
        COutlookBar bar = new COutlookBar();
        bar.setAnimationSpeed(50);
        bar.addPanel("Panel", new JPanel());
        bar.addPanel("Button", new JButton("xxx"));
        bar.addPanel("Label", new JLabel("xxx"));
        bar.addPanel("Text", new JTextPane());
        bar.addPanel("Auto Panel");
        bar.removePanel(0);
        JFrame frame = new JFrame("Outlook Bar");
        frame.getContentPane().add(bar);
        frame.setSize(305, 320);
        frame.setLocation(200, 200);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    private class COutlookBarItem {
        private JButton button = null;
        private Component component = null;

        public COutlookBarItem(String name, Component component) {
            this.button = new JButton(name);
            this.component = component;
        }

        public JButton getButton() {
            return this.button;
        }

        public Component getComponent() {
            return this.component;
        }
    }

    private class CSweepThread
    extends Thread {
        private CSweepPanel sweep = null;

        public CSweepThread(CSweepPanel sweep) {
            this.sweep = sweep;
        }

        public void run() {
            while (this.sweep.step(20)) {
                this.sweep.revalidate();
                this.sweep.repaint();
                try {
                    Thread.sleep(COutlookBar.this.animationSpeed);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            COutlookBar.this.updateContent();
        }
    }

    private class CSweepPanel
    extends JPanel {
        private int y = 0;
        private int dir = 0;
        private JPanel topPanel = new JPanel();
        private JPanel centerPanel = new JPanel();
        private JPanel bottomPanel = new JPanel();
        private JPanel movePanel = new JPanel();

        public CSweepPanel() {
            this.setLayout(new BorderLayout());
            this.movePanel.setLayout(new BorderLayout());
            this.topPanel.setLayout(new BorderLayout());
            this.centerPanel.setLayout(new BorderLayout());
            this.bottomPanel.setLayout(new BorderLayout());
        }

        public void reset(Component first, Component second, Component central, int dir) {
            this.y = 0;
            this.dir = dir;
            this.removeAll();
            this.topPanel.removeAll();
            this.bottomPanel.removeAll();
            this.centerPanel.removeAll();
            this.centerPanel.add(central);
            if (dir >= 0) {
                this.topPanel.add(second);
                this.bottomPanel.add(first);
                this.movePanel.add((Component)this.topPanel, "Center");
                this.movePanel.add((Component)this.centerPanel, "South");
                this.add((Component)this.movePanel, "North");
                this.add((Component)this.bottomPanel, "Center");
            } else {
                this.topPanel.add(first);
                this.bottomPanel.add(second);
                this.movePanel.add((Component)this.bottomPanel, "Center");
                this.movePanel.add((Component)this.centerPanel, "North");
                this.add((Component)this.movePanel, "South");
                this.add((Component)this.topPanel, "Center");
            }
            this.topPanel.setPreferredSize(new Dimension(0, 0));
            this.bottomPanel.setPreferredSize(new Dimension(0, 0));
        }

        public boolean step(int dy) {
            this.y += dy;
            if (this.dir >= 0) {
                this.topPanel.setPreferredSize(new Dimension(0, this.y));
            } else {
                this.bottomPanel.setPreferredSize(new Dimension(0, this.y));
            }
            int ph = this.getSize().height - this.centerPanel.getPreferredSize().height;
            return this.y + dy < ph && ph != 0;
        }
    }
}

