/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoableEdit;

public class CEditor
extends JTextPane
implements UndoableEditListener {
    public ArrayList undoList = new ArrayList();
    public int undoPosition = -1;
    private boolean modified = false;

    public CEditor() {
        this.getDocument().addUndoableEditListener(this);
        Keymap map = CEditor.addKeymap("UndoMap", this.getKeymap());
        KeyStroke undo = KeyStroke.getKeyStroke(90, 2, false);
        KeyStroke redo = KeyStroke.getKeyStroke(90, 3, false);
        map.addActionForKeyStroke(undo, new UndoAction());
        map.addActionForKeyStroke(redo, new RedoAction());
        this.setKeymap(map);
    }

    public void undoableEditHappened(UndoableEditEvent e2) {
        UndoItem undoItem = new UndoItem(this.getCaretPosition(), e2.getEdit());
        int i2 = this.undoList.size() - 1;
        while (i2 > this.undoPosition) {
            this.undoList.remove(i2);
            --i2;
        }
        this.undoList.add(undoItem);
        ++this.undoPosition;
        this.modified = true;
    }

    public void discardUndo() {
        this.undoPosition = -1;
        this.undoList.clear();
        this.modified = false;
    }

    public void undo() {
        if (this.undoPosition >= 0) {
            UndoItem undoItem = (UndoItem)this.undoList.get(this.undoPosition);
            this.setCaretPosition(undoItem.position);
            undoItem.item.undo();
            --this.undoPosition;
            while (this.undoPosition >= 0) {
                UndoItem current = (UndoItem)this.undoList.get(this.undoPosition);
                if (!current.item.getPresentationName().equals(undoItem.item.getPresentationName()) || (!current.item.getPresentationName().startsWith("add") || undoItem.position - current.position != 1) && (!current.item.getPresentationName().startsWith("del") || current.position - undoItem.position != 1)) break;
                undoItem = current;
                undoItem.item.undo();
                --this.undoPosition;
            }
        }
        this.modified = this.undoPosition >= 0;
    }

    public void redo() {
        if (this.undoPosition + 1 < this.undoList.size()) {
            ++this.undoPosition;
            UndoItem undoItem = (UndoItem)this.undoList.get(this.undoPosition);
            undoItem.item.redo();
            this.setCaretPosition(undoItem.position);
            while (this.undoPosition + 1 < this.undoList.size()) {
                UndoItem current = (UndoItem)this.undoList.get(this.undoPosition + 1);
                if (!current.item.getPresentationName().equals(undoItem.item.getPresentationName()) || (!current.item.getPresentationName().startsWith("add") || current.position - undoItem.position != 1) && (!current.item.getPresentationName().startsWith("del") || undoItem.position - current.position != 1)) break;
                undoItem = current;
                undoItem.item.redo();
                ++this.undoPosition;
            }
        }
        this.modified = this.undoPosition >= 0;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void read(Reader in, Object desc) throws IOException {
        this.discardUndo();
        super.read(in, desc);
        this.getDocument().addUndoableEditListener(this);
    }

    public void write(Writer out) throws IOException {
        super.write(out);
        this.discardUndo();
        this.getDocument().addUndoableEditListener(this);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Comedia Editor Test");
        CEditor editor = new CEditor();
        editor.setText("xxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxx xxxxxxxxxx");
        JScrollPane scroll = new JScrollPane(editor);
        frame.getContentPane().add((Component)scroll, "Center");
        frame.setLocation(100, 100);
        frame.setSize(300, 300);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    private class RedoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e2) {
            CEditor.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e2) {
            CEditor.this.undo();
        }
    }

    private class UndoItem {
        public int position;
        public UndoableEdit item;

        public UndoItem(int position, UndoableEdit item) {
            this.position = position;
            this.item = item;
        }
    }
}

