/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class CColorComboBox
extends JComboBox {
    protected final CImageListModel model = new CImageListModel();

    public CColorComboBox() {
        this.setModel(this.model);
        this.setRenderer(new CImageCellRenderer());
        this.setSelectedIndex(0);
    }

    public Color getSelectedColor() {
        return this.model.getColor(this.getSelectedIndex());
    }

    public void setSelectedColor(Color color) {
        this.setSelectedIndex(this.model.getColorIndex(color));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e2) {
            // empty catch block
        }
        JFrame frame = new JFrame("Comedia Editor Test");
        CColorComboBox ctrl = new CColorComboBox();
        ctrl.setSelectedColor(new Color(25, 150, 100));
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(ctrl);
        frame.setLocation(100, 100);
        frame.setSize(300, 300);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    private static class CSquareIcon
    implements Icon {
        private Color color;

        public CSquareIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            g2.setColor(this.color);
            g2.fillRect(x2 + 2, y2, this.getIconWidth() - 2, this.getIconHeight());
            g2.setColor(Color.black);
            g2.drawRect(x2 + 2, y2, this.getIconWidth() - 2, this.getIconHeight());
        }

        public int getIconWidth() {
            return 25;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    private static class CImageCellRenderer
    implements ListCellRenderer {
        private boolean focused = false;
        private JLabel renderer = new JLabel();

        public CImageCellRenderer() {
            this.renderer.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.renderer.setText("");
                this.renderer.setIcon(null);
            } else {
                Hashtable h2 = (Hashtable)value;
                this.renderer.setText((String)h2.get("label"));
                this.renderer.setIcon((Icon)h2.get("icon"));
            }
            this.renderer.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.text);
            this.renderer.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
            return this.renderer;
        }
    }

    private static class CImageListModel
    extends DefaultComboBoxModel {
        private static final Color[] color = new Color[]{Color.black, new Color(132, 0, 0), new Color(0, 130, 0), new Color(132, 130, 0), new Color(0, 0, 132), new Color(132, 0, 132), new Color(0, 130, 132), Color.gray, Color.lightGray, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
        private static final String[] label = new String[]{"Black", "Maroon", "Green", "Olive", "Navy", "Purple", "Teal", "Gray", "Silver", "Red", "Lime", "Yellow", "Blue", "Fuchsia", "Aqua", "White"};

        public CImageListModel() {
            int i2 = 0;
            int n2 = label.length;
            while (i2 < n2) {
                CSquareIcon icon = new CSquareIcon(color[i2]);
                Hashtable<String, Object> result = new Hashtable<String, Object>();
                result.put("label", label[i2]);
                result.put("icon", icon);
                this.addElement(result);
                ++i2;
            }
        }

        public Color getColor(int index) {
            return color[index];
        }

        public int getColorIndex(Color c2) {
            int result = 0;
            int max = 1000;
            int i2 = 0;
            while (i2 < color.length) {
                Color current = color[i2];
                int n2 = Math.abs(current.getRed() - c2.getRed()) + Math.abs(current.getGreen() - c2.getGreen()) + Math.abs(current.getBlue() - c2.getBlue());
                if (n2 < max) {
                    max = n2;
                    result = i2;
                }
                ++i2;
            }
            return result;
        }
    }
}

