/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.text;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.comedia.text.CAbstractHighlighter;

public class CSyntaxDocument
extends DefaultStyledDocument {
    public CSyntaxDocument(AbstractDocument.Content c2, StyleContext styles) {
        super(c2, styles);
    }

    public CSyntaxDocument(StyleContext styles) {
        super(styles);
    }

    public CSyntaxDocument() {
        TabStop[] stops = new TabStop[500];
        int i2 = 0;
        while (i2 < 500) {
            TabStop t2;
            stops[i2] = t2 = new TabStop(i2 * 17);
            ++i2;
        }
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, new TabSet(stops));
        this.setParagraphAttributes(0, this.getLength(), attributes, true);
    }

    public void updateAttributes(int start, int end, AttributeSet s2) {
        AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, start, end - start, DocumentEvent.EventType.CHANGE);
        this.buffer.change(start, end - start, changes);
        int lastEnd = Integer.MAX_VALUE;
        int pos = start;
        while (pos < end) {
            Element run = this.getCharacterElement(pos);
            lastEnd = run.getEndOffset();
            MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
            attr.removeAttributes(attr);
            attr.addAttributes(s2);
            pos = lastEnd;
        }
        changes.end();
        this.fireChangedUpdate(changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void performHighlight(CAbstractHighlighter highlighter, int start, int end) {
        String commentTag = (String)highlighter.getCommentAttribute().getAttribute(StyleConstants.NameAttribute);
        commentTag = commentTag == null ? "Comment" : commentTag;
        try {
            this.writeLock();
            try {
                int pos = start;
                String text = this.getText(start, this.getLength() - start);
                highlighter.setBuffer(text);
                String token = highlighter.gotoNextToken();
                while (token.length() > 0) {
                    Element element;
                    String attrTag;
                    this.updateAttributes(pos, pos + token.length(), highlighter.getAttribute());
                    if ((pos += token.length()) <= end || commentTag.equals(attrTag = (String)(element = this.getCharacterElement(pos + 1)).getAttributes().getAttribute(StyleConstants.NameAttribute)) && !highlighter.isMultilineComment()) {
                        token = highlighter.gotoNextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }
}

