/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.text;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.comedia.util.scanner.CScanner;

public abstract class CAbstractHighlighter {
    protected MutableAttributeSet whiteSpaceAttr = new SimpleAttributeSet();
    protected MutableAttributeSet identAttr = new SimpleAttributeSet();
    protected MutableAttributeSet commentAttr = new SimpleAttributeSet();
    protected MutableAttributeSet delimAttr = new SimpleAttributeSet();
    protected MutableAttributeSet keywordAttr = new SimpleAttributeSet();
    protected MutableAttributeSet stringAttr = new SimpleAttributeSet();
    protected MutableAttributeSet numberAttr = new SimpleAttributeSet();
    protected CScanner scanner = new CScanner();

    public CAbstractHighlighter() {
        this.whiteSpaceAttr.addAttribute(StyleConstants.NameAttribute, "White");
        this.identAttr.addAttribute(StyleConstants.NameAttribute, "Indent");
        this.commentAttr.addAttribute(StyleConstants.NameAttribute, "Comment");
        this.delimAttr.addAttribute(StyleConstants.NameAttribute, "Delim");
        this.keywordAttr.addAttribute(StyleConstants.NameAttribute, "Keyword");
        this.stringAttr.addAttribute(StyleConstants.NameAttribute, "String");
        this.numberAttr.addAttribute(StyleConstants.NameAttribute, "Number");
        StyleConstants.setForeground(this.whiteSpaceAttr, Color.black);
        StyleConstants.setForeground(this.identAttr, Color.black);
        StyleConstants.setForeground(this.commentAttr, new Color(0, 130, 0));
        StyleConstants.setItalic(this.commentAttr, true);
        StyleConstants.setForeground(this.delimAttr, Color.black);
        StyleConstants.setForeground(this.keywordAttr, new Color(0, 0, 132));
        StyleConstants.setBold(this.keywordAttr, true);
        StyleConstants.setForeground(this.stringAttr, Color.blue);
        StyleConstants.setForeground(this.numberAttr, Color.blue);
        this.scanner.setShowComment(true);
        this.scanner.setShowEol(true);
        this.scanner.setShowString(true);
        this.scanner.setShowKeyword(true);
        this.scanner.setShowType(true);
        this.scanner.setShowSpace(true);
    }

    public MutableAttributeSet getWhiteSpaceAttribute() {
        return this.whiteSpaceAttr;
    }

    public void setWhiteSpaceAttribute(MutableAttributeSet attrs) {
        this.whiteSpaceAttr = attrs;
    }

    public MutableAttributeSet getIdentAttribute() {
        return this.identAttr;
    }

    public void setIdentAttribute(MutableAttributeSet attrs) {
        this.identAttr = attrs;
    }

    public MutableAttributeSet getCommentAttribute() {
        return this.commentAttr;
    }

    public void setCommentAttribute(MutableAttributeSet attrs) {
        this.commentAttr = attrs;
    }

    public MutableAttributeSet getDelimAttribute() {
        return this.delimAttr;
    }

    public void setDelimAttribute(MutableAttributeSet attrs) {
        this.delimAttr = attrs;
    }

    public MutableAttributeSet getKeywordAttribute() {
        return this.keywordAttr;
    }

    public void setKeywordAttribute(MutableAttributeSet attrs) {
        this.keywordAttr = attrs;
    }

    public MutableAttributeSet getStringAttribute() {
        return this.stringAttr;
    }

    public void setStringAttribute(MutableAttributeSet attrs) {
        this.stringAttr = attrs;
    }

    public MutableAttributeSet getNumberAttribute() {
        return this.numberAttr;
    }

    public void setNumberAttribute(MutableAttributeSet attrs) {
        this.numberAttr = attrs;
    }

    public void setBuffer(String buffer) {
        this.scanner.setBuffer(buffer);
    }

    public String gotoNextToken() {
        this.scanner.gotoNextToken();
        return this.scanner.getToken();
    }

    public String getToken() {
        return this.scanner.getToken();
    }

    public AttributeSet getAttribute() {
        block18: {
            block17: {
                int tokenType;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                tokenType = this.scanner.getTokenType();
                                if (this.scanner.getTokenType() == 1) {
                                    tokenType = 1;
                                }
                                if (tokenType == 2) break block13;
                                if (tokenType == 4) break block13;
                                if (tokenType != 4096) break block14;
                            }
                            return this.keywordAttr;
                        }
                        if (tokenType == 1) {
                            return this.commentAttr;
                        }
                        if (tokenType == 8) {
                            return this.identAttr;
                        }
                        if (tokenType == 0) break block15;
                        if (tokenType == 256) break block15;
                        if (tokenType == 224) break block15;
                        if (tokenType == 128) break block15;
                        if (tokenType != 32768) break block16;
                    }
                    return this.whiteSpaceAttr;
                }
                if (tokenType == 2048) {
                    return this.stringAttr;
                }
                if (tokenType == 512) break block17;
                if (tokenType != 1024) break block18;
            }
            return this.numberAttr;
        }
        return this.delimAttr;
    }

    protected int locateUnclosedComment(String text, int pos, String startSymbol, String endSymbol) {
        int endPos;
        int startPos = text.lastIndexOf(startSymbol, pos);
        return startPos > (endPos = text.lastIndexOf(endSymbol, pos)) ? startPos : -1;
    }

    public abstract int locateUnclosedComment(String var1, int var2);

    public boolean isMultilineComment() {
        return false;
    }
}

