/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class CVerticalFlowLayout
extends FlowLayout
implements Serializable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    private int hgap;
    private int vgap;
    private boolean hfill;
    private boolean vfill;

    public CVerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public CVerticalFlowLayout(boolean hfill, boolean vfill) {
        this(0, 5, 5, hfill, vfill);
    }

    public CVerticalFlowLayout(int align) {
        this(align, 5, 5, true, false);
    }

    public CVerticalFlowLayout(int align, boolean hfill, boolean vfill) {
        this(align, 5, 5, hfill, vfill);
    }

    public CVerticalFlowLayout(int align, int hgap, int vgap, boolean hfill, boolean vfill) {
        this.setAlignment(align);
        this.hgap = hgap;
        this.vgap = vgap;
        this.hfill = hfill;
        this.vfill = vfill;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        super.setHgap(hgap);
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        super.setVgap(vgap);
        this.vgap = vgap;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension tarsiz = new Dimension(0, 0);
        int i2 = 0;
        while (i2 < target.getComponentCount()) {
            Component m2 = target.getComponent(i2);
            if (m2.isVisible()) {
                Dimension d2 = m2.getPreferredSize();
                tarsiz.width = Math.max(tarsiz.width, d2.width);
                if (i2 > 0) {
                    tarsiz.height += this.vgap;
                }
                tarsiz.height += d2.height;
            }
            ++i2;
        }
        Insets insets = target.getInsets();
        tarsiz.width += insets.left + insets.right + this.hgap * 2;
        tarsiz.height += insets.top + insets.bottom + this.vgap * 2;
        return tarsiz;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension size = new Dimension(0, 0);
        int i2 = 0;
        while (i2 < container.getComponentCount()) {
            Component current = container.getComponent(i2);
            if (current.isVisible()) {
                Dimension d2 = current.getMinimumSize();
                if (size.width < d2.width) {
                    size.width = d2.width;
                }
                if (i2 > 0) {
                    size.height += this.vgap;
                }
                size.height += d2.height;
            }
            ++i2;
        }
        Insets insets = container.getInsets();
        size.width += insets.left + insets.right + this.hgap * 2;
        size.height += insets.top + insets.bottom + this.vgap * 2;
        return size;
    }

    public void setVerticalFill(boolean vfill) {
        this.vfill = vfill;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public void setHorizontalFill(boolean hfill) {
        this.hfill = hfill;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }

    private void arrange(Container container, int x2, int y2, int width, int height, int first, int last) {
        int align = this.getAlignment();
        Insets insets = container.getInsets();
        if (align == 1) {
            y2 += height / 2;
        }
        if (align == 2) {
            y2 += height;
        }
        int i2 = first;
        while (i2 < last) {
            Component current = container.getComponent(i2);
            Dimension d2 = current.getSize();
            if (current.isVisible()) {
                int px = x2 + (width - d2.width) / 2;
                current.setLocation(px, y2);
                y2 += this.vgap + d2.height;
            }
            ++i2;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int maxheight = container.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int maxwidth = container.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int numcomp = container.getComponentCount();
        int x2 = insets.left + this.hgap;
        int y2 = 0;
        int colw = 0;
        int start = 0;
        int i2 = 0;
        while (i2 < numcomp) {
            Component current = container.getComponent(i2);
            if (current.isVisible()) {
                Dimension d2 = current.getPreferredSize();
                if (this.vfill && i2 == numcomp - 1) {
                    d2.height = Math.max(maxheight - y2, current.getPreferredSize().height);
                }
                if (this.hfill) {
                    current.setSize(maxwidth, d2.height);
                    d2.width = maxwidth;
                } else {
                    current.setSize(d2.width, d2.height);
                }
                if (y2 + d2.height > maxheight) {
                    this.arrange(container, x2, insets.top + this.vgap, colw, maxheight - y2, start, i2);
                    y2 = d2.height;
                    x2 += this.hgap + colw;
                    colw = d2.width;
                    start = i2;
                } else {
                    if (y2 > 0) {
                        y2 += this.vgap;
                    }
                    y2 += d2.height;
                    colw = Math.max(colw, d2.width);
                }
            }
            ++i2;
        }
        this.arrange(container, x2, insets.top + this.vgap, colw, maxheight - y2, start, numcomp);
    }
}

