/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.game;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.comedia.game.CHighScores;

public class CTetris
extends JComponent
implements Runnable,
KeyListener,
MouseListener {
    private static final int DEFAULT_INSET_SIZE = 10;
    private static final int DEFAULT_X_CELL_NUMBER = 11;
    private static final int DEFAULT_Y_CELL_NUMBER = 20;
    private static final Color DEFAULT_BACK_COLOR = Color.lightGray;
    private static final int SPEEDUP = 50;
    private static final int MIN_DELAY = 200;
    private static final int MAX_DELAY = 1000;
    private int xCellNum = 11;
    private int yCellNum = 20;
    private int xInset;
    private int yInset;
    private int mapWidth;
    private int mapHeight;
    private int cellSide;
    private int scoreWidth;
    private CTetrisMap map = null;
    private int score = 0;
    private int figureCount = 0;
    private int lineCount = 0;
    private int delay = 1000;
    private Random random = new Random();
    private CFigure nextFigure = null;
    private CFigure currentFigure = null;
    private Thread thread = null;
    private boolean flick = true;
    private String message = "GAME OVER";
    private boolean active = false;
    private boolean over = true;
    protected CHighScores highScores = new CHighScores();

    public CTetris() {
        this.setRequestFocusEnabled(true);
        this.setOpaque(false);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.map = new CTetrisMap();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception e2) {
                // empty catch block
            }
            boolean bl = this.flick = !this.flick;
            if (this.active && !this.over) {
                this.stepDown();
                continue;
            }
            if (this.message.length() <= 0 || !this.flick) continue;
            this.repaint();
        }
    }

    synchronized void stepDown() {
        if (this.currentFigure == null) {
            return;
        }
        CFigure newFigure = new CFigure(this.currentFigure);
        newFigure.moveDown();
        if (!this.map.checkFit(newFigure)) {
            this.dropDown();
        } else {
            this.currentFigure = newFigure;
        }
        this.repaint();
    }

    void switchFigure() {
        if (this.nextFigure == null) {
            this.nextFigure = new CFigure(this.xCellNum / 2 - 1, 0);
            this.currentFigure = new CFigure(this.xCellNum / 2 - 1, 0);
        } else {
            this.currentFigure = this.nextFigure;
            this.nextFigure = new CFigure(this.xCellNum / 2 - 1, 0);
        }
        if (!this.map.checkFit(this.currentFigure)) {
            this.currentFigure = null;
            this.gameOver();
        }
    }

    public void startNewGame() {
        this.map = new CTetrisMap();
        this.figureCount = 0;
        this.lineCount = 0;
        this.score = 0;
        this.delay = 1000;
        this.active = true;
        this.over = false;
        this.message = "";
        this.nextFigure = null;
        this.switchFigure();
        this.repaint();
    }

    synchronized void dropDown() {
        do {
            this.currentFigure.moveDown();
        } while (this.map.checkFit(this.currentFigure));
        this.currentFigure.moveUp();
        this.map.addFigure(this.currentFigure);
        ++this.figureCount;
        int deadCount = this.map.checkMap();
        this.lineCount += deadCount;
        if (this.delay > 200) {
            this.delay -= 50 * deadCount;
        }
        if (this.delay < 200) {
            this.delay = 200;
        }
        this.score = this.lineCount * 50 + this.figureCount;
        this.switchFigure();
        this.repaint();
        if (!this.map.checkFit(this.currentFigure)) {
            this.gameOver();
        }
    }

    public void gameOver() {
        this.active = false;
        this.over = true;
        this.message = "GAME OVER";
        this.repaint();
        if (this.highScores.getMinimumScore() >= this.score && this.highScores.isFull()) {
            JOptionPane.showMessageDialog(null, "Your score is " + this.score, "Game Over", 1);
        } else {
            String player = JOptionPane.showInputDialog(null, "Congratulations!\nYou have reached " + this.score + " score", "Enter you name", 1);
            if (player != null) {
                this.highScores.addScore(player.trim(), this.score);
            }
        }
        this.startNewGame();
    }

    private void drawNextFigure(Graphics g2, int x2, int y2) {
        if (this.nextFigure != null) {
            this.nextFigure.draw(g2, x2, y2);
        }
    }

    public void paint(Graphics g2) {
        Font font = this.findFont(g2, "Score: 00000", this.scoreWidth, this.cellSide);
        g2.setFont(font);
        int xScoreOffs = this.xInset + this.mapWidth + 10;
        FontMetrics m2 = g2.getFontMetrics(g2.getFont());
        int fontHeight = m2.getHeight() - m2.getDescent() * 2;
        this.map.drawMap(g2);
        g2.setColor(Color.black);
        g2.drawRect(this.xInset, this.yInset - 1, this.mapWidth + 1, this.mapHeight + 1);
        if (this.currentFigure != null) {
            this.currentFigure.draw(g2, this.currentFigure.column * this.cellSide + this.xInset, this.currentFigure.row * this.cellSide + this.yInset);
        }
        if (this.message.length() > 0) {
            int xOffs = (this.mapWidth - m2.stringWidth(this.message)) / 2;
            int yOffs = (this.mapHeight - fontHeight) / 2;
            font = new Font(g2.getFont().getName(), 1, g2.getFont().getSize());
            g2.setColor(Color.white);
            g2.drawString(this.message, this.xInset + xOffs + 1, this.yInset + yOffs + 1);
            g2.setColor(Color.black);
            g2.drawString(this.message, this.xInset + xOffs, this.yInset + yOffs);
        }
        this.drawNextFigure(g2, xScoreOffs, this.yInset + fontHeight * 4);
        g2.setColor(Color.black);
        g2.drawString("Score: " + this.score, xScoreOffs, this.yInset + fontHeight);
        g2.drawString("Next:", xScoreOffs, this.yInset + fontHeight * 3);
        int yScoreOffs = this.yInset + fontHeight * 10;
        g2.drawString("High scores:", xScoreOffs, yScoreOffs);
        yScoreOffs += fontHeight / 2;
        int i2 = 0;
        while (i2 < this.highScores.getLength()) {
            g2.drawString(this.highScores.formatScore(i2, 5), xScoreOffs, yScoreOffs += fontHeight);
            ++i2;
        }
    }

    private Font findFont(Graphics g2, String s2, int w2, int h2) {
        FontMetrics m2;
        int size = 6;
        Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), size);
        while ((m2 = g2.getFontMetrics(font)).getHeight() <= h2 && m2.stringWidth(s2) <= w2) {
            font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++size);
        }
        return font;
    }

    public void doLayout() {
        Dimension d2 = this.getSize();
        Dimension dMap = new Dimension((int)((double)d2.width * 0.7), d2.height);
        Dimension dScore = new Dimension((int)((double)d2.width * 0.3), d2.height);
        this.xInset = 10;
        this.mapWidth = dMap.width - this.xInset * 2;
        this.yInset = 10;
        this.mapHeight = dMap.height - this.yInset * 2;
        this.scoreWidth = dScore.width - this.xInset;
        if (this.mapHeight > this.mapWidth / this.xCellNum * this.yCellNum) {
            this.cellSide = this.mapWidth / this.xCellNum;
            this.mapWidth = this.cellSide * this.xCellNum;
            this.mapHeight = this.cellSide * this.yCellNum;
            this.yInset = (dMap.height - this.mapHeight) / 2;
        } else {
            this.cellSide = this.mapHeight / this.yCellNum;
            this.mapWidth = this.cellSide * this.xCellNum;
            this.mapHeight = this.cellSide * this.yCellNum;
            this.xInset = (dMap.width - this.mapWidth) / 2;
        }
        this.repaint();
    }

    public void start() {
        this.active = true;
    }

    public void stop() {
        this.active = false;
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        CFigure newFigure = new CFigure(this.currentFigure);
        if (e2.getKeyCode() == 19) {
            this.active = !this.active;
            this.message = this.active ? "" : "PAUSED";
            this.repaint();
            return;
        }
        if (this.active && !this.over) {
            switch (e2.getKeyCode()) {
                case 37: {
                    newFigure.moveLeft();
                    break;
                }
                case 39: {
                    newFigure.moveRight();
                    break;
                }
                case 40: {
                    this.stepDown();
                    return;
                }
                case 38: {
                    newFigure.rotate();
                    break;
                }
                case 32: {
                    this.dropDown();
                    return;
                }
                default: {
                    return;
                }
            }
            if (this.map.checkFit(newFigure)) {
                this.currentFigure = newFigure;
            }
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
    }

    void drawBox(Graphics g2, Color c2, int x2, int y2) {
        int rx = x2 + this.cellSide - 1;
        int ry = y2 + this.cellSide - 1;
        if (c2 == DEFAULT_BACK_COLOR) {
            g2.setColor(DEFAULT_BACK_COLOR);
            g2.fillRect(x2, y2, this.cellSide, this.cellSide);
            g2.setColor(Color.gray);
            g2.drawLine(x2, y2, x2, ry);
        } else {
            g2.setColor(c2);
            g2.fillRect(x2, y2, this.cellSide, this.cellSide);
            g2.setColor(Color.black);
            g2.drawLine(x2, ry, rx, ry);
            g2.drawLine(rx, y2, rx, ry);
            g2.setColor(Color.white);
            g2.drawLine(x2, y2, rx, y2);
            g2.drawLine(x2, y2, x2, ry);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Tetris");
        CTetris tetris = new CTetris();
        frame.getContentPane().add((Component)tetris, "Center");
        frame.setSize(300, 500);
        frame.setLocation(300, 100);
        frame.setDefaultCloseOperation(3);
        frame.show();
        tetris.requestFocus();
        tetris.startNewGame();
    }

    protected class CHiScore {
        public String player = "";
        public int score = 0;

        protected CHiScore() {
        }
    }

    private class CTetrisMap {
        Color[][] cells = null;

        public CTetrisMap() {
            this.cells = new Color[CTetris.this.yCellNum][CTetris.this.xCellNum];
            this.clear();
        }

        public void clear() {
            int r2 = 0;
            while (r2 < CTetris.this.yCellNum) {
                int c2 = 0;
                while (c2 < CTetris.this.xCellNum) {
                    this.cells[r2][c2] = DEFAULT_BACK_COLOR;
                    ++c2;
                }
                ++r2;
            }
        }

        public void drawMap(Graphics g2) {
            int x2 = CTetris.this.xInset;
            int y2 = CTetris.this.yInset;
            int r2 = 0;
            while (r2 < CTetris.this.yCellNum) {
                int c2 = 0;
                while (c2 < CTetris.this.xCellNum) {
                    CTetris.this.drawBox(g2, this.cells[r2][c2], x2, y2);
                    x2 += CTetris.this.cellSide;
                    ++c2;
                }
                y2 += CTetris.this.cellSide;
                x2 = CTetris.this.xInset;
                ++r2;
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean checkFit(CFigure figure) {
            char ch;
            String Shape2 = figure.figureShapes[figure.currentShape];
            int i2 = 0;
            int column = figure.column;
            int row = figure.row;
            while ((ch = Shape2.charAt(i2++)) != '.') {
                void var6_6;
                if (var6_6 == 64 && (column < 0 || row < 0 || column >= CTetris.this.xCellNum || row >= CTetris.this.yCellNum || this.cells[row][column] != DEFAULT_BACK_COLOR)) {
                    return false;
                }
                ++column;
                if (var6_6 != 124) continue;
                ++row;
                column = figure.column;
            }
            return true;
        }

        private void removeRow(int row) {
            do {
                System.arraycopy(this.cells[row - 1], 0, this.cells[row], 0, this.cells[row - 1].length);
            } while (--row > 0);
        }

        public int checkMap() {
            int row = 1;
            int result = 0;
            do {
                int column = 0;
                while (column < CTetris.this.xCellNum) {
                    if (this.cells[row][column] == DEFAULT_BACK_COLOR) break;
                    ++column;
                }
                if (column != CTetris.this.xCellNum) continue;
                this.removeRow(row);
                ++result;
            } while (++row < CTetris.this.yCellNum);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public void addFigure(CFigure figure) {
            char ch;
            String shape = figure.figureShapes[figure.currentShape];
            int index = 0;
            int column = figure.column;
            int row = figure.row;
            while ((ch = shape.charAt(index++)) != '.') {
                void var6_6;
                if (var6_6 == 64) {
                    this.cells[row][column] = figure.figureColor;
                }
                ++column;
                if (var6_6 != 124) continue;
                ++row;
                column = figure.column;
            }
        }
    }

    private class CFigure {
        String[] figureShapes = new String[]{"@@@|@.", "@@| @| @.", "  @|@@@.", "@ |@ |@@.", "@@@|  @.", " @| @|@@.", "@  |@@@.", "@@|@ |@.", "@@ | @@.", " @|@@|@.", " @@|@@.", "@ |@@| @.", "@@@@.", "@|@|@|@.", "@@@| @.", " @|@@| @.", " @ |@@@.", "@ |@@|@.", "@@|@@.", "@@@|@  |@@@.", "@@@|@ @|@ @.", "@@@|  @|@@@.", "@ @|@ @|@@@.", "@ @|@ @|@@@.", "@@@|@  |@@@.", "@@@|@ @|@ @.", "@@@|  @|@@@.", "@@|@@|@ @.", "@@@| @@|@.", "@ @| @@| @@.", "  @|@@|@@@.", "@@@|@@|@@@.", "@@@|@@@|@ @.", "@@@| @@|@@@.", "@ @|@@@|@@@."};
        int[] baseShapes = new int[]{0, 4, 8, 10, 12, 14, 18, 19, 23, 27, 31};
        int[] maxShapes = new int[]{3, 7, 9, 11, 13, 17, 18, 22, 26, 30, 34};
        Color[] figureColors = new Color[]{Color.green, Color.blue, Color.cyan, Color.orange, Color.pink, Color.yellow, Color.magenta, Color.red, Color.red, Color.red, Color.red};
        int baseShape;
        int maxShape;
        int currentShape;
        int figureIndex;
        int row;
        int column;
        Color figureColor;

        /*
         * WARNING - void declaration
         */
        public void draw(Graphics g2, int x2, int y2) {
            char ch;
            String Shape2 = this.figureShapes[this.currentShape];
            int index = 0;
            int column = x2;
            while ((ch = Shape2.charAt(index++)) != '.') {
                void var7_7;
                if (var7_7 == 64) {
                    CTetris.this.drawBox(g2, this.figureColor, x2, y2);
                }
                x2 += CTetris.this.cellSide;
                if (var7_7 != 124) continue;
                y2 += CTetris.this.cellSide;
                x2 = column;
            }
        }

        public CFigure(int column, int row, int figureIndex) {
            this.column = column;
            this.row = row;
            this.figureIndex = figureIndex;
            this.baseShape = this.baseShapes[figureIndex];
            this.maxShape = this.maxShapes[figureIndex];
            this.currentShape = this.baseShape;
            this.figureColor = this.figureColors[figureIndex];
        }

        public CFigure(int column, int row) {
            this(column, row, Math.abs(this$0.random.nextInt()) % 7);
        }

        public CFigure(CFigure figure) {
            this(figure.column, figure.row, figure.figureIndex);
            this.currentShape = figure.currentShape;
        }

        void moveLeft() {
            --this.column;
        }

        void moveRight() {
            ++this.column;
        }

        void moveDown() {
            ++this.row;
        }

        void moveUp() {
            --this.row;
        }

        void rotate() {
            ++this.currentShape;
            if (this.currentShape > this.maxShape) {
                this.currentShape = this.baseShape;
            }
        }
    }
}

