/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.game;

public class CHighScores {
    public static final int MAX_SCORES = 5;
    private String[] players = new String[5];
    private int[] scores = new int[5];
    private int length = 0;

    public int getLength() {
        return this.length;
    }

    public String getPlayerName(int index) {
        return this.players[index];
    }

    public int getPlayerScore(int index) {
        return this.scores[index];
    }

    public int getMinimumScore() {
        if (this.length == 0) {
            return 0;
        }
        return this.scores[this.length - 1];
    }

    public boolean isFull() {
        return this.length >= 5;
    }

    public void clear() {
        this.length = 0;
    }

    public void addScore(String player, int score) {
        int i2;
        if (this.isFull() && score < this.getMinimumScore()) {
            return;
        }
        int pos = this.length;
        if (score > this.getMinimumScore()) {
            i2 = this.length - 1;
            while (i2 >= 0) {
                if (this.scores[i2] >= score) break;
                pos = i2--;
            }
        }
        i2 = this.length - 1;
        while (i2 >= pos) {
            if (i2 + 1 < 5) {
                this.scores[i2 + 1] = this.scores[i2];
                this.players[i2 + 1] = this.players[i2];
            }
            --i2;
        }
        this.scores[pos] = score;
        this.players[pos] = player;
        if (this.length < 5) {
            ++this.length;
        }
    }

    public String formatScore(int index, int length) {
        int end = this.players[index].length();
        if (end > length) {
            end = length;
        }
        String result = this.players[index].substring(0, end);
        while (result.length() <= length + 1) {
            result = result + " ";
        }
        return result + this.scores[index];
    }
}

