/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.db.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import org.comedia.db.view.CTableBox;
import org.comedia.ui.CEncodedIcon;

public class CTableLink
extends JComponent
implements FocusListener,
MouseListener {
    public static final int NORMAL_LINK = 0;
    public static final int JOIN_LINK = 1;
    public static final int UNKNOWN_RELATION = 0;
    public static final int ONE_RELATION = 1;
    public static final int MANY_RELATION = 2;
    private CTableBox leftTable = null;
    private CTableBox rightTable = null;
    private int leftFieldIndex = -1;
    private int rightFieldIndex = -1;
    private int leftLinkType = 0;
    private int rightLinkType = 0;
    private int leftRelation = 0;
    private int rightRelation = 0;
    private Point leftStart = new Point();
    private Point leftEnd = new Point();
    private Point rightStart = new Point();
    private Point rightEnd = new Point();
    private boolean draw = false;
    private boolean updated = false;
    private static final int LINE_SIZE = 17;
    private static final int MAX_DIST = 3;

    public CTableLink() {
        this.setSize(65, 65);
        this.setForeground(Color.gray);
        this.setOpaque(false);
        this.setRequestFocusEnabled(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public CTableBox getLeftTable() {
        return this.leftTable;
    }

    public void setLeftTable(CTableBox leftTable) {
        if (this.leftTable != leftTable) {
            if (this.leftTable != null) {
                this.leftTable.removeLink(this);
            }
            this.leftTable = leftTable;
            if (leftTable != null) {
                leftTable.addLink(this);
            }
            this.updated = false;
            this.updateShape();
        }
    }

    public CTableBox getRightTable() {
        return this.rightTable;
    }

    public void setRightTable(CTableBox rightTable) {
        if (this.rightTable != rightTable) {
            if (this.rightTable != null) {
                this.rightTable.removeLink(this);
            }
            this.rightTable = rightTable;
            if (rightTable != null) {
                rightTable.addLink(this);
            }
            this.updated = false;
            this.updateShape();
        }
    }

    public int getLeftFieldIndex() {
        return this.leftFieldIndex;
    }

    public void setLeftFieldIndex(int leftFieldIndex) {
        if (this.leftFieldIndex != leftFieldIndex) {
            this.leftFieldIndex = leftFieldIndex;
            this.updateShape();
        }
    }

    public int getRightFieldIndex() {
        return this.rightFieldIndex;
    }

    public void setRightFieldIndex(int rightFieldIndex) {
        if (this.rightFieldIndex != rightFieldIndex) {
            this.rightFieldIndex = rightFieldIndex;
            this.updateShape();
        }
    }

    public int getLeftLinkType() {
        return this.leftLinkType;
    }

    public void setLeftLinkType(int leftLinkType) {
        if (this.leftLinkType != leftLinkType) {
            this.leftLinkType = leftLinkType;
            this.repaint();
        }
    }

    public int getRightLinkType() {
        return this.rightLinkType;
    }

    public void setRightLinkType(int rightLinkType) {
        if (this.rightLinkType != rightLinkType) {
            this.rightLinkType = rightLinkType;
            this.repaint();
        }
    }

    public int getLeftRelation() {
        return this.leftRelation;
    }

    public void setLeftRelation(int leftRelation) {
        if (this.leftRelation != leftRelation) {
            this.leftRelation = leftRelation;
            this.repaint();
        }
    }

    public int getRightRelation() {
        return this.rightRelation;
    }

    private void setSelectedColor(boolean selected) {
        if (selected) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.gray);
        }
    }

    public void focusGained(FocusEvent e2) {
        this.setSelectedColor(true);
    }

    public void focusLost(FocusEvent e2) {
        this.setSelectedColor(false);
    }

    public void setRightRelation(int rightRelation) {
        if (this.rightRelation != rightRelation) {
            this.rightRelation = rightRelation;
            this.repaint();
        }
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.draw) {
            CEncodedIcon icon;
            g2.setColor(this.getForeground());
            g2.drawLine(this.leftStart.x, this.leftStart.y - 1, this.leftEnd.x, this.leftEnd.y - 1);
            g2.drawLine(this.leftStart.x, this.leftStart.y, this.leftEnd.x, this.leftEnd.y);
            g2.drawLine(this.leftStart.x, this.leftStart.y + 1, this.leftEnd.x, this.leftEnd.y + 1);
            g2.drawLine(this.leftEnd.x, this.leftEnd.y, this.rightStart.x, this.rightStart.y);
            g2.drawLine(this.rightStart.x, this.rightStart.y - 1, this.rightEnd.x, this.rightEnd.y - 1);
            g2.drawLine(this.rightStart.x, this.rightStart.y, this.rightEnd.x, this.rightEnd.y);
            g2.drawLine(this.rightStart.x, this.rightStart.y + 1, this.rightEnd.x, this.rightEnd.y + 1);
            if (this.leftLinkType == 1) {
                if (this.leftStart.x < this.leftEnd.x) {
                    icon = CEncodedIcon.SMALL_LEFT_ARROW;
                    icon.setColor(this.getForeground());
                    icon.paintIcon(this, g2, this.leftStart.x, this.leftStart.y - 3);
                } else {
                    icon = CEncodedIcon.SMALL_RIGHT_ARROW;
                    icon.setColor(this.getForeground());
                    icon.paintIcon(this, g2, this.leftEnd.x + 11, this.leftEnd.y - 3);
                }
            }
            if (this.leftRelation == 1) {
                icon = CEncodedIcon.ONE_SIGN;
                icon.setColor(this.getForeground());
                icon.paintIcon(this, g2, (this.leftStart.x + this.leftEnd.x) / 2 - 1, this.leftStart.y - 9);
            }
            if (this.leftRelation == 2) {
                icon = CEncodedIcon.MANY_SIGN;
                icon.setColor(this.getForeground());
                icon.paintIcon(this, g2, (this.leftStart.x + this.leftEnd.x) / 2 - 6, this.leftStart.y - 9);
            }
            if (this.rightLinkType == 1) {
                if (this.rightStart.x > this.rightEnd.x) {
                    icon = CEncodedIcon.SMALL_LEFT_ARROW;
                    icon.setColor(this.getForeground());
                    icon.paintIcon(this, g2, this.rightEnd.x, this.rightEnd.y - 3);
                } else {
                    icon = CEncodedIcon.SMALL_RIGHT_ARROW;
                    icon.setColor(this.getForeground());
                    icon.paintIcon(this, g2, this.rightStart.x + 11, this.rightStart.y - 3);
                }
            }
            if (this.rightRelation == 1) {
                icon = CEncodedIcon.ONE_SIGN;
                icon.setColor(this.getForeground());
                icon.paintIcon(this, g2, (this.rightStart.x + this.rightEnd.x) / 2 - 1, this.rightStart.y - 9);
            }
            if (this.rightRelation == 2) {
                icon = CEncodedIcon.MANY_SIGN;
                icon.setColor(this.getForeground());
                icon.paintIcon(this, g2, (this.rightStart.x + this.rightEnd.x) / 2 - 6, this.rightStart.y - 9);
            }
        }
    }

    private Rect getBoundRect(Component control) {
        Point cp = control.getLocationOnScreen();
        if (this.getParent() != null) {
            Point pp = this.getParent().getLocationOnScreen();
            cp.x -= pp.x;
            cp.y -= pp.y;
        }
        return new Rect(cp.x - 17, cp.y, cp.x + control.getWidth() + 17, cp.y + control.getHeight());
    }

    private Point convertParentToOwn(Point point) {
        if (this.getParent() != null) {
            point.x -= this.getLocationOnScreen().x - this.getParent().getLocationOnScreen().x;
            point.y -= this.getLocationOnScreen().y;
        }
        return point;
    }

    public void updateShape() {
        if (!this.isShowing()) {
            return;
        }
        if (this.leftTable != null && this.rightTable != null) {
            Rect rect1 = this.getBoundRect(this.leftTable);
            Rect rect2 = this.getBoundRect(this.rightTable);
            Rect rect = new Rect(0, 0, 0, 0);
            if (rect1.left <= rect2.left) {
                rect.left = Math.min(rect1.right - 17, rect2.left);
                rect.right = Math.max(rect1.right, rect2.left + 17);
            } else {
                rect.left = Math.min(rect1.left, rect2.right - 17);
                rect.right = Math.max(rect1.left + 17, rect2.right);
            }
            rect.left = rect.left;
            rect.right = rect.right;
            rect.top = Math.min(rect1.top, rect2.top);
            rect.bottom = Math.max(rect1.bottom, rect2.bottom);
            this.setLocation(rect.left, rect.top);
            this.setSize(rect.right - rect.left, rect.bottom - rect.top);
            this.leftEnd.y = this.leftStart.y = this.leftTable.getItemPos(this.leftFieldIndex);
            this.rightEnd.y = this.rightStart.y = this.rightTable.getItemPos(this.rightFieldIndex);
            if (rect1.left <= rect2.left) {
                this.leftStart.x = rect1.right - 17;
                this.leftEnd.x = rect1.right;
                this.rightStart.x = rect2.left;
                this.rightEnd.x = rect2.left + 17;
            } else {
                this.leftStart.x = rect1.left + 17;
                this.leftEnd.x = rect1.left;
                this.rightStart.x = rect2.right;
                this.rightEnd.x = rect2.right - 17;
            }
            this.leftStart = this.convertParentToOwn(this.leftStart);
            this.leftEnd = this.convertParentToOwn(this.leftEnd);
            this.rightStart = this.convertParentToOwn(this.rightStart);
            this.rightEnd = this.convertParentToOwn(this.rightEnd);
            this.draw = true;
        } else {
            this.draw = false;
        }
        this.updated = true;
        this.repaint();
    }

    private boolean checkInterval(double start, double end, double value) {
        if (start <= end) {
            return start <= value && end >= value;
        }
        return end <= value && start >= value;
    }

    private boolean checkLine(Point start, Point end, Point point) {
        double x1 = start.x;
        double y1 = start.y;
        double x2 = end.x;
        double y2 = end.y;
        double x3 = point.x;
        double y3 = point.y;
        double a1 = y2 - y1;
        double b1 = -(x2 - x1);
        double c1 = a1 * x2 + b1 * y2;
        double a2 = x2 - x1;
        double b2 = y2 - y1;
        double c2 = a2 * x3 + b2 * y3;
        double x4 = (c2 * b1 - c1 * b2) / (a2 * b1 - a1 * b2);
        double y4 = b1 != 0.0 ? (c1 - a1 * x4) / b1 : y3;
        double d2 = Math.sqrt(Math.pow(x3 - x4, 2.0) + Math.pow(y3 - y4, 2.0));
        return d2 <= 3.0 && this.checkInterval(x1, x2, x4) && this.checkInterval(y1, y2, y4);
    }

    private boolean checkOver(Point point) {
        return this.checkLine(this.leftStart, this.leftEnd, point) || this.checkLine(this.leftEnd, this.rightStart, point) || this.checkLine(this.rightStart, this.rightEnd, point);
    }

    public boolean contains(int x2, int y2) {
        return this.checkOver(new Point(x2, y2));
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    private class Rect {
        public int left;
        public int right;
        public int top;
        public int bottom;

        public Rect(int left, int top, int right, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }
    }
}

