/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.db.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.comedia.db.view.CTableLink;

public class CTableBox
extends JPanel
implements MouseMotionListener,
MouseListener,
FocusListener,
AdjustmentListener {
    private JLabel label = new JLabel();
    private JList listBox = new JList();
    private JScrollPane scroller = new JScrollPane();
    private Point resizePoint;
    private Point reposPoint;
    private int quadrant;
    private Object[] fields;
    private ArrayList links = new ArrayList();
    private static final int CONNER_SIZE = 5;

    public CTableBox() {
        this.setMinimumSize(new Dimension(95, 26));
        this.setSize(new Dimension(112, 112));
        this.setPreferredSize(new Dimension(112, 112));
        this.setRequestFocusEnabled(true);
        BorderLayout layout = new BorderLayout();
        layout.setVgap(3);
        this.setLayout(layout);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(148, 145, 140), new Color(103, 101, 98)), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setBorder(border);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.add((Component)this.label, "North");
        this.label.setFont(new Font("Dialog", 0, 11));
        this.label.setOpaque(true);
        this.label.setCursor(new Cursor(0));
        this.label.addMouseListener(this);
        this.label.addMouseMotionListener(this);
        this.setSelectedColor(false);
        this.listBox.addFocusListener(this);
        this.listBox.setFont(this.label.getFont());
        this.listBox.setCursor(new Cursor(0));
        this.scroller.setViewportView(this.listBox);
        this.scroller.getVerticalScrollBar().addAdjustmentListener(this);
        this.add((Component)this.scroller, "Center");
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    private void setSelectedColor(boolean selected) {
        if (selected) {
            this.label.setBackground(new Color(0, 0, 100));
            this.label.setForeground(Color.white);
        } else {
            this.label.setBackground(Color.gray);
            this.label.setForeground(Color.lightGray);
        }
    }

    public Object[] getFields() {
        return this.fields;
    }

    public void setFields(Object[] fields) {
        this.listBox.setListData(fields);
        this.fields = fields;
    }

    public void focusGained(FocusEvent e2) {
        this.listBox.requestFocus();
        this.setSelectedColor(true);
    }

    public void focusLost(FocusEvent e2) {
        this.setSelectedColor(false);
    }

    public void mouseDragged(MouseEvent e2) {
        if (e2.getSource() == this) {
            this.borderMouseDragged(e2);
        } else if (e2.getSource() == this.label) {
            this.labelMouseDragged(e2);
        }
    }

    public void mouseMoved(MouseEvent e2) {
        if (e2.getSource() == this) {
            this.borderMouseMoved(e2);
        }
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        this.listBox.requestFocus();
        if (e2.getSource() == this) {
            this.quadrant = this.countQuadrant(e2.getPoint());
            this.resizePoint = e2.getPoint();
        } else if (e2.getSource() == this.label) {
            this.label.setCursor(new Cursor(13));
            this.reposPoint = e2.getPoint();
        }
    }

    public void mouseReleased(MouseEvent e2) {
        if (e2.getSource() == this.label) {
            this.label.setCursor(new Cursor(0));
        }
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void adjustmentValueChanged(AdjustmentEvent e2) {
        this.updateLinks();
    }

    private int countQuadrant(Point point) {
        int result = 2;
        if (point.x <= 5) {
            result = 1;
        } else if (point.x >= this.getWidth() - 5) {
            result = 3;
        }
        if (point.y > 5) {
            result = point.y < this.getHeight() - 5 ? (result += 3) : (result += 6);
        }
        return result;
    }

    public void borderMouseMoved(MouseEvent e2) {
        switch (this.countQuadrant(e2.getPoint())) {
            case 1: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 2: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(11));
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void borderMouseDragged(MouseEvent e2) {
        Point pos = this.getLocation();
        Dimension dim = this.getSize();
        boolean resized = false;
        int dx = e2.getPoint().x - this.resizePoint.x;
        int dy = e2.getPoint().y - this.resizePoint.y;
        switch (this.quadrant) {
            case 1: 
            case 4: 
            case 7: {
                if (dim.width - dx < this.getMinimumSize().width) break;
                pos.x += dx;
                dim.width -= dx;
                resized = true;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                if (dim.width + dx >= this.getMinimumSize().width) {
                    dim.width += dx;
                }
                resized = true;
            }
        }
        switch (this.quadrant) {
            case 1: 
            case 2: 
            case 3: {
                if (dim.height - dy < this.getMinimumSize().height) break;
                pos.y += dy;
                dim.height -= dy;
                resized = true;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                if (dim.height + dy >= this.getMinimumSize().height) {
                    dim.height += dy;
                }
                resized = true;
            }
        }
        if (resized) {
            this.setLocation(pos);
            this.setSize(dim);
            this.updateLinks();
            this.validate();
        }
        if (this.quadrant == 3 || this.quadrant == 6 || this.quadrant == 9) {
            this.resizePoint.x = e2.getPoint().x;
        }
        if (this.quadrant == 7 || this.quadrant == 8 || this.quadrant == 9) {
            this.resizePoint.y = e2.getPoint().y;
        }
    }

    public void labelMouseDragged(MouseEvent e2) {
        Point pos = this.getLocation();
        pos.x += e2.getPoint().x - this.reposPoint.x;
        pos.y += e2.getPoint().y - this.reposPoint.y;
        this.setLocation(pos);
        this.updateLinks();
    }

    public void addLink(CTableLink link) {
        this.links.add(link);
        link.updateShape();
    }

    public void clearLinks() {
        this.links.clear();
    }

    public void removeLink(CTableLink link) {
        this.links.remove(link);
    }

    public void updateLinks() {
        int i2 = 0;
        while (i2 < this.links.size()) {
            try {
                ((CTableLink)this.links.get(i2)).updateShape();
            }
            catch (Exception e2) {
                // empty catch block
            }
            ++i2;
        }
    }

    public void updateNewLinks() {
        int i2 = 0;
        while (i2 < this.links.size()) {
            try {
                CTableLink link = (CTableLink)this.links.get(i2);
                if (!link.isUpdated()) {
                    link.updateShape();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            ++i2;
        }
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        this.updateNewLinks();
    }

    public int getItemPos(int index) {
        int y2;
        if (index < 0) {
            y2 = this.getHeight() / 2;
        } else if (index < this.listBox.getFirstVisibleIndex() || this.listBox.getVisibleRowCount() <= 0 || this.scroller.getHeight() <= 3) {
            y2 = this.label.getLocation().y + this.label.getHeight() / 2;
        } else if (index > this.listBox.getLastVisibleIndex() && this.listBox.getLastVisibleIndex() >= 0) {
            y2 = this.getHeight() - 4;
        } else {
            Rectangle rect = this.listBox.getCellBounds(index, index);
            y2 = this.scroller.getLocation().y + this.listBox.getLocation().y + rect.y + rect.height / 2;
        }
        return this.getLocationOnScreen().y + y2;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e2) {
            // empty catch block
        }
        JFrame frame = new JFrame("Test Table View Application");
        frame.getContentPane().setLayout(null);
        frame.getContentPane().setBackground(Color.white);
        Object[] fields = new String[]{"Field1", "Field2", "Field3", "Field4", "Field5", "Field6"};
        CTableBox table1 = new CTableBox();
        table1.setLocation(50, 50);
        table1.setTitle("The First Table");
        table1.setFields(fields);
        CTableBox table2 = new CTableBox();
        table2.setLocation(250, 250);
        table2.setTitle("The Second Table");
        table2.setFields(fields);
        CTableLink link = new CTableLink();
        link.setLeftTable(table1);
        link.setLeftLinkType(1);
        link.setLeftRelation(1);
        link.setLeftFieldIndex(0);
        link.setRightTable(table2);
        link.setRightLinkType(1);
        link.setRightRelation(2);
        link.setRightFieldIndex(5);
        link.setLocation(150, 150);
        link.setSize(100, 100);
        frame.getContentPane().add(table1);
        frame.getContentPane().add(table2);
        frame.getContentPane().add(link);
        JButton button = new JButton("OK");
        button.setSize(50, 50);
        button.setLocation(100, 100);
        frame.getContentPane().add(button);
        frame.setSize(500, 500);
        frame.setLocation(100, 100);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }
}

