/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.beans;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CDigitalClock
extends JComponent {
    private ClockThread clockThread = new ClockThread();
    private String delimiter = ":";
    private boolean showDate = true;

    public CDigitalClock() {
        this.clockThread.start();
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public void setShowDate(boolean showDate) {
        this.showDate = showDate;
        this.repaint();
    }

    private Font findFont(Graphics g2, String s2, int w2, int h2) {
        FontMetrics m2;
        int size = 6;
        Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), size);
        while ((m2 = g2.getFontMetrics(font)).getHeight() <= h2 && m2.stringWidth(s2) <= w2) {
            font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++size);
        }
        return font;
    }

    public void paint(Graphics g2) {
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat format = new SimpleDateFormat();
        double timeRate = this.showDate ? 0.5 : 0.8;
        Dimension d2 = this.getSize();
        g2.clearRect(0, 0, d2.width, d2.height);
        format.applyPattern("HH" + this.delimiter + "mm");
        String strTime = format.format(calendar.getTime());
        Font font = this.findFont(g2, strTime, (int)(d2.getWidth() * 0.8), (int)(d2.getHeight() * timeRate));
        FontMetrics m2 = g2.getFontMetrics(font);
        int x2 = (d2.width - m2.stringWidth(strTime)) / 2;
        int y2 = (int)((d2.getHeight() * timeRate - (double)m2.getHeight()) / 2.0 + d2.getHeight() * 0.1) + m2.getAscent();
        g2.setFont(font);
        g2.drawString(strTime, x2, y2);
        if (this.showDate) {
            format.applyPattern("EEEE, dd MMMM yyyy");
            String strDate = format.format(calendar.getTime());
            font = this.findFont(g2, strDate, (int)(d2.getWidth() * 0.8), (int)(d2.getHeight() * 0.3));
            m2 = g2.getFontMetrics(font);
            x2 = (d2.width - m2.stringWidth(strDate)) / 2;
            y2 = (int)((d2.getHeight() * 0.3 - (double)m2.getHeight()) / 2.0 + d2.getHeight() * 0.6) + m2.getAscent();
            g2.setFont(font);
            g2.drawString(strDate, x2, y2);
        }
    }

    public static void main(String[] args) {
        CDigitalClock digitalClock = new CDigitalClock();
        JFrame frame = new JFrame("Digital Clock");
        frame.setContentPane(digitalClock);
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        frame.setLocation(300, 300);
        frame.show();
    }

    private class ClockThread
    extends Thread {
        private ClockThread() {
        }

        public void run() {
            while (true) {
                try {
                    CDigitalClock.this.delimiter = CDigitalClock.this.delimiter != ":" ? ":" : " ";
                    CDigitalClock.this.repaint();
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                }
            }
        }
    }
}

