/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.comedia.event.CSpinEvent;
import org.comedia.event.CSpinListener;
import org.comedia.ui.CSpinEdit;

public class CCalendar
extends JComponent
implements ActionListener,
CSpinListener,
FocusListener {
    private final int startYear = 1900;
    private final int endYear = 2100;
    private boolean enabled = true;
    GregorianCalendar calendar = new GregorianCalendar();
    DateFormatSymbols format = new DateFormatSymbols();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel monthPanel = new JPanel();
    JComboBox monthComboBox;
    CSpinEdit yearComboBox = new CSpinEdit();
    GridLayout gridLayout1 = new GridLayout();
    Border border1;
    JPanel dayPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border2;
    TitledBorder titledBorder1;
    CalendarPanel calendarPanel = new CalendarPanel();

    public CCalendar() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public CCalendar(Date date) {
        this();
        this.setDate(date);
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
        this.monthComboBox.setSelectedIndex(this.calendar.get(2));
        this.yearComboBox.setValue(this.calendar.get(1));
        this.calendarPanel.repaint();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.yearComboBox.setEnabled(enabled);
        this.monthComboBox.setEnabled(enabled);
    }

    private void jbInit() throws Exception {
        this.monthComboBox = new JComboBox<String>(this.format.getMonths());
        this.monthComboBox.setSelectedIndex(this.calendar.get(2));
        this.monthComboBox.addActionListener(this);
        this.yearComboBox.setMinimum(1900);
        this.yearComboBox.setMaximum(2100);
        this.yearComboBox.setValue(this.calendar.get(1));
        this.yearComboBox.getTextField().addActionListener(this);
        this.yearComboBox.getTextField().addFocusListener(this);
        this.yearComboBox.getTextField().setHorizontalAlignment(2);
        this.yearComboBox.getSpinButton().addSpinListener(this);
        this.border1 = BorderFactory.createEmptyBorder(11, 11, 11, 11);
        this.border2 = BorderFactory.createEmptyBorder(0, 11, 11, 11);
        this.titledBorder1 = new TitledBorder("");
        this.setLayout(this.borderLayout1);
        this.monthPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(11);
        this.gridLayout1.setVgap(5);
        this.monthPanel.setBorder(this.border1);
        this.dayPanel.setLayout(this.borderLayout2);
        this.dayPanel.setBorder(this.border2);
        this.add((Component)this.monthPanel, "North");
        this.monthPanel.add((Component)this.monthComboBox, null);
        this.monthPanel.add((Component)this.yearComboBox, null);
        this.add((Component)this.dayPanel, "Center");
        this.dayPanel.add((Component)this.calendarPanel, "Center");
    }

    public void actionPerformed(ActionEvent e2) {
        int month = this.monthComboBox.getSelectedIndex();
        int year = this.yearComboBox.getValue();
        int day = this.calendar.get(5);
        this.calendar.set(5, 1);
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        if (day > this.calendar.getActualMaximum(5)) {
            this.calendar.set(5, this.calendar.getActualMaximum(5));
        } else {
            this.calendar.set(5, day);
        }
        this.calendarPanel.repaint();
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
        this.actionPerformed(null);
    }

    public void spinEventPerformed(CSpinEvent event) {
        this.actionPerformed(null);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e2) {
            // empty catch block
        }
        CCalendar calendar = new CCalendar();
        JFrame frame = new JFrame("Gregorian Calendar");
        frame.setContentPane(calendar);
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        frame.setLocation(300, 300);
        frame.show();
    }

    private class CalendarPanel
    extends JPanel
    implements MouseListener {
        public CalendarPanel() {
            this.addMouseListener(this);
        }

        public void mousePressed(MouseEvent e2) {
            int dn;
            Dimension d2 = this.getSize();
            int dx = d2.width / 7;
            int dy = d2.height / 7;
            int c2 = e2.getX() / dx;
            int r2 = e2.getY() / dy;
            if (r2 == 0 || !CCalendar.this.enabled) {
                return;
            }
            if ((dn = --r2 * 7 + c2 + this.findFirstDay()) > 0 && dn <= CCalendar.this.calendar.getActualMaximum(5)) {
                CCalendar.this.calendar.set(5, dn);
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e2) {
        }

        public void mouseEntered(MouseEvent e2) {
        }

        public void mouseExited(MouseEvent e2) {
        }

        public void mouseClicked(MouseEvent e2) {
        }

        private Font findFont(Graphics g2, String s2, int w2, int h2) {
            FontMetrics m2;
            int size = 6;
            Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), size);
            while ((m2 = g2.getFontMetrics(font)).getHeight() <= h2 && m2.stringWidth(s2) <= w2) {
                font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++size);
            }
            return font;
        }

        private int findFirstDay() {
            int d2;
            int w2 = CCalendar.this.calendar.get(7);
            for (d2 = CCalendar.this.calendar.get(5); d2 > 1 || w2 != CCalendar.this.calendar.getFirstDayOfWeek(); --d2) {
                w2 = --w2 < 1 ? 7 : w2;
            }
            return d2;
        }

        public void paint(Graphics g2) {
            Dimension d2 = this.getSize();
            int dx = d2.width / 7;
            int dy = d2.height / 7;
            Font font = this.findFont(g2, "Www", dx, dy);
            g2.setFont(font);
            int selectedDay = CCalendar.this.calendar.get(5);
            g2.setColor(Color.white);
            g2.fillRect(0, 0, d2.width, d2.height);
            g2.setColor(Color.gray);
            g2.fillRect(0, 0, d2.width, dy);
            int dn = this.findFirstDay();
            int w2 = CCalendar.this.calendar.getFirstDayOfWeek();
            FontMetrics metrics = g2.getFontMetrics(font);
            int i2 = 0;
            while (i2 < 7) {
                int j2 = 0;
                while (j2 < 7) {
                    String s2;
                    int x2 = j2 * dx;
                    int y2 = i2 * dy;
                    if (i2 == 0) {
                        g2.setColor(Color.white);
                        s2 = CCalendar.this.format.getShortWeekdays()[w2];
                        w2 = ++w2 > 7 ? 1 : w2;
                    } else {
                        if (dn == selectedDay) {
                            g2.setColor(Color.blue);
                            g2.fillRect(x2, y2, dx, dy);
                        }
                        if (dn == selectedDay) {
                            g2.setColor(Color.white);
                        } else {
                            g2.setColor(Color.black);
                        }
                        s2 = dn > 0 && dn <= CCalendar.this.calendar.getActualMaximum(5) ? new Integer(dn).toString() : "";
                        ++dn;
                    }
                    g2.drawString(s2, x2 += (dx - metrics.stringWidth(s2)) / 2, (y2 += (dy - metrics.getHeight()) / 2) + metrics.getAscent());
                    ++j2;
                }
                ++i2;
            }
            g2.draw3DRect(0, 0, d2.width - 1, d2.height - 1, false);
        }
    }
}

