/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CCalculator
extends JComponent
implements ActionListener,
KeyListener {
    Border border1;
    JPanel stubPanel = new JPanel();
    JButton sqrtButton = new JButton();
    JButton eightButton = new JButton();
    JButton cButton = new JButton();
    JButton equalButton = new JButton();
    JPanel controlPanel = new JPanel();
    JPanel memPanel = new JPanel();
    JButton addButton = new JButton();
    JButton subButton = new JButton();
    JButton fiveButton = new JButton();
    JPanel numPanel = new JPanel();
    JButton nineButton = new JButton();
    JButton sixButton = new JButton();
    JButton backspaceButton = new JButton();
    JPanel commonPanel = new JPanel();
    JButton dotButton = new JButton();
    JButton zeroButton = new JButton();
    JButton invButton = new JButton();
    JButton sevenButton = new JButton();
    JButton procButton = new JButton();
    JButton mcButton = new JButton();
    JButton mpButton = new JButton();
    JButton msButton = new JButton();
    JButton mrButton = new JButton();
    JButton mulButton = new JButton();
    JPanel buttonPanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel subctrlPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton forthButton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JButton threeButton = new JButton();
    JButton twoButton = new JButton();
    JButton negButton = new JButton();
    JButton ceButton = new JButton();
    JTextField indicatorText = new JTextField();
    JButton divButton = new JButton();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    GridLayout gridLayout1 = new GridLayout();
    JButton oneButton = new JButton();
    BorderLayout borderLayout4 = new BorderLayout();
    Border border2;
    JLabel memoryLabel = new JLabel();
    BorderLayout borderLayout5 = new BorderLayout();
    private final int UNKNOWN = 0;
    private final int ADD = 1;
    private final int SUB = 2;
    private final int MUL = 3;
    private final int DIV = 4;
    private final int OTHER = 5;
    private boolean first = true;
    private boolean minus = false;
    private boolean comma = false;
    private String value = "0";
    private boolean error = false;
    private boolean stored = false;
    private double memory = 0.0;
    private double buffer = 0.0;
    private int operation = 0;
    private boolean update = false;
    private boolean newop = true;
    private double oldvalue = 0.0;

    public CCalculator() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border2 = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.oneButton.setText("1");
        this.oneButton.setActionCommand("One");
        this.oneButton.setMargin(new Insets(0, 0, 0, 0));
        this.oneButton.setMinimumSize(new Dimension(0, 0));
        this.oneButton.setNextFocusableComponent(this.zeroButton);
        this.oneButton.setFont(new Font("SansSerif", 0, 12));
        this.oneButton.setForeground(Color.blue);
        this.oneButton.setMaximumSize(new Dimension(255, 255));
        this.gridLayout1.setVgap(5);
        this.gridLayout1.setHgap(5);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(4);
        this.gridLayout2.setVgap(5);
        this.gridLayout2.setHgap(5);
        this.gridLayout2.setColumns(5);
        this.gridLayout2.setRows(4);
        this.gridLayout3.setVgap(5);
        this.gridLayout3.setHgap(5);
        this.gridLayout3.setColumns(3);
        this.divButton.setText("/");
        this.divButton.setActionCommand("Div");
        this.divButton.setMargin(new Insets(0, 0, 0, 0));
        this.divButton.setMinimumSize(new Dimension(0, 0));
        this.divButton.setNextFocusableComponent(this.mulButton);
        this.divButton.setFont(new Font("SansSerif", 0, 12));
        this.divButton.setForeground(Color.red);
        this.divButton.setMaximumSize(new Dimension(255, 255));
        this.indicatorText.setHorizontalAlignment(4);
        this.indicatorText.setRequestFocusEnabled(false);
        this.indicatorText.setToolTipText("");
        this.indicatorText.setEditable(false);
        this.indicatorText.setText("0.");
        this.ceButton.setText("CE");
        this.ceButton.setActionCommand("CE");
        this.ceButton.setMargin(new Insets(0, 0, 0, 0));
        this.ceButton.setMinimumSize(new Dimension(0, 0));
        this.ceButton.setNextFocusableComponent(this.cButton);
        this.ceButton.setFont(new Font("SansSerif", 0, 12));
        this.ceButton.setForeground(Color.red);
        this.ceButton.setMaximumSize(new Dimension(255, 255));
        this.negButton.setText("+/-");
        this.negButton.setActionCommand("Neg");
        this.negButton.setMargin(new Insets(0, 0, 0, 0));
        this.negButton.setMinimumSize(new Dimension(0, 0));
        this.negButton.setNextFocusableComponent(this.nineButton);
        this.negButton.setFont(new Font("SansSerif", 0, 12));
        this.negButton.setForeground(Color.blue);
        this.negButton.setMaximumSize(new Dimension(255, 255));
        this.twoButton.setText("2");
        this.twoButton.setActionCommand("Two");
        this.twoButton.setMargin(new Insets(0, 0, 0, 0));
        this.twoButton.setMinimumSize(new Dimension(0, 0));
        this.twoButton.setNextFocusableComponent(this.negButton);
        this.twoButton.setFont(new Font("SansSerif", 0, 12));
        this.twoButton.setForeground(Color.blue);
        this.twoButton.setMaximumSize(new Dimension(255, 255));
        this.threeButton.setText("3");
        this.threeButton.setActionCommand("Three");
        this.threeButton.setMargin(new Insets(0, 0, 0, 0));
        this.threeButton.setMinimumSize(new Dimension(0, 0));
        this.threeButton.setNextFocusableComponent(this.dotButton);
        this.threeButton.setFont(new Font("SansSerif", 0, 12));
        this.threeButton.setForeground(Color.blue);
        this.threeButton.setMaximumSize(new Dimension(255, 255));
        this.borderLayout1.setVgap(11);
        this.forthButton.setText("4");
        this.forthButton.setActionCommand("Forth");
        this.forthButton.setMargin(new Insets(0, 0, 0, 0));
        this.forthButton.setMinimumSize(new Dimension(0, 0));
        this.forthButton.setNextFocusableComponent(this.oneButton);
        this.forthButton.setFont(new Font("SansSerif", 0, 12));
        this.forthButton.setForeground(Color.blue);
        this.forthButton.setMaximumSize(new Dimension(255, 255));
        this.borderLayout2.setVgap(11);
        this.borderLayout2.setHgap(11);
        this.subctrlPanel.setOpaque(false);
        this.subctrlPanel.setLayout(this.borderLayout3);
        this.borderLayout3.setVgap(12);
        this.borderLayout3.setHgap(12);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(this.borderLayout2);
        this.mulButton.setText("*");
        this.mulButton.setActionCommand("Mul");
        this.mulButton.setMargin(new Insets(0, 0, 0, 0));
        this.mulButton.setMinimumSize(new Dimension(0, 0));
        this.mulButton.setNextFocusableComponent(this.subButton);
        this.mulButton.setFont(new Font("SansSerif", 0, 12));
        this.mulButton.setForeground(Color.red);
        this.mulButton.setMaximumSize(new Dimension(255, 255));
        this.mrButton.setText("MR");
        this.mrButton.setActionCommand("MR");
        this.mrButton.setMargin(new Insets(0, 0, 0, 0));
        this.mrButton.setPreferredSize(new Dimension(34, 25));
        this.mrButton.setMinimumSize(new Dimension(0, 0));
        this.mrButton.setNextFocusableComponent(this.msButton);
        this.mrButton.setFont(new Font("SansSerif", 0, 12));
        this.mrButton.setForeground(Color.red);
        this.mrButton.setMaximumSize(new Dimension(255, 255));
        this.msButton.setText("MS");
        this.msButton.setActionCommand("MS");
        this.msButton.setMargin(new Insets(0, 0, 0, 0));
        this.msButton.setPreferredSize(new Dimension(34, 25));
        this.msButton.setMinimumSize(new Dimension(0, 0));
        this.msButton.setNextFocusableComponent(this.mpButton);
        this.msButton.setFont(new Font("SansSerif", 0, 12));
        this.msButton.setForeground(Color.red);
        this.msButton.setMaximumSize(new Dimension(255, 255));
        this.mpButton.setText("M+");
        this.mpButton.setPreferredSize(new Dimension(34, 25));
        this.mpButton.setMargin(new Insets(0, 0, 0, 0));
        this.mpButton.setMinimumSize(new Dimension(0, 0));
        this.mpButton.setNextFocusableComponent(this.sevenButton);
        this.mpButton.setFont(new Font("SansSerif", 0, 12));
        this.mpButton.setForeground(Color.red);
        this.mpButton.setMaximumSize(new Dimension(255, 255));
        this.mcButton.setText("MC");
        this.mcButton.setActionCommand("MC");
        this.mcButton.setMargin(new Insets(0, 0, 0, 0));
        this.mcButton.setPreferredSize(new Dimension(34, 25));
        this.mcButton.setMinimumSize(new Dimension(0, 0));
        this.mcButton.setNextFocusableComponent(this.mrButton);
        this.mcButton.setFont(new Font("SansSerif", 0, 12));
        this.mcButton.setForeground(Color.red);
        this.mcButton.setMaximumSize(new Dimension(255, 255));
        this.procButton.setText("%");
        this.procButton.setActionCommand("Proc");
        this.procButton.setMargin(new Insets(0, 0, 0, 0));
        this.procButton.setMinimumSize(new Dimension(0, 0));
        this.procButton.setNextFocusableComponent(this.invButton);
        this.procButton.setFont(new Font("SansSerif", 0, 12));
        this.procButton.setForeground(Color.blue);
        this.procButton.setMaximumSize(new Dimension(255, 255));
        this.sevenButton.setText("7");
        this.sevenButton.setActionCommand("Seven");
        this.sevenButton.setMargin(new Insets(0, 0, 0, 0));
        this.sevenButton.setToolTipText("");
        this.sevenButton.setMinimumSize(new Dimension(0, 0));
        this.sevenButton.setNextFocusableComponent(this.forthButton);
        this.sevenButton.setFont(new Font("SansSerif", 0, 12));
        this.sevenButton.setForeground(Color.blue);
        this.sevenButton.setMaximumSize(new Dimension(255, 255));
        this.invButton.setText("1/x");
        this.invButton.setActionCommand("Inv");
        this.invButton.setMargin(new Insets(0, 0, 0, 0));
        this.invButton.setMinimumSize(new Dimension(0, 0));
        this.invButton.setNextFocusableComponent(this.equalButton);
        this.invButton.setFont(new Font("SansSerif", 0, 12));
        this.invButton.setForeground(Color.blue);
        this.invButton.setMaximumSize(new Dimension(255, 255));
        this.zeroButton.setText("0");
        this.zeroButton.setActionCommand("Zero");
        this.zeroButton.setMargin(new Insets(0, 0, 0, 0));
        this.zeroButton.setMinimumSize(new Dimension(0, 0));
        this.zeroButton.setNextFocusableComponent(this.eightButton);
        this.zeroButton.setFont(new Font("SansSerif", 0, 12));
        this.zeroButton.setForeground(Color.blue);
        this.zeroButton.setMaximumSize(new Dimension(255, 255));
        this.dotButton.setText(".");
        this.dotButton.setActionCommand("Dot");
        this.dotButton.setMargin(new Insets(0, 0, 0, 0));
        this.dotButton.setMinimumSize(new Dimension(0, 0));
        this.dotButton.setNextFocusableComponent(this.divButton);
        this.dotButton.setFont(new Font("SansSerif", 0, 12));
        this.dotButton.setForeground(Color.blue);
        this.dotButton.setMaximumSize(new Dimension(255, 255));
        this.commonPanel.setDoubleBuffered(true);
        this.border1 = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.commonPanel.setBorder(this.border1);
        this.commonPanel.setLayout(this.borderLayout1);
        this.backspaceButton.setText("Backspace");
        this.backspaceButton.setActionCommand("Backspace");
        this.backspaceButton.setMargin(new Insets(0, 0, 0, 0));
        this.backspaceButton.setMinimumSize(new Dimension(0, 0));
        this.backspaceButton.setNextFocusableComponent(this.ceButton);
        this.backspaceButton.setFont(new Font("SansSerif", 0, 12));
        this.backspaceButton.setForeground(Color.red);
        this.backspaceButton.setMaximumSize(new Dimension(255, 255));
        this.sixButton.setText("6");
        this.sixButton.setActionCommand("Six");
        this.sixButton.setMargin(new Insets(0, 0, 0, 0));
        this.sixButton.setMinimumSize(new Dimension(0, 0));
        this.sixButton.setNextFocusableComponent(this.threeButton);
        this.sixButton.setFont(new Font("SansSerif", 0, 12));
        this.sixButton.setForeground(Color.blue);
        this.sixButton.setMaximumSize(new Dimension(255, 255));
        this.nineButton.setText("9");
        this.nineButton.setActionCommand("Nine");
        this.nineButton.setMargin(new Insets(0, 0, 0, 0));
        this.nineButton.setMinimumSize(new Dimension(0, 0));
        this.nineButton.setNextFocusableComponent(this.sixButton);
        this.nineButton.setFont(new Font("SansSerif", 0, 12));
        this.nineButton.setForeground(Color.blue);
        this.nineButton.setMaximumSize(new Dimension(255, 255));
        this.numPanel.setOpaque(false);
        this.numPanel.setLayout(this.gridLayout2);
        this.fiveButton.setText("5");
        this.fiveButton.setActionCommand("Five");
        this.fiveButton.setMargin(new Insets(0, 0, 0, 0));
        this.fiveButton.setMinimumSize(new Dimension(0, 0));
        this.fiveButton.setNextFocusableComponent(this.twoButton);
        this.fiveButton.setFont(new Font("SansSerif", 0, 12));
        this.fiveButton.setForeground(Color.blue);
        this.fiveButton.setMaximumSize(new Dimension(255, 255));
        this.subButton.setText("-");
        this.subButton.setActionCommand("Sub");
        this.subButton.setMargin(new Insets(0, 0, 0, 0));
        this.subButton.setMinimumSize(new Dimension(0, 0));
        this.subButton.setNextFocusableComponent(this.addButton);
        this.subButton.setFont(new Font("SansSerif", 0, 12));
        this.subButton.setForeground(Color.red);
        this.subButton.setMaximumSize(new Dimension(255, 255));
        this.addButton.setText("+");
        this.addButton.setActionCommand("Add");
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setMinimumSize(new Dimension(0, 0));
        this.addButton.setNextFocusableComponent(this.sqrtButton);
        this.addButton.setFont(new Font("SansSerif", 0, 12));
        this.addButton.setForeground(Color.red);
        this.addButton.setMaximumSize(new Dimension(255, 255));
        this.memPanel.setOpaque(false);
        this.memPanel.setLayout(this.gridLayout1);
        this.controlPanel.setOpaque(false);
        this.controlPanel.setLayout(this.gridLayout3);
        this.equalButton.setText("=");
        this.equalButton.setActionCommand("Equal");
        this.equalButton.setMargin(new Insets(0, 0, 0, 0));
        this.equalButton.setMinimumSize(new Dimension(0, 0));
        this.equalButton.setNextFocusableComponent(this.backspaceButton);
        this.equalButton.setFont(new Font("SansSerif", 0, 12));
        this.equalButton.setForeground(Color.red);
        this.equalButton.setMaximumSize(new Dimension(255, 255));
        this.cButton.setText("C");
        this.cButton.setMinimumSize(new Dimension(0, 0));
        this.cButton.setNextFocusableComponent(this.mcButton);
        this.cButton.setMargin(new Insets(0, 0, 0, 0));
        this.cButton.setFont(new Font("SansSerif", 0, 12));
        this.cButton.setForeground(Color.red);
        this.cButton.setMaximumSize(new Dimension(255, 255));
        this.eightButton.setText("8");
        this.eightButton.setActionCommand("Eight");
        this.eightButton.setMargin(new Insets(0, 0, 0, 0));
        this.eightButton.setMinimumSize(new Dimension(0, 0));
        this.eightButton.setNextFocusableComponent(this.fiveButton);
        this.eightButton.setFont(new Font("SansSerif", 0, 12));
        this.eightButton.setForeground(Color.blue);
        this.eightButton.setMaximumSize(new Dimension(255, 255));
        this.sqrtButton.setText("sqrt");
        this.sqrtButton.setActionCommand("Sqrt");
        this.sqrtButton.setMargin(new Insets(0, 0, 0, 0));
        this.sqrtButton.setMinimumSize(new Dimension(0, 0));
        this.sqrtButton.setNextFocusableComponent(this.procButton);
        this.sqrtButton.setFont(new Font("SansSerif", 0, 12));
        this.sqrtButton.setForeground(Color.blue);
        this.sqrtButton.setMaximumSize(new Dimension(255, 255));
        this.stubPanel.setPreferredSize(new Dimension(34, 25));
        this.stubPanel.setLayout(this.borderLayout5);
        this.stubPanel.setMinimumSize(new Dimension(0, 0));
        this.stubPanel.setMaximumSize(new Dimension(255, 255));
        this.stubPanel.setAlignmentX(0.0f);
        this.stubPanel.setAlignmentY(0.0f);
        this.stubPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(this.borderLayout4);
        this.memoryLabel.setFont(new Font("SansSerif", 0, 12));
        this.memoryLabel.setHorizontalAlignment(0);
        this.memoryLabel.setText(" ");
        this.setNextFocusableComponent(this.backspaceButton);
        this.commonPanel.add((Component)this.indicatorText, "North");
        this.commonPanel.add((Component)this.buttonPanel, "Center");
        this.subctrlPanel.add((Component)this.stubPanel, "West");
        this.stubPanel.add((Component)this.memoryLabel, "Center");
        this.subctrlPanel.add((Component)this.controlPanel, "Center");
        this.controlPanel.add((Component)this.backspaceButton, null);
        this.controlPanel.add((Component)this.ceButton, null);
        this.controlPanel.add((Component)this.cButton, null);
        this.buttonPanel.add((Component)this.numPanel, "Center");
        this.memPanel.add((Component)this.mcButton, null);
        this.memPanel.add((Component)this.mrButton, null);
        this.memPanel.add((Component)this.msButton, null);
        this.memPanel.add((Component)this.mpButton, null);
        this.buttonPanel.add((Component)this.subctrlPanel, "North");
        this.buttonPanel.add((Component)this.memPanel, "West");
        this.numPanel.add((Component)this.sevenButton, null);
        this.numPanel.add((Component)this.eightButton, null);
        this.numPanel.add((Component)this.nineButton, null);
        this.numPanel.add((Component)this.divButton, null);
        this.numPanel.add((Component)this.sqrtButton, null);
        this.numPanel.add((Component)this.forthButton, null);
        this.numPanel.add((Component)this.fiveButton, null);
        this.numPanel.add((Component)this.sixButton, null);
        this.numPanel.add((Component)this.mulButton, null);
        this.numPanel.add((Component)this.procButton, null);
        this.numPanel.add((Component)this.oneButton, null);
        this.numPanel.add((Component)this.twoButton, null);
        this.numPanel.add((Component)this.threeButton, null);
        this.numPanel.add((Component)this.subButton, null);
        this.numPanel.add((Component)this.invButton, null);
        this.numPanel.add((Component)this.zeroButton, null);
        this.numPanel.add((Component)this.negButton, null);
        this.numPanel.add((Component)this.dotButton, null);
        this.numPanel.add((Component)this.addButton, null);
        this.numPanel.add((Component)this.equalButton, null);
        this.add((Component)this.commonPanel, "Center");
        this.indicatorText.addKeyListener(this);
        this.addButtonsListener(this.controlPanel);
        this.addButtonsListener(this.memPanel);
        this.addButtonsListener(this.numPanel);
    }

    public void copy() {
        this.indicatorText.copy();
    }

    public void paste() {
        if (this.error) {
            return;
        }
        try {
            this.indicatorText.paste();
            Double temp = new Double(this.indicatorText.getText());
            this.setValue(temp);
        }
        catch (Exception e2) {
            this.setValue(0.0);
        }
        this.update = true;
    }

    private void setButtonsWidth(Container panel, int width) {
        int i2 = 0;
        while (i2 < panel.getComponentCount()) {
            Component component = panel.getComponent(i2);
            if (component instanceof JButton) {
                JButton button = (JButton)component;
                Dimension d2 = button.getPreferredSize();
                d2.width = width;
                button.setPreferredSize(d2);
            }
            ++i2;
        }
    }

    private void setButtonsHeight(Container panel, int height) {
        int i2 = 0;
        while (i2 < panel.getComponentCount()) {
            Component component = panel.getComponent(i2);
            if (component instanceof JButton) {
                JButton button = (JButton)component;
                Dimension d2 = button.getPreferredSize();
                d2.height = height;
                button.setPreferredSize(d2);
            }
            ++i2;
        }
    }

    private void addButtonsListener(Container panel) {
        int i2 = 0;
        while (i2 < panel.getComponentCount()) {
            Component component = panel.getComponent(i2);
            if (component instanceof JButton) {
                JButton button = (JButton)component;
                button.addActionListener(this);
                button.addKeyListener(this);
            }
            ++i2;
        }
    }

    public void doLayout() {
        int width = (this.getSize().width - 60) / 6;
        int height = (this.getSize().height - 75) / 5;
        this.setButtonsWidth(this.memPanel, width);
        this.setButtonsHeight(this.memPanel, height);
        this.memPanel.validate();
        this.setButtonsWidth(this.numPanel, width);
        this.setButtonsHeight(this.numPanel, height);
        this.numPanel.validate();
        this.setButtonsHeight(this.controlPanel, height);
        this.controlPanel.validate();
        Dimension d2 = this.stubPanel.getPreferredSize();
        d2.width = width;
        d2.height = height;
        this.stubPanel.setPreferredSize(d2);
        super.doLayout();
        this.repaint();
        if (this.first) {
            this.first = false;
            this.backspaceButton.requestFocus();
        }
    }

    private void addDigit(char digit) {
        if (digit == '0' && this.value.equals("0")) {
            return;
        }
        if (this.value.equals("0")) {
            this.value = "";
        }
        if (this.update) {
            this.value = "";
            this.minus = false;
            this.comma = false;
        }
        this.update = false;
        this.value = this.value + digit;
        this.showValue();
    }

    private void addDot() {
        if (!this.comma) {
            this.comma = true;
            this.value = this.value + '.';
            this.showValue();
        }
    }

    private void showValue() {
        String text = this.minus ? '-' + this.value : this.value;
        if (!this.comma) {
            text = text + '.';
        }
        this.indicatorText.setText(text);
    }

    private double getValue() {
        try {
            Double temp = new Double(this.indicatorText.getText());
            return temp;
        }
        catch (Exception e2) {
            return 0.0;
        }
    }

    private void setValue(double value) {
        if (value < 0.0) {
            this.minus = true;
            value = -value;
        }
        Double temp = new Double(value);
        this.value = temp.toString();
        if (this.value.endsWith(".0")) {
            this.value = this.value.substring(0, this.value.length() - 2);
        }
        this.comma = this.value.indexOf(46) >= 0;
        this.showValue();
    }

    private void performOperation(int operation, double value) {
        switch (operation) {
            case 1: {
                this.setValue(this.buffer + value);
                break;
            }
            case 2: {
                this.setValue(this.buffer - value);
                break;
            }
            case 3: {
                this.setValue(this.buffer * value);
                break;
            }
            case 4: {
                if (value == 0.0) {
                    this.indicatorText.setText("Can not divide by zero.");
                    this.error = true;
                    break;
                }
                this.setValue(this.buffer / value);
                break;
            }
            case 0: {
                return;
            }
        }
        this.buffer = this.getValue();
        this.update = true;
        this.newop = false;
    }

    private void showMemory() {
        if (this.stored) {
            this.memoryLabel.setText("M");
        } else {
            this.memoryLabel.setText(" ");
        }
    }

    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        if (this.error && !cmd.equals("C") && !cmd.equals("CE")) {
            return;
        }
        if (cmd.equals("Zero")) {
            this.addDigit('0');
        } else if (cmd.equals("One")) {
            this.addDigit('1');
        } else if (cmd.equals("Two")) {
            this.addDigit('2');
        } else if (cmd.equals("Three")) {
            this.addDigit('3');
        } else if (cmd.equals("Forth")) {
            this.addDigit('4');
        } else if (cmd.equals("Five")) {
            this.addDigit('5');
        } else if (cmd.equals("Six")) {
            this.addDigit('6');
        } else if (cmd.equals("Seven")) {
            this.addDigit('7');
        } else if (cmd.equals("Eight")) {
            this.addDigit('8');
        } else if (cmd.equals("Nine")) {
            this.addDigit('9');
        } else if (cmd.equals("Dot")) {
            this.addDot();
        } else if (cmd.equals("Neg")) {
            this.minus = !this.minus;
            this.showValue();
        } else if (cmd.equals("Inv")) {
            double value = this.getValue();
            if (value == 0.0) {
                this.indicatorText.setText("Can not divide by zero.");
                this.error = true;
            } else {
                this.setValue(1.0 / value);
            }
            this.update = true;
        } else if (cmd.equals("Sqrt")) {
            double value = this.getValue();
            if (value < 0.0) {
                this.indicatorText.setText("Invalid input for function.");
                this.error = true;
            } else {
                this.setValue(Math.sqrt(value));
            }
            this.update = true;
        } else if (cmd.equals("Backspace") && !this.update) {
            this.value = this.value.substring(0, this.value.length() - 1);
            if (this.value.length() == 0) {
                this.value = "0";
                this.minus = false;
            }
            this.comma = this.value.indexOf(46) >= 0;
            this.showValue();
        } else if (cmd.equals("C")) {
            this.error = false;
            this.memory = 0.0;
            this.buffer = 0.0;
            this.stored = false;
            this.operation = 0;
            this.setValue(0.0);
            this.update = false;
            this.minus = false;
            this.comma = false;
            this.newop = true;
            this.showMemory();
        } else if (cmd.equals("CE")) {
            this.error = false;
            this.buffer = 0.0;
            this.operation = 0;
            this.setValue(0.0);
            this.update = false;
            this.minus = false;
            this.comma = false;
            this.newop = true;
        } else if (cmd.equals("Add")) {
            if (this.newop) {
                this.performOperation(this.operation, this.getValue());
            }
            this.buffer = this.getValue();
            this.operation = 1;
            this.update = true;
            this.newop = true;
        } else if (cmd.equals("Sub")) {
            if (this.newop) {
                this.performOperation(this.operation, this.getValue());
            }
            this.buffer = this.getValue();
            this.operation = 2;
            this.update = true;
            this.newop = true;
        } else if (cmd.equals("Mul")) {
            if (this.newop) {
                this.performOperation(this.operation, this.getValue());
            }
            this.buffer = this.getValue();
            this.operation = 3;
            this.update = true;
            this.newop = true;
        } else if (cmd.equals("Div")) {
            if (this.newop) {
                this.performOperation(this.operation, this.getValue());
            }
            this.buffer = this.getValue();
            this.operation = 4;
            this.update = true;
            this.newop = true;
        } else if (cmd.equals("Equal")) {
            if (this.newop) {
                this.oldvalue = this.getValue();
            }
            this.performOperation(this.operation, this.oldvalue);
        } else if (cmd.equals("MS")) {
            this.stored = true;
            this.memory = this.getValue();
            this.showMemory();
            this.update = true;
        } else if (cmd.equals("M+")) {
            this.stored = true;
            this.memory += this.getValue();
            this.showMemory();
            this.update = true;
        } else if (cmd.equals("MC")) {
            this.stored = false;
            this.memory = 0.0;
            this.showMemory();
        } else if (cmd.equals("MR")) {
            if (!this.stored) {
                this.setValue(0.0);
            } else {
                this.setValue(this.memory);
            }
            this.update = true;
        }
    }

    public void keyTyped(KeyEvent e2) {
        char key = e2.getKeyChar();
        int delay = 100;
        if (key == '0') {
            this.zeroButton.requestFocus();
            this.zeroButton.doClick(100);
        } else if (key == '1') {
            this.oneButton.requestFocus();
            this.oneButton.doClick(100);
        } else if (key == '2') {
            this.twoButton.requestFocus();
            this.twoButton.doClick(100);
        } else if (key == '3') {
            this.threeButton.requestFocus();
            this.threeButton.doClick(100);
        } else if (key == '4') {
            this.forthButton.requestFocus();
            this.forthButton.doClick(100);
        } else if (key == '5') {
            this.fiveButton.requestFocus();
            this.fiveButton.doClick(100);
        } else if (key == '6') {
            this.sixButton.requestFocus();
            this.sixButton.doClick(100);
        } else if (key == '7') {
            this.sevenButton.requestFocus();
            this.sevenButton.doClick(100);
        } else if (key == '8') {
            this.eightButton.requestFocus();
            this.eightButton.doClick(100);
        } else if (key == '9') {
            this.nineButton.requestFocus();
            this.oneButton.doClick(100);
        } else if (key == '+') {
            this.addButton.requestFocus();
            this.addButton.doClick(100);
        } else if (key == '-') {
            this.subButton.requestFocus();
            this.subButton.doClick(100);
        } else if (key == '*') {
            this.mulButton.requestFocus();
            this.mulButton.doClick(100);
        } else if (key == '/') {
            this.divButton.requestFocus();
            this.divButton.doClick(100);
        } else if (key == '%') {
            this.procButton.requestFocus();
            this.procButton.doClick(100);
        } else if (key == 'c' || key == 'C') {
            this.cButton.requestFocus();
            this.cButton.doClick(100);
        } else if (key == '.' || key == ',') {
            this.dotButton.requestFocus();
            this.dotButton.doClick(100);
        } else if (key == '\n' || key == '=') {
            this.equalButton.requestFocus();
            this.equalButton.doClick(100);
        } else if (key == '\b') {
            this.backspaceButton.requestFocus();
            this.backspaceButton.doClick(100);
        }
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e2) {
            // empty catch block
        }
        CCalculator calculator = new CCalculator();
        JFrame frame = new JFrame("Calculator");
        frame.setContentPane(calculator);
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        frame.setLocation(300, 300);
        frame.show();
    }
}

