/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.beans;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CAnalogClock
extends JComponent {
    private ClockThread clockThread = new ClockThread();
    private boolean showDate = true;
    private Point center;
    private Point leftTop;
    private Point rightBottom;
    private double radius;

    public CAnalogClock() {
        this.clockThread.start();
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public void setShowDate(boolean showDate) {
        this.showDate = showDate;
        this.repaint();
    }

    private Font findFont(Graphics g2, String s2, int w2, int h2) {
        FontMetrics m2;
        int size = 6;
        Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), size);
        while ((m2 = g2.getFontMetrics(font)).getHeight() <= h2 && m2.stringWidth(s2) <= w2) {
            font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++size);
        }
        return font;
    }

    private Point countPoint(double radius, double min) {
        return new Point((int)(-radius * Math.sin(-0.10466667264699936 * min)) + this.center.x, (int)(-radius * Math.cos(0.10466667264699936 * min)) + this.center.y);
    }

    private void drawColoredPoint(Graphics g2, int x2, int y2, int w2, Color c1, Color c2, Color c3) {
        g2.setColor(c3);
        g2.fillRect(x2 - w2, y2 - w2, w2 * 2, w2 * 2);
        g2.setColor(c1);
        g2.drawLine(x2 - w2, y2 + w2, x2 - w2, y2 - w2);
        g2.drawLine(x2 - w2, y2 - w2, x2 + w2 - 1, y2 - w2);
        g2.setColor(c2);
        g2.drawLine(x2 + w2, y2 - w2, x2 + w2, y2 + w2);
        g2.drawLine(x2 + w2, y2 + w2, x2 - w2 + 1, y2 + w2);
    }

    private void drawPoint(Graphics g2, double min) {
        Point p2 = this.countPoint(this.radius, min);
        int w2 = (int)(this.radius * 0.02);
        int n2 = w2 = w2 == 0 ? 1 : w2;
        if ((int)min % 5 == 0) {
            this.drawColoredPoint(g2, p2.x, p2.y, w2, new Color(0, 255, 255), Color.black, new Color(0, 130, 132));
        } else {
            this.drawColoredPoint(g2, p2.x, p2.y, w2, Color.gray, Color.white, Color.lightGray);
        }
    }

    private void drawSecArrow(Graphics g2, double min) {
        Point p2 = this.countPoint(this.radius * 0.85, min);
        g2.setColor(new Color(41, 44, 49));
        g2.drawLine(this.center.x, this.center.y, p2.x, p2.y);
    }

    private void drawThickArrow(Graphics g2, double min, double l1, double l2, double l3, Color c2) {
        Point p1 = this.countPoint(this.radius * l1, min);
        Point p2 = this.countPoint(this.radius * l2, min + 30.0);
        Point p3 = this.countPoint(this.radius * l3, min + 15.0);
        Point p4 = this.countPoint(this.radius * l3, min + 45.0);
        int[] x2 = new int[]{p1.x, p3.x, p2.x, p4.x};
        int[] y2 = new int[]{p1.y, p3.y, p2.y, p4.y};
        g2.setColor(c2);
        g2.fillPolygon(x2, y2, 4);
    }

    private void drawMinArrow(Graphics g2, double min) {
        Point oldCenter = this.center;
        this.center = this.countPoint(3.0, min + 45.0);
        this.drawThickArrow(g2, min, 0.8, 0.15, 0.05, Color.white);
        this.center = this.countPoint(5.0, min + 15.0);
        this.drawThickArrow(g2, min, 0.8, 0.15, 0.05, Color.gray);
        this.center = oldCenter;
        this.drawThickArrow(g2, min, 0.8, 0.15, 0.05, new Color(0, 130, 132));
    }

    private void drawHourArrow(Graphics g2, double min) {
        Point oldCenter = this.center;
        this.center = this.countPoint(3.0, min + 45.0);
        this.drawThickArrow(g2, min, 0.6, 0.15, 0.07, Color.white);
        this.center = this.countPoint(5.0, min + 15.0);
        this.drawThickArrow(g2, min, 0.6, 0.15, 0.07, Color.gray);
        this.center = oldCenter;
        this.drawThickArrow(g2, min, 0.6, 0.15, 0.07, new Color(0, 130, 132));
    }

    public void paint(Graphics g2) {
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat format = new SimpleDateFormat();
        double timeRate = this.showDate ? 0.6 : 0.8;
        Dimension d2 = this.getSize();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, d2.width, d2.height);
        this.leftTop = new Point((int)(d2.getWidth() * 0.1), (int)(d2.getHeight() * 0.1));
        this.rightBottom = new Point((int)(d2.getWidth() * 0.9), (int)(d2.getHeight() * (timeRate + 0.1)));
        this.center = new Point((this.rightBottom.x + this.leftTop.x) / 2, (this.rightBottom.y + this.leftTop.y) / 2);
        this.radius = this.center.x < this.center.y ? (double)((this.rightBottom.x - this.leftTop.x) / 2) : (double)((this.rightBottom.y - this.leftTop.y) / 2);
        int i2 = 0;
        while (i2 < 60) {
            this.drawPoint(g2, i2);
            ++i2;
        }
        this.drawHourArrow(g2, calendar.get(10) % 12 * 5 + calendar.get(12) / 12);
        this.drawMinArrow(g2, calendar.get(12));
        this.drawSecArrow(g2, calendar.get(13));
        if (this.showDate) {
            format.applyPattern("EEEE, dd MMMM yyyy");
            String strDate = format.format(calendar.getTime());
            Font font = this.findFont(g2, strDate, (int)(d2.getWidth() * 0.8), (int)(d2.getHeight() * 0.2));
            FontMetrics m2 = g2.getFontMetrics(font);
            int x2 = (d2.width - m2.stringWidth(strDate)) / 2;
            int y2 = (int)((d2.getHeight() * 0.2 - (double)m2.getHeight()) / 2.0 + d2.getHeight() * 0.7) + m2.getAscent();
            g2.setFont(font);
            g2.setColor(Color.black);
            g2.drawString(strDate, x2, y2);
        }
    }

    public static void main(String[] args) {
        CAnalogClock analogClock = new CAnalogClock();
        JFrame frame = new JFrame("Analog Clock");
        frame.setContentPane(analogClock);
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        frame.setLocation(300, 300);
        frame.show();
    }

    private class ClockThread
    extends Thread {
        private ClockThread() {
        }

        public void run() {
            while (true) {
                try {
                    CAnalogClock.this.repaint();
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                }
            }
        }
    }
}

