/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import depurador.DepuradorManager;
import depurador.DepuradorManagerException;
import depurador.DepuradorUserInterface;
import depurador.JavaDocumentViewer;
import depurador.MemoriaTreeNodoModificable;
import depurador.MensajeVentana;
import depurador.NuevoValorDialog;
import depurador.Preferencias;
import depurador.PreferenciasDialog;
import depurador.Profiler;
import depurador.VentanaPrincipal_abrirBoton_actionAdapter;
import depurador.VentanaPrincipal_abrirMenuItem_actionAdapter;
import depurador.VentanaPrincipal_arbol_mouseAdapter;
import depurador.VentanaPrincipal_cerrarMenuItem_actionAdapter;
import depurador.VentanaPrincipal_compilarMenuItem_actionAdapter;
import depurador.VentanaPrincipal_guardarBoton_actionAdapter;
import depurador.VentanaPrincipal_guardarMenuItem_actionAdapter;
import depurador.VentanaPrincipal_lanzarMenuItem_actionAdapter;
import depurador.VentanaPrincipal_playBoton_actionAdapter;
import depurador.VentanaPrincipal_preferenciasMenuItem_actionAdapter;
import depurador.VentanaPrincipal_salirMenuItem_actionAdapter;
import depurador.VentanaPrincipal_stepIntoBoton_actionAdapter;
import depurador.VentanaPrincipal_stepOutBoton_actionAdapter;
import depurador.VentanaPrincipal_stepOverBoton_actionAdapter;
import depurador.VentanaPrincipal_stopBoton_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

public class VentanaPrincipal
extends JFrame
implements DepuradorUserInterface {
    JPanel contentPane;
    JPanel menusPane;
    JTextArea consolaArea = new JTextArea();
    JSplitPane splitPaneHoriz = new JSplitPane();
    JSplitPane splitPaneVert = new JSplitPane();
    JScrollPane arbolScroll = new JScrollPane();
    JTree arbol = new JTree();
    JScrollPane consolaScroll = new JScrollPane();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem abrirMenuItem = new JMenuItem();
    JToolBar jToolBar1 = new JToolBar();
    JButton abrirBoton = new JButton(new ImageIcon(this.getClass().getResource("iconos/Open16.gif")));
    JButton guardarBoton = new JButton(new ImageIcon(this.getClass().getResource("iconos/save16.gif")));
    JButton stepOverBoton = new JButton(new ImageIcon(this.getClass().getResource("iconos/step_over.gif")));
    JButton stepIntoBoton = new JButton(new ImageIcon(this.getClass().getResource("iconos/step_into.gif")));
    JButton stepOutBoton = new JButton(new ImageIcon(this.getClass().getResource("iconos/step_out.gif")));
    JButton stopBoton = new JButton(new ImageIcon(this.getClass().getResource("iconos/stop.gif")));
    JButton playBoton = new JButton(new ImageIcon(this.getClass().getResource("iconos/play.gif")));
    DepuradorManager depuradorManager = new DepuradorManager(this);
    private Profiler profiler = null;
    public static int lineaDestacada = 1;
    JTabbedPane ficherosPane = new JTabbedPane();
    GridLayout gridLayout1 = new GridLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuItem compilarMenuItem = new JMenuItem();
    JMenuItem cerrarMenuItem = new JMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem lanzarMenuItem = new JMenuItem();
    JMenuItem guardarMenuItem = new JMenuItem();
    JMenuItem preferenciasMenuItem = new JMenuItem();
    JMenuItem salirMenuItem = new JMenuItem();

    public VentanaPrincipal() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(800, 600));
        this.setTitle("Java TraceIt!");
        this.jMenu1.setText("Fichero");
        this.abrirMenuItem.setText("Abrir...");
        this.abrirMenuItem.addActionListener(new VentanaPrincipal_abrirMenuItem_actionAdapter(this));
        this.compilarMenuItem.setText("Compilar");
        this.compilarMenuItem.addActionListener(new VentanaPrincipal_compilarMenuItem_actionAdapter(this));
        this.cerrarMenuItem.setText("Cerrar");
        this.cerrarMenuItem.addActionListener(new VentanaPrincipal_cerrarMenuItem_actionAdapter(this));
        this.jMenu2.setText("Depurar");
        this.lanzarMenuItem.setText("Lanzar...");
        this.lanzarMenuItem.addActionListener(new VentanaPrincipal_lanzarMenuItem_actionAdapter(this));
        this.guardarMenuItem.setText("Guardar");
        this.guardarMenuItem.addActionListener(new VentanaPrincipal_guardarMenuItem_actionAdapter(this));
        this.preferenciasMenuItem.setText("Preferencias...");
        this.preferenciasMenuItem.addActionListener(new VentanaPrincipal_preferenciasMenuItem_actionAdapter(this));
        this.arbol.addMouseListener(new VentanaPrincipal_arbol_mouseAdapter(this));
        this.arbolScroll.setDoubleBuffered(true);
        this.abrirBoton.addActionListener(new VentanaPrincipal_abrirBoton_actionAdapter(this));
        this.salirMenuItem.setText("Salir");
        this.salirMenuItem.addActionListener(new VentanaPrincipal_salirMenuItem_actionAdapter(this));
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.add(this.abrirMenuItem);
        this.abrirMenuItem.setIcon(new ImageIcon(this.getClass().getResource("iconos/Open16.gif")));
        this.jMenu1.add(this.guardarMenuItem);
        this.guardarMenuItem.setIcon(new ImageIcon(this.getClass().getResource("iconos/save16.gif")));
        this.jMenu1.add(this.cerrarMenuItem);
        this.jMenu1.add(this.compilarMenuItem);
        this.jMenu1.add(this.preferenciasMenuItem);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.salirMenuItem);
        this.preferenciasMenuItem.setIcon(new ImageIcon(this.getClass().getResource("iconos/preferencias.gif")));
        this.jToolBar1.setRollover(true);
        this.jToolBar1.add(this.abrirBoton);
        this.abrirBoton.setToolTipText("abrir");
        this.abrirBoton.setFocusable(false);
        this.jToolBar1.add(this.guardarBoton);
        this.guardarBoton.setToolTipText("guardar");
        this.guardarBoton.setFocusable(false);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.stopBoton);
        this.stopBoton.setToolTipText("detener depuracion");
        this.stopBoton.setFocusable(false);
        this.jToolBar1.add(this.playBoton);
        this.playBoton.setToolTipText("comenzar depuracion");
        this.playBoton.setFocusable(false);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add(this.stepOverBoton);
        this.stepOverBoton.setToolTipText("step over");
        this.stepOverBoton.setFocusable(false);
        this.jToolBar1.add(this.stepIntoBoton);
        this.stepIntoBoton.setToolTipText("step into");
        this.stepIntoBoton.setFocusable(false);
        this.jToolBar1.add(this.stepOutBoton);
        this.stepOutBoton.setToolTipText("step out");
        this.stepOutBoton.setFocusable(false);
        this.menusPane = new JPanel();
        this.contentPane.add((Component)this.menusPane, "North");
        this.menusPane.setLayout(new BorderLayout());
        this.menusPane.add((Component)this.jMenuBar1, "North");
        this.menusPane.add((Component)this.jToolBar1, "South");
        this.consolaScroll.setPreferredSize(new Dimension(0, 100));
        this.consolaScroll.setViewportView(this.consolaArea);
        this.contentPane.add((Component)this.splitPaneHoriz, "Center");
        this.jMenu2.add(this.lanzarMenuItem);
        this.splitPaneVert.setOrientation(1);
        this.splitPaneVert.setLeftComponent(this.arbolScroll);
        this.splitPaneVert.setResizeWeight(0.2);
        this.splitPaneVert.setRightComponent(this.ficherosPane);
        this.splitPaneHoriz.setResizeWeight(1.0);
        this.splitPaneHoriz.setOrientation(0);
        this.splitPaneHoriz.setTopComponent(this.splitPaneVert);
        this.splitPaneHoriz.setBottomComponent(this.consolaScroll);
        this.consolaScroll.setSize(new Dimension(0, 100));
        this.splitPaneHoriz.setDividerLocation(400);
        this.splitPaneVert.setDividerLocation(200);
        this.arbol = new JTree(new Vector());
        this.arbolScroll.setViewportView(this.arbol);
        this.estadoInicial();
        this.guardarBoton.addActionListener(new VentanaPrincipal_guardarBoton_actionAdapter(this));
        this.stopBoton.addActionListener(new VentanaPrincipal_stopBoton_actionAdapter(this));
        this.playBoton.addActionListener(new VentanaPrincipal_playBoton_actionAdapter(this));
        this.stepOverBoton.addActionListener(new VentanaPrincipal_stepOverBoton_actionAdapter(this));
        this.stepIntoBoton.addActionListener(new VentanaPrincipal_stepIntoBoton_actionAdapter(this));
        this.stepOutBoton.addActionListener(new VentanaPrincipal_stepOutBoton_actionAdapter(this));
    }

    protected void processWindowEvent(WindowEvent e2) {
        super.processWindowEvent(e2);
        if (e2.getID() == 201) {
            try {
                this.depuradorManager.parar_depuracion();
            }
            catch (Exception ex) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private int indexFichero(File f2) {
        int index = -1;
        int i2 = 0;
        while (i2 < this.ficherosPane.getTabCount()) {
            if (((JavaDocumentViewer)this.ficherosPane.getComponentAt(i2)).getFichero().equals(f2)) {
                index = i2;
            }
            ++i2;
        }
        return index;
    }

    private void guardarTodo() {
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            try {
                ((JavaDocumentViewer)this.ficherosPane.getComponentAt(i2)).guardar();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i2;
        }
    }

    public void nuevoFicheroAbierto(File f2) {
        JavaDocumentViewer javaDocumentViewer1 = new JavaDocumentViewer();
        try {
            this.ficherosPane.addTab(f2.getName(), javaDocumentViewer1);
            ((JavaDocumentViewer)this.ficherosPane.getComponent(this.ficherosPane.getComponentCount() - 1)).abrir(f2);
            this.ficherosPane.setSelectedIndex(this.ficherosPane.getTabCount() - 1);
            this.estadoConFicheros();
        }
        catch (Exception ex) {
            System.out.println(ex.fillInStackTrace());
        }
    }

    public void ficheroSacado(File f2) {
        int index = this.indexFichero(f2);
        this.ficherosPane.remove(index);
        if (this.ficherosPane.getTabCount() == 0) {
            this.estadoSinFicheros();
        }
    }

    public void informacionDeCompilacion(String str) {
        this.consolaArea.insert(str + "\n", this.consolaArea.getText().length());
    }

    private int ficherosPaneIndexForFile(File f2) {
        int index = -1;
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            if (((JavaDocumentViewer)this.ficherosPane.getComponentAt(i2)).getFichero().equals(f2)) {
                index = i2;
            }
            ++i2;
        }
        return index;
    }

    public void nuevaSituacionParada(File fichero, int linea, JTree memoria) {
        int index = this.ficherosPaneIndexForFile(fichero);
        if (index == -1) {
            try {
                this.depuradorManager.nuevoFichero(fichero);
            }
            catch (DepuradorManagerException ex) {
                this.ficherosPane.setSelectedIndex(this.ficherosPaneIndexForFile(fichero));
            }
        } else {
            this.ficherosPane.setSelectedIndex(index);
        }
        ((JavaDocumentViewer)this.ficherosPane.getSelectedComponent()).destacarLinea(linea);
        this.arbol = memoria;
        this.arbol.addMouseListener(new VentanaPrincipal_arbol_mouseAdapter(this));
        this.arbol.setDoubleBuffered(true);
        this.arbolScroll.setViewportView(this.arbol);
        this.estadoEnDepuracion();
    }

    public void salidaDeConsola(String str) {
        this.consolaArea.append(str);
        this.consolaArea.setSelectionStart(this.consolaArea.getText().length());
        this.consolaArea.setSelectionEnd(this.consolaArea.getText().length());
    }

    public void finDepuracion() {
        this.arbol = new JTree(new Vector());
        this.arbolScroll.setViewportView(this.arbol);
        this.estadoSinDepuracion();
        this.consolaArea.setBackground(Color.white);
        this.consolaArea.setForeground(Color.black);
        this.consolaArea.repaint();
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            ((JavaDocumentViewer)this.ficherosPane.getComponentAt(i2)).noDestacar();
            ++i2;
        }
    }

    public void comienzoDepuracion() {
        this.consolaArea.setText("");
        this.consolaArea.setBackground(Color.black);
        this.consolaArea.setForeground(Color.white);
        this.consolaArea.repaint();
        this.estadoEnEjecucion();
    }

    void arbol_mouseReleased(MouseEvent e2) {
        block5: {
            if (e2.getClickCount() != 2) break block5;
            TreePath camino = this.arbol.getSelectionPath();
            if (camino == null) {
                return;
            }
            Object o2 = camino.getPathComponent(camino.getPathCount() - 1);
            if (o2 instanceof MemoriaTreeNodoModificable) {
                NuevoValorDialog dialogo = new NuevoValorDialog(this, "Introduce un valor nuevo...", true);
                dialogo.setVisible(true);
                dialogo.setVisible(false);
                String valor = dialogo.getValor();
                if (valor == null) {
                    return;
                }
                try {
                    this.depuradorManager.cambiarValor((MemoriaTreeNodoModificable)o2, valor);
                    this.arbol.updateUI();
                    dialogo.dispose();
                }
                catch (DepuradorManagerException ex) {
                    MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
                    aviso.setVisible(true);
                    dialogo.dispose();
                }
            }
        }
    }

    void estadoInicial() {
        this.cerrarMenuItem.setEnabled(false);
        this.compilarMenuItem.setEnabled(false);
        this.guardarMenuItem.setEnabled(false);
        this.lanzarMenuItem.setEnabled(false);
        this.stepOverBoton.setEnabled(false);
        this.stepIntoBoton.setEnabled(false);
        this.stepOutBoton.setEnabled(false);
        this.stopBoton.setEnabled(false);
        this.playBoton.setEnabled(false);
        this.guardarBoton.setEnabled(false);
    }

    void estadoSinFicheros() {
        this.cerrarMenuItem.setEnabled(false);
        this.compilarMenuItem.setEnabled(false);
        this.guardarMenuItem.setEnabled(false);
        this.lanzarMenuItem.setEnabled(false);
        this.stepOverBoton.setEnabled(false);
        this.stepIntoBoton.setEnabled(false);
        this.stepOutBoton.setEnabled(false);
        this.stopBoton.setEnabled(false);
        this.playBoton.setEnabled(false);
        this.guardarBoton.setEnabled(false);
    }

    void estadoConFicheros() {
        this.cerrarMenuItem.setEnabled(true);
        this.compilarMenuItem.setEnabled(true);
        this.lanzarMenuItem.setEnabled(true);
        this.guardarMenuItem.setEnabled(true);
        this.guardarBoton.setEnabled(true);
    }

    void estadoEnDepuracion() {
        this.stepOverBoton.setEnabled(true);
        this.stepIntoBoton.setEnabled(true);
        this.stepOutBoton.setEnabled(true);
        this.stopBoton.setEnabled(true);
        this.playBoton.setEnabled(true);
        this.lanzarMenuItem.setEnabled(false);
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            ((JavaDocumentViewer)this.ficherosPane.getComponent(i2)).setEnabled(false);
            ++i2;
        }
    }

    void estadoEnEjecucion() {
        this.stepOverBoton.setEnabled(false);
        this.stepIntoBoton.setEnabled(false);
        this.stepOutBoton.setEnabled(false);
        this.stopBoton.setEnabled(true);
        this.playBoton.setEnabled(false);
        this.lanzarMenuItem.setEnabled(false);
        this.compilarMenuItem.setEnabled(false);
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            ((JavaDocumentViewer)this.ficherosPane.getComponent(i2)).setEnabled(false);
            ++i2;
        }
        this.arbolScroll.setViewport(null);
    }

    void estadoSinDepuracion() {
        this.cerrarMenuItem.setEnabled(true);
        this.compilarMenuItem.setEnabled(true);
        this.lanzarMenuItem.setEnabled(true);
        this.stepOverBoton.setEnabled(false);
        this.stepIntoBoton.setEnabled(false);
        this.stepOutBoton.setEnabled(false);
        this.stopBoton.setEnabled(false);
        this.playBoton.setEnabled(false);
        int i2 = 0;
        while (i2 < this.ficherosPane.getComponentCount()) {
            ((JavaDocumentViewer)this.ficherosPane.getComponent(i2)).setEnabled(true);
            ++i2;
        }
    }

    void abrirBoton_actionPerformed(ActionEvent e2) {
        this.abrirMenuItem_actionPerformed(e2);
    }

    void abrirMenuItem_actionPerformed(ActionEvent e2) {
        JFileChooser chooser = new JFileChooser();
        if (Preferencias.DIRECTORIO_ACTUAL != null) {
            chooser = new JFileChooser(Preferencias.DIRECTORIO_ACTUAL);
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f2) {
                return f2.isFile() && f2.getName().endsWith(".java") || f2.isDirectory();
            }

            public String getDescription() {
                return "Ficheros fuente Java";
            }
        });
        int decision = chooser.showOpenDialog(this);
        if (decision != 0) {
            return;
        }
        File fichero = chooser.getSelectedFile();
        Preferencias.DIRECTORIO_ACTUAL = fichero.getParentFile();
        try {
            if (fichero != null) {
                this.depuradorManager.nuevoFichero(fichero);
            }
        }
        catch (DepuradorManagerException ex) {
            this.ficherosPane.setSelectedIndex(this.ficherosPaneIndexForFile(fichero));
        }
    }

    void guardarMenuItem_actionPerformed(ActionEvent e2) {
        try {
            if (this.ficherosPane.getComponentCount() > 0) {
                ((JavaDocumentViewer)this.ficherosPane.getSelectedComponent()).guardar();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void cerrarMenuItem_actionPerformed(ActionEvent e2) {
        try {
            this.depuradorManager.sacarFichero(((JavaDocumentViewer)this.ficherosPane.getSelectedComponent()).getFichero());
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void compilarMenuItem_actionPerformed(ActionEvent e2) {
        try {
            this.consolaArea.setText("");
            this.guardarTodo();
            this.depuradorManager.compilar(((JavaDocumentViewer)this.ficherosPane.getSelectedComponent()).getFichero());
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void preferenciasMenuItem_actionPerformed(ActionEvent e2) {
        PreferenciasDialog ventana = new PreferenciasDialog(this, "Preferencias...", true);
        ventana.setVisible(true);
    }

    void lanzarMenuItem_actionPerformed(ActionEvent e2) {
        try {
            if (this.ficherosPane.getComponentCount() == 0) {
                MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, "No hay ningun fichero abierto");
                aviso.show();
                return;
            }
            this.depuradorManager.setMainFile(((JavaDocumentViewer)this.ficherosPane.getSelectedComponent()).getFichero());
            this.guardarTodo();
            this.depuradorManager.compilarTodo();
            int i2 = 0;
            while (i2 < this.ficherosPane.getComponentCount()) {
                File fichero = ((JavaDocumentViewer)this.ficherosPane.getComponentAt(i2)).getFichero();
                Vector breakpoints = ((JavaDocumentViewer)this.ficherosPane.getComponentAt(i2)).getBreakpoints();
                int j2 = 0;
                while (j2 < breakpoints.size()) {
                    int bp = (Integer)breakpoints.elementAt(j2);
                    this.depuradorManager.crearBreakpoint(fichero, bp);
                    ++j2;
                }
                ++i2;
            }
            this.depuradorManager.comenzarDepuracion(false);
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void guardarBoton_actionPerformed(ActionEvent e2) {
        this.guardarMenuItem_actionPerformed(e2);
    }

    void stopBoton_actionPerformed(ActionEvent e2) {
        try {
            this.depuradorManager.parar_depuracion();
            this.estadoSinDepuracion();
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void playBoton_actionPerformed(ActionEvent e2) {
        try {
            this.depuradorManager.continuar();
            this.estadoEnEjecucion();
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void stepOverBoton_actionPerformed(ActionEvent e2) {
        try {
            this.depuradorManager.step_over();
            this.estadoEnEjecucion();
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void stepIntoBoton_actionPerformed(ActionEvent e2) {
        try {
            this.depuradorManager.step_into();
            this.estadoEnEjecucion();
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void stepOutBoton_actionPerformed(ActionEvent e2) {
        try {
            this.depuradorManager.step_out();
            this.estadoEnEjecucion();
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void pauseBoton_actionPerformed(ActionEvent e2) {
        try {
            this.depuradorManager.pausar_depuracion();
        }
        catch (DepuradorManagerException ex) {
            MensajeVentana aviso = new MensajeVentana((Frame)this, "Atencion", true, ex.getMensaje());
            aviso.show();
        }
    }

    void salirMenuItem_actionPerformed(ActionEvent e2) {
        System.exit(0);
    }
}

