/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import depurador.ArrayMemoriaTreeNodo;
import depurador.MemoriaTreeNodo;
import depurador.MemoriaTreeNodoExpansible;
import depurador.ObjetoMemoriaTreeNodo;
import depurador.PrimitivoMemoriaTreeNodo;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;

public class StackFrameMemoriaTreeNodo
extends MemoriaTreeNodo
implements MemoriaTreeNodoExpansible {
    private boolean estaExpandido = false;

    public StackFrameMemoriaTreeNodo(StackFrame f2) {
        super(f2);
        this.add(new DefaultMutableTreeNode("info sin calcular"));
    }

    public StackFrame getStackFrame() {
        return (StackFrame)this.getMirror();
    }

    boolean esExpansible() {
        return true;
    }

    boolean esModificable() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MemoriaTreeNodo expandir() {
        this.removeAllChildren();
        StackFrame stackFrame = this.getStackFrame();
        try {
            Iterator variablesIterador;
            ObjectReference thisObject = this.getStackFrame().thisObject();
            if (thisObject != null) {
                ObjetoMemoriaTreeNodo thisNodo = new ObjetoMemoriaTreeNodo(this.getStackFrame().location().method().declaringType(), this.getStackFrame().thisObject(), "this");
                this.add(thisNodo);
            }
            if ((variablesIterador = stackFrame.visibleVariables().iterator()) == null) {
                return this;
            }
            while (true) {
                Type tipo;
                if (!variablesIterador.hasNext()) {
                    return this;
                }
                LocalVariable variableLocal = (LocalVariable)variablesIterador.next();
                try {
                    tipo = variableLocal.type();
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    continue;
                }
                if (tipo instanceof ReferenceType) {
                    if (tipo instanceof ArrayType) {
                        ArrayMemoriaTreeNodo arrayMemoriaTreeNodo = new ArrayMemoriaTreeNodo((ArrayType)tipo, (ArrayReference)stackFrame.getValue(variableLocal), variableLocal.name());
                        this.add(arrayMemoriaTreeNodo);
                        this.estaExpandido = true;
                        continue;
                    }
                    ObjetoMemoriaTreeNodo objetoMemoriaTreeNodo = new ObjetoMemoriaTreeNodo((ReferenceType)tipo, (ObjectReference)this.getStackFrame().getValue(variableLocal), variableLocal.name());
                    this.add(objetoMemoriaTreeNodo);
                    this.estaExpandido = true;
                    continue;
                }
                if (!(tipo instanceof PrimitiveType)) continue;
                PrimitivoMemoriaTreeNodo primitivoMemoriaTreeNodo = new PrimitivoMemoriaTreeNodo((PrimitiveType)tipo, this.getStackFrame(), variableLocal);
                this.add(primitivoMemoriaTreeNodo);
                this.estaExpandido = true;
            }
        }
        catch (AbsentInformationException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InvalidStackFrameException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean estaExpandido() {
        return this.estaExpandido;
    }

    public String toString() {
        String nombreClase = this.getStackFrame().location().method().declaringType().name();
        return nombreClase + "." + this.getStackFrame().location().method().name() + " :" + this.getStackFrame().location().lineNumber();
    }
}

