/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import depurador.MemoriaTreeNodo;
import depurador.MemoriaTreeNodoModificable;

public class PrimitivoMemoriaTreeNodo
extends MemoriaTreeNodo
implements MemoriaTreeNodoModificable {
    private boolean esLocalVariable = false;
    private boolean esElementoDeArray = false;
    private int array_index;
    private StackFrame stackFrame = null;
    private LocalVariable localVariable = null;
    private ObjectReference objectReference = null;
    private ArrayReference arrayPadre;
    private Field field = null;
    private String nombre;

    public PrimitivoMemoriaTreeNodo(PrimitiveType p2, StackFrame st, LocalVariable v2) {
        super(p2);
        this.stackFrame = st;
        this.localVariable = v2;
        this.esLocalVariable = true;
        this.nombre = this.localVariable.name();
    }

    public PrimitivoMemoriaTreeNodo(PrimitiveType p2, ObjectReference padre, Field f2) {
        super(p2);
        this.objectReference = padre;
        this.field = f2;
        this.esLocalVariable = false;
        this.nombre = f2.name();
    }

    public PrimitivoMemoriaTreeNodo(PrimitiveType p2, ArrayReference padre, int index) {
        super(p2);
        this.arrayPadre = padre;
        this.array_index = index;
        this.esLocalVariable = false;
        this.esElementoDeArray = true;
        this.nombre = "[" + index + "]";
    }

    public boolean esExpansible() {
        return false;
    }

    public boolean esModificable() {
        return true;
    }

    public PrimitiveType getPrimitiveType() {
        return (PrimitiveType)this.getMirror();
    }

    public Value getValue() {
        if (this.esLocalVariable) {
            return this.stackFrame.getValue(this.localVariable);
        }
        if (this.esElementoDeArray) {
            return this.arrayPadre.getValue(this.array_index);
        }
        return this.objectReference.getValue(this.field);
    }

    public void setValue(Value v2) throws ClassNotLoadedException, InvalidTypeException {
        if (this.esLocalVariable) {
            this.stackFrame.setValue(this.localVariable, v2);
        } else if (this.esElementoDeArray) {
            this.arrayPadre.setValue(this.array_index, v2);
        } else {
            this.objectReference.setValue(this.field, v2);
        }
    }

    public String toString() {
        return this.getPrimitiveType() + " " + this.nombre + " = " + this.getValue();
    }
}

