/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.plaf.TextUI;
import org.comedia.text.CJavaHighlighter;
import org.comedia.ui.CSyntaxEditor;

public class LineTextPane
extends CSyntaxEditor {
    private Color color;
    private int desplazLinea;
    private int grosorSe\u00f1alizador;
    private Color colorSe\u00f1alizador;
    private Color colorBreakpoint;
    private int lineaDestacada = -1;
    private Vector lineasBreakpoint = new Vector();

    public LineTextPane(int desplazLinea, Color c2, int grosor, Color c22, Color bp) {
        this.color = c2;
        this.desplazLinea = desplazLinea;
        this.grosorSe\u00f1alizador = grosor;
        this.colorSe\u00f1alizador = c22;
        this.setForeground(c2);
        this.setOpaque(false);
        this.setMargin(new Insets(0, 2, 0, 0));
        this.colorBreakpoint = bp;
        this.setSyntaxHighlighter(new CJavaHighlighter());
    }

    public void paintComponent(Graphics g2) {
        g2.fillRect(this.desplazLinea, 0, 1, this.getHeight());
        int i2 = 0;
        while (i2 < this.lineasBreakpoint.size()) {
            int numeroLinea = (Integer)this.lineasBreakpoint.elementAt(i2);
            g2.setColor(this.colorBreakpoint);
            g2.fillRect(0, (numeroLinea - 1) * this.grosorSe\u00f1alizador, this.getWidth(), this.grosorSe\u00f1alizador);
            ++i2;
        }
        if (this.lineaDestacada > 0) {
            g2.setColor(this.colorSe\u00f1alizador);
            g2.fillRect(0, (this.lineaDestacada - 1) * this.grosorSe\u00f1alizador, this.getWidth(), this.grosorSe\u00f1alizador);
        }
        super.paintComponent(g2);
    }

    public void destacarLinea(int numLinea) {
        this.lineaDestacada = numLinea;
        this.repaint();
    }

    public void noDestacar() {
        this.lineaDestacada = -1;
        this.lineasBreakpoint = new Vector();
        this.repaint();
    }

    public void nuevoBreakpoint(int linea) {
        if (this.lineasBreakpoint.indexOf(new Integer(linea)) != -1) {
            this.sacarBreakpoint(linea);
        } else {
            this.lineasBreakpoint.add(new Integer(linea));
        }
    }

    public void sacarBreakpoint(int linea) {
        this.lineasBreakpoint.remove(new Integer(linea));
    }

    public Vector getBreakpoints() {
        return this.lineasBreakpoint;
    }

    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        TextUI ui = this.getUI();
        int uiWidth = ui.getPreferredSize((JComponent)this).width;
        int parentWidth = parent.getSize().width;
        boolean bool = parent == null ? true : ui.getPreferredSize((JComponent)this).width < parent.getSize().width;
        return bool;
    }

    public void setBounds(int x2, int y2, int width, int height) {
        Dimension size = this.getPreferredSize();
        super.setBounds(x2, y2, Math.max(size.width, width), Math.max(size.height, height));
    }
}

