/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import depurador.JavaSyntaxDocument;
import depurador.LineTextPane;
import depurador.VisualizadorDeLineas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import org.comedia.text.CSyntaxEditorKit;

public class JavaDocumentViewer
extends JScrollPane
implements VisualizadorDeLineas {
    private static Color COLOR_NUMLINEA_FONDO = new Color(230, 230, 244);
    private static Color COLOR_NUMLINEA_FUENTE = new Color(153, 153, 204);
    private static Color COLOR_LINEA_MARGEN = new Color(210, 210, 210);
    private static int DESPLAZ_LINEA_MARGEN = 560;
    private static Font FUENTE_TEXTO = new Font("Monospaced", 0, 12);
    private static int GROSOR_LINEA_TEXTO = 17;
    private static Color COLOR_LINEA_SE\u00d1ALIZADOR = new Color(230, 230, 244);
    private static Color COLOR_LINEA_BREAKPOINT = new Color(255, 170, 170);
    private static StyleContext estilos;
    private CSyntaxEditorKit kit = new CSyntaxEditorKit();
    private JavaSyntaxDocument documento;
    private LineTextPane textPane = new LineTextPane(DESPLAZ_LINEA_MARGEN, COLOR_LINEA_MARGEN, GROSOR_LINEA_TEXTO, COLOR_LINEA_SE\u00d1ALIZADOR, COLOR_LINEA_BREAKPOINT);
    private JList numerosDeLineaList = new JList();
    private Vector numerosDeLineaVector = new Vector();
    private int numeroDeLineasActual = 0;
    private File fichero = null;
    private boolean abierto = false;

    public JavaDocumentViewer() {
        estilos = new StyleContext();
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setFontFamily(set, FUENTE_TEXTO.getFamily());
        StyleConstants.setFontSize(set, FUENTE_TEXTO.getSize());
        StyleConstants.setForeground(set, Color.black);
        estilos.addAttributes(estilos.getEmptySet(), set);
        this.documento = new JavaSyntaxDocument(estilos);
        this.getViewport().setBackground(Color.white);
        this.setHorizontalScrollBarPolicy(32);
        this.numerosDeLineaList.setFont(FUENTE_TEXTO);
        this.numerosDeLineaList.setBackground(COLOR_NUMLINEA_FONDO);
        this.numerosDeLineaList.setForeground(COLOR_NUMLINEA_FUENTE);
        this.numerosDeLineaList.setFixedCellHeight(GROSOR_LINEA_TEXTO);
        this.numerosDeLineaList.setListData(this.numerosDeLineaVector);
        this.numerosDeLineaList.setEnabled(true);
        this.numerosDeLineaList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e2) {
                JavaDocumentViewer.this.ponerBreakpoint(JavaDocumentViewer.this.numerosDeLineaList.getSelectedIndex() + 1);
                JavaDocumentViewer.this.repaint();
            }
        });
        this.documento.putProperty("tabSize", new Integer(2));
        this.textPane.setDocument(this.documento);
        this.getViewport().add(this.textPane);
        this.documento.setVisualizador(this);
        this.setRowHeaderView(this.numerosDeLineaList);
        this.numerosDeLineaList.setFixedCellWidth(1);
        this.numeroDeLineasActual = 0;
        this.textPane.setFont(FUENTE_TEXTO);
    }

    public boolean esVacio() {
        return this.numeroDeLineasActual == 0;
    }

    public void abrir(File fichero) throws IOException, BadLocationException {
        this.fichero = fichero;
        this.documento = new JavaSyntaxDocument(estilos);
        this.documento.putProperty("tabSize", new Integer(2));
        StyleConstants.setFontFamily(this.documento.getStyle("default"), FUENTE_TEXTO.getFamily());
        this.numeroDeLineasActual = 0;
        if (fichero == null) {
            return;
        }
        StyledEditorKit kit = new StyledEditorKit();
        this.documento.setVisualizador(this);
        this.textPane.setFont(FUENTE_TEXTO);
        kit.read(new InputStreamReader(new FileInputStream(this.fichero)), (Document)this.documento, 0);
        this.textPane.setDocument(this.documento);
        this.setRowHeaderView(this.numerosDeLineaList);
        this.abierto = true;
    }

    public void guardar() throws IOException, BadLocationException {
        if (this.fichero == null) {
            return;
        }
        StyledEditorKit kit = new StyledEditorKit();
        kit.write(new FileOutputStream(this.fichero), (Document)this.documento, 0, this.documento.getLength());
    }

    public void destacarLinea(int numLinea) {
        if (numLinea > 0 && numLinea <= this.numeroDeLineasActual) {
            this.textPane.destacarLinea(numLinea);
            double posY = this.getViewport().getViewPosition().getY();
            int posSe\u00f1alizador = GROSOR_LINEA_TEXTO * (numLinea + 1);
            if (posY < (double)(posSe\u00f1alizador - this.getHeight()) || posY > (double)(posSe\u00f1alizador + this.getHeight())) {
                this.getViewport().setViewPosition(new Point(0, posSe\u00f1alizador - this.getHeight() / 2));
            }
        }
    }

    public void noDestacar() {
        if (this.abierto) {
            this.textPane.noDestacar();
        }
    }

    public void ponerBreakpoint(int i2) {
        this.textPane.nuevoBreakpoint(i2);
    }

    public void sacarBreakpoint(int i2) {
        this.textPane.sacarBreakpoint(i2);
    }

    public Vector getBreakpoints() {
        return this.textPane.getBreakpoints();
    }

    public void nuevaLinea() {
        ++this.numeroDeLineasActual;
        try {
            this.numerosDeLineaVector.add("" + this.numeroDeLineasActual);
            this.numerosDeLineaList.setListData(this.numerosDeLineaVector);
            this.numerosDeLineaList.setFixedCellWidth(-1);
        }
        catch (Exception ex) {}
    }

    public void sacarLinea() {
        --this.numeroDeLineasActual;
        try {
            this.numerosDeLineaVector.remove(this.numerosDeLineaVector.size() - 1);
            this.numerosDeLineaList.setListData(this.numerosDeLineaVector);
            if (this.esVacio()) {
                this.numerosDeLineaList.setFixedCellWidth(1);
            }
        }
        catch (Exception ex) {}
    }

    public File getFichero() {
        if (this.abierto) {
            return this.fichero;
        }
        return null;
    }

    public void setEnabled(boolean valor) {
        super.setEnabled(valor);
        this.textPane.setEnabled(valor);
        this.numerosDeLineaList.setEnabled(valor);
    }
}

