/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import depurador.VisualizadorDeLineas;
import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class JavaDocument
extends DefaultStyledDocument {
    private static StyleContext estilos = new StyleContext();
    private int numeroDeLineas = 0;
    private VisualizadorDeLineas visualizador = null;
    private static Color COMENTARIO_COLOR = new Color(0, 106, 53);
    private static Color PALABRACLAVE_COLOR = new Color(0, 0, 130);
    private static Color PALABRAPREDEFINIDA_COLOR = new Color(164, 49, 49);
    private static Color NORMAL_COLOR = new Color(0, 0, 0);
    private boolean comentando_corto = false;
    private boolean comentando_largo = false;
    private static final String[] palabras_clave;
    private static final String[] palabras_predefinidas;

    public JavaDocument() {
        TabStop[] stops = new TabStop[500];
        int i2 = 0;
        while (i2 < 500) {
            TabStop t2;
            stops[i2] = t2 = new TabStop(i2 * 17);
            ++i2;
        }
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, new TabSet(stops));
        this.setParagraphAttributes(0, this.getLength(), attributes, true);
    }

    public void setVisualizador(VisualizadorDeLineas v2) {
        this.visualizador = v2;
    }

    public StyleContext getEstilos() {
        return estilos;
    }

    public int getNumeroDeLineas() {
        return this.numeroDeLineas;
    }

    private boolean buscar_binaria(String str, String[] array) {
        int inicio = 0;
        int fin = array.length - 1;
        int medio = (inicio + fin) / 2;
        while (inicio <= fin) {
            int cmp = str.compareTo(array[medio]);
            if (cmp == 0) {
                return true;
            }
            if (cmp < 0) {
                fin = medio - 1;
            } else {
                inicio = medio + 1;
            }
            medio = (inicio + fin) / 2;
        }
        return false;
    }

    private String estiloDe(String str) {
        if (this.buscar_binaria(str, palabras_clave)) {
            return "palabra_clave";
        }
        if (this.buscar_binaria(str, palabras_predefinidas)) {
            return "palabra_predefinida";
        }
        return null;
    }

    public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
        int i2 = 0;
        while (i2 < str.length()) {
            this.insertChar(offs + i2, str.charAt(i2), a2);
            ++i2;
        }
    }

    public int cuantosSaltosDeLinea(String str) {
        int resultado = 0;
        int pos = str.indexOf(10);
        while (pos != -1) {
            ++resultado;
            str = str.substring(pos + 1, str.length());
            pos = str.indexOf(10);
        }
        return resultado;
    }

    public void remove(int offs, int len) throws BadLocationException {
        int saltos = this.cuantosSaltosDeLinea(this.getText(offs, len));
        int i2 = 0;
        while (i2 < saltos) {
            if (this.visualizador != null) {
                this.visualizador.sacarLinea();
            }
            --this.numeroDeLineas;
            ++i2;
        }
        if (this.getLength() > 0 && len == this.getLength()) {
            this.visualizador.sacarLinea();
            --this.numeroDeLineas;
        }
        super.remove(offs, len);
    }

    private void insertChar(int offs, char c2, AttributeSet a2) throws BadLocationException {
        if (c2 == '\n' || this.numeroDeLineas == 0) {
            ++this.numeroDeLineas;
            if (this.visualizador != null) {
                this.visualizador.nuevaLinea();
            }
        }
        if (c2 == '/' && this.getText(offs - 1, 1).equals("/")) {
            if (!this.comentando_corto) {
                super.setCharacterAttributes(offs - 1, 1, estilos.getStyle("palabra_comentario"), true);
            }
            this.comentando_corto = true;
        }
        if (c2 == '\n' && this.comentando_corto) {
            this.comentando_corto = false;
        }
        if (c2 == '*' && this.getText(offs - 1, 1).equals("/")) {
            if (!this.comentando_largo) {
                super.setCharacterAttributes(offs - 1, 1, estilos.getStyle("palabra_comentario"), true);
            }
            this.comentando_largo = true;
        }
        if (c2 == '/' && this.getText(offs - 1, 1).equals("*")) {
            super.insertString(offs, "/", estilos.getStyle("palabra_comentario"));
            this.comentando_largo = false;
            return;
        }
        if (this.comentando_corto || this.comentando_largo) {
            super.insertString(offs, "" + c2, estilos.getStyle("palabra_comentario"));
            return;
        }
        if (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '.') {
            String estilo;
            int offsActual = offs - 1;
            String todoElTexto = this.getText(0, this.getLength());
            String palabraAnterior = "";
            while (offsActual >= 0) {
                String c22 = this.getText(offsActual, 1);
                if (c22.equals(" ") || c22.equals("\n") || c22.equals("\t")) break;
                palabraAnterior = c22 + palabraAnterior;
                --offsActual;
            }
            if (!palabraAnterior.equals("") && (estilo = this.estiloDe(palabraAnterior)) != null) {
                super.setCharacterAttributes(offsActual + 1, palabraAnterior.length(), estilos.getStyle(estilo), true);
            }
        }
        String cadena = "" + c2;
        super.insertString(offs, cadena, estilos.getStyle("palabra_normal"));
    }

    public void refrescarHighlights() {
        try {
            int longitudInicial = this.getLength();
            String todo = this.getText(0, this.getLength());
            super.setCharacterAttributes(0, todo.length(), estilos.getStyle("palabra_normal"), true);
            int i2 = 0;
            while (i2 < palabras_clave.length) {
                String palabra = palabras_clave[i2];
                int pos = todo.indexOf(palabra);
                while (pos != -1) {
                    Style estilo = estilos.getStyle("palabra_clave");
                    super.setCharacterAttributes(longitudInicial - todo.length() + pos, palabra.length(), estilo, true);
                    todo = todo.substring(pos + 1, todo.length());
                    pos = todo.indexOf(palabra);
                }
                todo = this.getText(0, this.getLength());
                ++i2;
            }
            todo = this.getText(0, this.getLength());
            int i3 = 0;
            while (i3 < palabras_predefinidas.length) {
                String palabra = palabras_predefinidas[i3];
                int pos = todo.indexOf(palabra);
                while (pos != -1) {
                    Style estilo = estilos.getStyle("palabra_predefinida");
                    super.setCharacterAttributes(longitudInicial - todo.length() + pos, palabra.length(), estilo, true);
                    todo = todo.substring(pos + 1, todo.length());
                    pos = todo.indexOf(palabra);
                }
                todo = this.getText(0, this.getLength());
                ++i3;
            }
        }
        catch (BadLocationException ex) {}
    }

    static {
        Style unEstilo = estilos.addStyle("palabra_clave", estilos.getStyle("default"));
        StyleConstants.setBold(unEstilo, true);
        StyleConstants.setForeground(unEstilo, PALABRACLAVE_COLOR);
        unEstilo = estilos.addStyle("palabra_normal", estilos.getStyle("default"));
        StyleConstants.setBold(unEstilo, false);
        StyleConstants.setForeground(unEstilo, NORMAL_COLOR);
        unEstilo = estilos.addStyle("palabra_predefinida", estilos.getStyle("default"));
        StyleConstants.setBold(unEstilo, true);
        StyleConstants.setForeground(unEstilo, PALABRAPREDEFINIDA_COLOR);
        unEstilo = estilos.addStyle("palabra_comentario", estilos.getStyle("default"));
        StyleConstants.setBold(unEstilo, false);
        StyleConstants.setItalic(unEstilo, false);
        StyleConstants.setForeground(unEstilo, COMENTARIO_COLOR);
        palabras_clave = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "final", "finally", "float", "for", "if", "implements", "import", "import", "instanceof", "int", "interface", "length", "long", "native", "new", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "threadsafe", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
        palabras_predefinidas = new String[]{"AbstractAction", "AbstractBorder", "AbstractButton", "AbstractCellEditor", "AbstractCollection", "AbstractColorChooserPanel", "AbstractDocument", "AbstractDocument.AttributeContext", "AbstractDocument.Content", "AbstractDocument.ElementEdit", "AbstractLayoutCache", "AbstractLayoutCache.NodeDimensions", "AbstractList", "AbstractListModel", "AbstractMap", "AbstractMethodError", "AbstractSequentialList", "AbstractSet", "AbstractTableModel", "AbstractUndoableEdit", "AbstractWriter", "AccessControlContext", "AccessControlException", "AccessController", "AccessException", "Accessible", "AccessibleAction", "AccessibleBundle", "AccessibleComponent", "AccessibleContext", "AccessibleHyperlink", "AccessibleHypertext", "AccessibleIcon", "AccessibleObject", "AccessibleRelation", "AccessibleRelationSet", "AccessibleResourceBundle", "AccessibleRole", "AccessibleSelection", "AccessibleState", "AccessibleStateSet", "AccessibleTable", "AccessibleTableModelChange", "AccessibleText", "AccessibleValue", "Acl", "AclEntry", "AclNotFoundException", "Action", "ActionEvent", "ActionListener", "ActionMap", "ActionMapUIResource", "Activatable", "ActivateFailedException", "ActivationDesc", "ActivationException", "ActivationGroup", "ActivationGroupDesc", "ActivationGroupDesc.CommandEnvironment", "ActivationGroupID", "ActivationID", "ActivationInstantiator", "ActivationMonitor", "ActivationSystem", "Activator", "ActiveEvent", "Adjustable", "AdjustmentEvent", "AdjustmentListener", "Adler32", "AffineTransform", "AffineTransformOp", "AlgorithmParameterGenerator", "AlgorithmParameterGeneratorSpi", "AlgorithmParameters", "AlgorithmParameterSpec", "AlgorithmParametersSpi", "AllPermission", "AlphaComposite", "AlreadyBound", "AlreadyBoundException", "AlreadyBoundHelper", "AlreadyBoundHolder", "AncestorEvent", "AncestorListener", "Annotation", "Any", "AnyHolder", "AnySeqHelper", "AnySeqHolder", "Applet", "AppletContext", "AppletInitializer", "AppletStub", "ApplicationException", "Arc2D", "Arc2D.Double", "Arc2D.Float", "Area", "AreaAveragingScaleFilter", "ARG_IN", "ARG_INOUT", "ARG_OUT", "ArithmeticException", "Array", "Array", "ArrayIndexOutOfBoundsException", "ArrayList", "Arrays", "ArrayStoreException", "AsyncBoxView", "Attribute", "AttributedCharacterIterator", "AttributedCharacterIterator.Attribute", "AttributedString", "AttributeInUseException", "AttributeList", "AttributeModificationException", "Attributes", "Attributes", "Attributes.Name", "AttributeSet", "AttributeSet.CharacterAttribute", "AttributeSet.ColorAttribute", "AttributeSet.FontAttribute", "AttributeSet.ParagraphAttribute", "AudioClip", "AudioFileFormat", "AudioFileFormat.Type", "AudioFileReader", "AudioFileWriter", "AudioFormat", "AudioFormat.Encoding", "AudioInputStream", "AudioPermission", "AudioSystem", "AuthenticationException", "AuthenticationNotSupportedException", "Authenticator", "Autoscroll", "AWTError", "AWTEvent", "AWTEventListener", "AWTEventMulticaster", "AWTException", "AWTPermission", "BAD_CONTEXT", "BAD_INV_ORDER", "BAD_OPERATION", "BAD_PARAM", "BAD_POLICY", "BAD_POLICY_TYPE", "BAD_POLICY_VALUE", "BAD_TYPECODE", "BadKind", "BadLocationException", "BandCombineOp", "BandedSampleModel", "BasicArrowButton", "BasicAttribute", "BasicAttributes", "BasicBorders", "BasicBorders.ButtonBorder", "BasicBorders.FieldBorder", "BasicBorders.MarginBorder", "BasicBorders.MenuBarBorder", "BasicBorders.RadioButtonBorder", "BasicBorders.SplitPaneBorder", "BasicBorders.ToggleButtonBorder", "BasicButtonListener", "BasicButtonUI", "BasicCheckBoxMenuItemUI", "BasicCheckBoxUI", "BasicColorChooserUI", "BasicComboBoxEditor", "BasicComboBoxEditor.UIResource", "BasicComboBoxRenderer", "BasicComboBoxRenderer.UIResource", "BasicComboBoxUI", "BasicComboPopup", "BasicDesktopIconUI", "BasicDesktopPaneUI", "BasicDirectoryModel", "BasicEditorPaneUI", "BasicFileChooserUI", "BasicGraphicsUtils", "BasicHTML", "BasicIconFactory", "BasicInternalFrameTitlePane", "BasicInternalFrameUI", "BasicLabelUI", "BasicListUI", "BasicLookAndFeel", "BasicMenuBarUI", "BasicMenuItemUI", "BasicMenuUI", "BasicOptionPaneUI", "BasicOptionPaneUI.ButtonAreaLayout", "BasicPanelUI", "BasicPasswordFieldUI", "BasicPermission", "BasicPopupMenuSeparatorUI", "BasicPopupMenuUI", "BasicProgressBarUI", "BasicRadioButtonMenuItemUI", "BasicRadioButtonUI", "BasicRootPaneUI", "BasicScrollBarUI", "BasicScrollPaneUI", "BasicSeparatorUI", "BasicSliderUI", "BasicSplitPaneDivider", "BasicSplitPaneUI", "BasicStroke", "BasicTabbedPaneUI", "BasicTableHeaderUI", "BasicTableUI", "BasicTextAreaUI", "BasicTextFieldUI", "BasicTextPaneUI", "BasicTextUI", "BasicTextUI.BasicCaret", "BasicTextUI.BasicHighlighter", "BasicToggleButtonUI", "BasicToolBarSeparatorUI", "BasicToolBarUI", "BasicToolTipUI", "BasicTreeUI", "BasicViewportUI", "BatchUpdateException", "BeanContext", "BeanContextChild", "BeanContextChildComponentProxy", "BeanContextChildSupport", "BeanContextContainerProxy", "BeanContextEvent", "BeanContextMembershipEvent", "BeanContextMembershipListener", "BeanContextProxy", "BeanContextServiceAvailableEvent", "BeanContextServiceProvider", "BeanContextServiceProviderBeanInfo", "BeanContextServiceRevokedEvent", "BeanContextServiceRevokedListener", "BeanContextServices", "BeanContextServicesListener", "BeanContextServicesSupport", "BeanContextServicesSupport.BCSSServiceProvider", "BeanContextSupport", "BeanContextSupport.BCSIterator", "BeanDescriptor", "BeanInfo", "Beans", "BevelBorder", "BigDecimal", "BigInteger", "BinaryRefAddr", "BindException", "Binding", "Binding", "BindingHelper", "BindingHolder", "BindingIterator", "BindingIteratorHelper", "BindingIteratorHolder", "BindingIteratorOperations", "BindingListHelper", "BindingListHolder", "BindingType", "BindingTypeHelper", "BindingTypeHolder", "BitSet", "Blob", "BlockView", "Book", "Boolean", "BooleanControl", "BooleanControl.Type", "BooleanHolder", "BooleanSeqHelper", "BooleanSeqHolder", "Border", "BorderFactory", "BorderLayout", "BorderUIResource", "BorderUIResource.BevelBorderUIResource", "BorderUIResource.CompoundBorderUIResource", "BorderUIResource.EmptyBorderUIResource", "BorderUIResource.EtchedBorderUIResource", "BorderUIResource.LineBorderUIResource", "BorderUIResource.MatteBorderUIResource", "BorderUIResource.TitledBorderUIResource", "BoundedRangeModel", "Bounds", "Bounds", "Box", "Box.Filler", "BoxedValueHelper", "BoxLayout", "BoxView", "BreakIterator", "BufferedImage", "BufferedImageFilter", "BufferedImageOp", "BufferedInputStream", "BufferedOutputStream", "BufferedReader", "BufferedWriter", "Button", "ButtonGroup", "ButtonModel", "ButtonUI", "Byte", "ByteArrayInputStream", "ByteArrayOutputStream", "ByteHolder", "ByteLookupTable", "Calendar", "CallableStatement", "CannotProceed", "CannotProceedException", "CannotProceedHelper", "CannotProceedHolder", "CannotRedoException", "CannotUndoException", "Canvas", "CardLayout", "Caret", "CaretEvent", "CaretListener", "CellEditor", "CellEditorListener", "CellRendererPane", "Certificate", "Certificate", "Certificate.CertificateRep", "CertificateEncodingException", "CertificateException", "CertificateExpiredException", "CertificateFactory", "CertificateFactorySpi", "CertificateNotYetValidException", "CertificateParsingException", "ChangedCharSetException", "ChangeEvent", "ChangeListener", "Character", "Character.Subset", "Character.UnicodeBlock", "CharacterIterator", "CharArrayReader", "CharArrayWriter", "CharConversionException", "CharHolder", "CharSeqHelper", "CharSeqHolder", "Checkbox", "CheckboxGroup", "CheckboxMenuItem", "CheckedInputStream", "CheckedOutputStream", "Checksum", "Choice", "ChoiceFormat", "Class", "ClassCastException", "ClassCircularityError", "ClassDesc", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "Clip", "Clipboard", "ClipboardOwner", "Clob", "Cloneable", "CloneNotSupportedException", "CMMException", "CodeSource", "CollationElementIterator", "CollationKey", "Collator", "Collection", "Collections", "Color", "ColorChooserComponentFactory", "ColorChooserUI", "ColorConvertOp", "ColorModel", "ColorSelectionModel", "ColorSpace", "ColorUIResource", "ComboBoxEditor", "ComboBoxModel", "ComboBoxUI", "ComboPopup", "COMM_FAILURE", "CommunicationException", "Comparable", "Comparator", "Compiler", "CompletionStatus", "CompletionStatusHelper", "Component", "ComponentAdapter", "ComponentColorModel", "ComponentEvent", "ComponentInputMap", "ComponentInputMapUIResource", "ComponentListener", "ComponentOrientation", "ComponentSampleModel", "ComponentUI", "ComponentView", "Composite", "CompositeContext", "CompositeName", "CompositeView", "CompoundBorder", "CompoundControl", "CompoundControl.Type", "CompoundEdit", "CompoundName", "ConcurrentModificationException", "ConfigurationException", "ConnectException", "ConnectException", "ConnectIOException", "Connection", "Constructor", "Container", "ContainerAdapter", "ContainerEvent", "ContainerListener", "ContentHandler", "ContentHandlerFactory", "ContentModel", "Context", "Context", "ContextList", "ContextNotEmptyException", "ContextualRenderedImageFactory", "Control", "Control", "Control.Type", "ControlFactory", "ControllerEventListener", "ConvolveOp", "CRC32", "CRL", "CRLException", "CropImageFilter", "CSS", "CSS.Attribute", "CTX_RESTRICT_SCOPE", "CubicCurve2D", "CubicCurve2D.Double", "CubicCurve2D.Float", "Current", "CurrentHelper", "CurrentHolder", "CurrentOperations", "Cursor", "Customizer", "CustomMarshal", "CustomValue", "DATA_CONVERSION", "DatabaseMetaData", "DataBuffer", "DataBufferByte", "DataBufferInt", "DataBufferShort", "DataBufferUShort", "DataFlavor", "DataFormatException", "DatagramPacket", "DatagramSocket", "DatagramSocketImpl", "DatagramSocketImplFactory", "DataInput", "DataInputStream", "DataInputStream", "DataLine", "DataLine.Info", "DataOutput", "DataOutputStream", "DataOutputStream", "DataTruncation", "Date", "Date", "DateFormat", "DateFormatSymbols", "DebugGraphics", "DecimalFormat", "DecimalFormatSymbols", "DefaultBoundedRangeModel", "DefaultButtonModel", "DefaultCaret", "DefaultCellEditor", "DefaultColorSelectionModel", "DefaultComboBoxModel", "DefaultDesktopManager", "DefaultEditorKit", "DefaultEditorKit.BeepAction", "DefaultEditorKit.CopyAction", "DefaultEditorKit.CutAction", "DefaultEditorKit.DefaultKeyTypedAction", "DefaultEditorKit.InsertBreakAction", "DefaultEditorKit.InsertContentAction", "DefaultEditorKit.InsertTabAction", "DefaultEditorKit.PasteAction", "DefaultFocusManager", "DefaultHighlighter", "DefaultHighlighter.DefaultHighlightPainter", "DefaultListCellRenderer", "DefaultListCellRenderer.UIResource", "DefaultListModel", "DefaultListSelectionModel", "DefaultMenuLayout", "DefaultMetalTheme", "DefaultMutableTreeNode", "DefaultSingleSelectionModel", "DefaultStyledDocument", "DefaultStyledDocument.AttributeUndoableEdit", "DefaultStyledDocument.ElementSpec", "DefaultTableCellRenderer", "DefaultTableCellRenderer.UIResource", "DefaultTableColumnModel", "DefaultTableModel", "DefaultTextUI", "DefaultTreeCellEditor", "DefaultTreeCellRenderer", "DefaultTreeModel", "DefaultTreeSelectionModel", "DefinitionKind", "DefinitionKindHelper", "Deflater", "DeflaterOutputStream", "Delegate", "Delegate", "DesignMode", "DesktopIconUI", "DesktopManager", "DesktopPaneUI", "DGC", "Dialog", "Dictionary", "DigestException", "DigestInputStream", "DigestOutputStream", "Dimension", "Dimension2D", "DimensionUIResource", "DirContext", "DirectColorModel", "DirectoryManager", "DirObjectFactory", "DirStateFactory", "DirStateFactory.Result", "DnDConstants", "Document", "DocumentEvent", "DocumentEvent.ElementChange", "DocumentEvent.EventType", "DocumentListener", "DocumentParser", "DomainCombiner", "DomainManager", "DomainManagerOperations", "Double", "DoubleHolder", "DoubleSeqHelper", "DoubleSeqHolder", "DragGestureEvent", "DragGestureListener", "DragGestureRecognizer", "DragSource", "DragSourceContext", "DragSourceDragEvent", "DragSourceDropEvent", "DragSourceEvent", "DragSourceListener", "Driver", "DriverManager", "DriverPropertyInfo", "DropTarget", "DropTarget.DropTargetAutoScroller", "DropTargetContext", "DropTargetDragEvent", "DropTargetDropEvent", "DropTargetEvent", "DropTargetListener", "DSAKey", "DSAKeyPairGenerator", "DSAParameterSpec", "DSAParams", "DSAPrivateKey", "DSAPrivateKeySpec", "DSAPublicKey", "DSAPublicKeySpec", "DTD", "DTDConstants", "DynamicImplementation", "DynAny", "DynArray", "DynEnum", "DynFixed", "DynSequence", "DynStruct", "DynUnion", "DynValue", "EditorKit", "Element", "Element", "ElementIterator", "Ellipse2D", "Ellipse2D.Double", "Ellipse2D.Float", "EmptyBorder", "EmptyStackException", "EncodedKeySpec", "Entity", "EnumControl", "EnumControl.Type", "Enumeration", "Environment", "EOFException", "Error", "EtchedBorder", "Event", "EventContext", "EventDirContext", "EventListener", "EventListenerList", "EventObject", "EventQueue", "EventSetDescriptor", "Exception", "ExceptionInInitializerError", "ExceptionList", "ExpandVetoException", "ExportException", "ExtendedRequest", "ExtendedResponse", "Externalizable", "FeatureDescriptor", "Field", "FieldNameHelper", "FieldPosition", "FieldView", "File", "FileChooserUI", "FileDescriptor", "FileDialog", "FileFilter", "FileFilter", "FileInputStream", "FilenameFilter", "FileNameMap", "FileNotFoundException", "FileOutputStream", "FilePermission", "FileReader", "FileSystemView", "FileView", "FileWriter", "FilteredImageSource", "FilterInputStream", "FilterOutputStream", "FilterReader", "FilterWriter", "FixedHeightLayoutCache", "FixedHolder", "FlatteningPathIterator", "FlavorMap", "Float", "FloatControl", "FloatControl.Type", "FloatHolder", "FloatSeqHelper", "FloatSeqHolder", "FlowLayout", "FlowView", "FlowView.FlowStrategy", "FocusAdapter", "FocusEvent", "FocusListener", "FocusManager", "Font", "FontFormatException", "FontMetrics", "FontRenderContext", "FontUIResource", "Format", "FormatConversionProvider", "FormView", "Frame", "FREE_MEM", "GapContent", "GeneralPath", "GeneralSecurityException", "GlyphJustificationInfo", "GlyphMetrics", "GlyphVector", "GlyphView", "GlyphView.GlyphPainter", "GradientPaint", "GraphicAttribute", "Graphics", "Graphics2D", "GraphicsConfigTemplate", "GraphicsConfiguration", "GraphicsDevice", "GraphicsEnvironment", "GrayFilter", "GregorianCalendar", "GridBagConstraints", "GridBagLayout", "GridLayout", "Group", "Guard", "GuardedObject", "GZIPInputStream", "GZIPOutputStream", "HasControls", "HashMap", "HashSet", "Hashtable", "HierarchyBoundsAdapter", "HierarchyBoundsListener", "HierarchyEvent", "HierarchyListener", "Highlighter", "Highlighter.Highlight", "Highlighter.HighlightPainter", "HTML", "HTML.Attribute", "HTML.Tag", "HTML.UnknownTag", "HTMLDocument", "HTMLDocument.Iterator", "HTMLEditorKit", "HTMLEditorKit.HTMLFactory", "HTMLEditorKit.HTMLTextAction", "HTMLEditorKit.InsertHTMLTextAction", "HTMLEditorKit.LinkController", "HTMLEditorKit.Parser", "HTMLEditorKit.ParserCallback", "HTMLFrameHyperlinkEvent", "HTMLWriter", "HttpURLConnection", "HyperlinkEvent", "HyperlinkEvent.EventType", "HyperlinkListener", "ICC_ColorSpace", "ICC_Profile", "ICC_ProfileGray", "ICC_ProfileRGB", "Icon", "IconUIResource", "IconView", "IdentifierHelper", "Identity", "IdentityScope", "IDLEntity", "IDLType", "IDLTypeHelper", "IDLTypeOperations", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalComponentStateException", "IllegalMonitorStateException", "IllegalPathStateException", "IllegalStateException", "IllegalThreadStateException", "Image", "ImageConsumer", "ImageFilter", "ImageGraphicAttribute", "ImageIcon", "ImageObserver", "ImageProducer", "ImagingOpException", "IMP_LIMIT", "IncompatibleClassChangeError", "InconsistentTypeCode", "IndexColorModel", "IndexedPropertyDescriptor", "IndexOutOfBoundsException", "IndirectionException", "InetAddress", "Inflater", "InflaterInputStream", "InheritableThreadLocal", "InitialContext", "InitialContextFactory", "InitialContextFactoryBuilder", "InitialDirContext", "INITIALIZE", "Initializer", "InitialLdapContext", "InlineView", "InputContext", "InputEvent", "InputMap", "InputMapUIResource", "InputMethod", "InputMethodContext", "InputMethodDescriptor", "InputMethodEvent", "InputMethodHighlight", "InputMethodListener", "InputMethodRequests", "InputStream", "InputStream", "InputStream", "InputStreamReader", "InputSubset", "InputVerifier", "Insets", "InsetsUIResource", "InstantiationError", "InstantiationException", "Instrument", "InsufficientResourcesException", "Integer", "INTERNAL", "InternalError", "InternalFrameAdapter", "InternalFrameEvent", "InternalFrameListener", "InternalFrameUI", "InterruptedException", "InterruptedIOException", "InterruptedNamingException", "INTF_REPOS", "IntHolder", "IntrospectionException", "Introspector", "INV_FLAG", "INV_IDENT", "INV_OBJREF", "INV_POLICY", "Invalid", "INVALID_TRANSACTION", "InvalidAlgorithmParameterException", "InvalidAttributeIdentifierException", "InvalidAttributesException", "InvalidAttributeValueException", "InvalidClassException", "InvalidDnDOperationException", "InvalidKeyException", "InvalidKeySpecException", "InvalidMidiDataException", "InvalidName", "InvalidName", "InvalidNameException", "InvalidNameHelper", "InvalidNameHolder", "InvalidObjectException", "InvalidParameterException", "InvalidParameterSpecException", "InvalidSearchControlsException", "InvalidSearchFilterException", "InvalidSeq", "InvalidTransactionException", "InvalidValue", "InvocationEvent", "InvocationHandler", "InvocationTargetException", "InvokeHandler", "IOException", "IRObject", "IRObjectOperations", "IstringHelper", "ItemEvent", "ItemListener", "ItemSelectable", "Iterator", "JApplet", "JarEntry", "JarException", "JarFile", "JarInputStream", "JarOutputStream", "JarURLConnection", "JButton", "JCheckBox", "JCheckBoxMenuItem", "JColorChooser", "JComboBox", "JComboBox.KeySelectionManager", "JComponent", "JDesktopPane", "JDialog", "JEditorPane", "JFileChooser", "JFrame", "JInternalFrame", "JInternalFrame.JDesktopIcon", "JLabel", "JLayeredPane", "JList", "JMenu", "JMenuBar", "JMenuItem", "JobAttributes", "JobAttributes.DefaultSelectionType", "JobAttributes.DestinationType", "JobAttributes.DialogType", "JobAttributes.MultipleDocumentHandlingType", "JobAttributes.SidesType", "JOptionPane", "JPanel", "JPasswordField", "JPopupMenu", "JPopupMenu.Separator", "JProgressBar", "JRadioButton", "JRadioButtonMenuItem", "JRootPane", "JScrollBar", "JScrollPane", "JSeparator", "JSlider", "JSplitPane", "JTabbedPane", "JTable", "JTableHeader", "JTextArea", "JTextComponent", "JTextComponent.KeyBinding", "JTextField", "JTextPane", "JToggleButton", "JToggleButton.ToggleButtonModel", "JToolBar", "JToolBar.Separator", "JToolTip", "JTree", "JTree.DynamicUtilTreeNode", "JTree.EmptySelectionModel", "JViewport", "JWindow", "Kernel", "Key", "KeyAdapter", "KeyEvent", "KeyException", "KeyFactory", "KeyFactorySpi", "KeyListener", "KeyManagementException", "Keymap", "KeyPair", "KeyPairGenerator", "KeyPairGeneratorSpi", "KeySpec", "KeyStore", "KeyStoreException", "KeyStoreSpi", "KeyStroke", "Label", "LabelUI", "LabelView", "LastOwnerException", "LayeredHighlighter", "LayeredHighlighter.LayerPainter", "LayoutManager", "LayoutManager2", "LayoutQueue", "LdapContext", "LdapReferralException", "Lease", "LimitExceededException", "Line", "Line.Info", "Line2D", "Line2D.Double", "Line2D.Float", "LineBorder", "LineBreakMeasurer", "LineEvent", "LineEvent.Type", "LineListener", "LineMetrics", "LineNumberInputStream", "LineNumberReader", "LineUnavailableException", "LinkageError", "LinkedList", "LinkException", "LinkLoopException", "LinkRef", "List", "List", "ListCellRenderer", "ListDataEvent", "ListDataListener", "ListIterator", "ListModel", "ListResourceBundle", "ListSelectionEvent", "ListSelectionListener", "ListSelectionModel", "ListUI", "ListView", "LoaderHandler", "Locale", "LocateRegistry", "LogStream", "Long", "LongHolder", "LongLongSeqHelper", "LongLongSeqHolder", "LongSeqHelper", "LongSeqHolder", "LookAndFeel", "LookupOp", "LookupTable", "MalformedLinkException", "MalformedURLException", "Manifest", "Map", "Map.Entry", "MARSHAL", "MarshalException", "MarshalledObject", "Math", "MatteBorder", "MediaTracker", "Member", "MemoryImageSource", "Menu", "MenuBar", "MenuBarUI", "MenuComponent", "MenuContainer", "MenuDragMouseEvent", "MenuDragMouseListener", "MenuElement", "MenuEvent", "MenuItem", "MenuItemUI", "MenuKeyEvent", "MenuKeyListener", "MenuListener", "MenuSelectionManager", "MenuShortcut", "MessageDigest", "MessageDigestSpi", "MessageFormat", "MetaEventListener", "MetalBorders", "MetalBorders.ButtonBorder", "MetalBorders.Flush3DBorder", "MetalBorders.InternalFrameBorder", "MetalBorders.MenuBarBorder", "MetalBorders.MenuItemBorder", "MetalBorders.OptionDialogBorder", "MetalBorders.PaletteBorder", "MetalBorders.PopupMenuBorder", "MetalBorders.RolloverButtonBorder", "MetalBorders.ScrollPaneBorder", "MetalBorders.TableHeaderBorder", "MetalBorders.TextFieldBorder", "MetalBorders.ToggleButtonBorder", "MetalBorders.ToolBarBorder", "MetalButtonUI", "MetalCheckBoxIcon", "MetalCheckBoxUI", "MetalComboBoxButton", "MetalComboBoxEditor", "MetalComboBoxEditor.UIResource", "MetalComboBoxIcon", "MetalComboBoxUI", "MetalDesktopIconUI", "MetalFileChooserUI", "MetalIconFactory", "MetalIconFactory.FileIcon16", "MetalIconFactory.FolderIcon16", "MetalIconFactory.PaletteCloseIcon", "MetalIconFactory.TreeControlIcon", "MetalIconFactory.TreeFolderIcon", "MetalIconFactory.TreeLeafIcon", "MetalInternalFrameTitlePane", "MetalInternalFrameUI", "MetalLabelUI", "MetalLookAndFeel", "MetalPopupMenuSeparatorUI", "MetalProgressBarUI", "MetalRadioButtonUI", "MetalScrollBarUI", "MetalScrollButton", "MetalScrollPaneUI", "MetalSeparatorUI", "MetalSliderUI", "MetalSplitPaneUI", "MetalTabbedPaneUI", "MetalTextFieldUI", "MetalTheme", "MetalToggleButtonUI", "MetalToolBarUI", "MetalToolTipUI", "MetalTreeUI", "MetaMessage", "Method", "MethodDescriptor", "MidiChannel", "MidiDevice", "MidiDevice.Info", "MidiDeviceProvider", "MidiEvent", "MidiFileFormat", "MidiFileReader", "MidiFileWriter", "MidiMessage", "MidiSystem", "MidiUnavailableException", "MimeTypeParseException", "MinimalHTMLWriter", "MissingResourceException", "Mixer", "Mixer.Info", "MixerProvider", "ModificationItem", "Modifier", "MouseAdapter", "MouseDragGestureRecognizer", "MouseEvent", "MouseInputAdapter", "MouseInputListener", "MouseListener", "MouseMotionAdapter", "MouseMotionListener", "MultiButtonUI", "MulticastSocket", "MultiColorChooserUI", "MultiComboBoxUI", "MultiDesktopIconUI", "MultiDesktopPaneUI", "MultiFileChooserUI", "MultiInternalFrameUI", "MultiLabelUI", "MultiListUI", "MultiLookAndFeel", "MultiMenuBarUI", "MultiMenuItemUI", "MultiOptionPaneUI", "MultiPanelUI", "MultiPixelPackedSampleModel", "MultipleMaster", "MultiPopupMenuUI", "MultiProgressBarUI", "MultiScrollBarUI", "MultiScrollPaneUI", "MultiSeparatorUI", "MultiSliderUI", "MultiSplitPaneUI", "MultiTabbedPaneUI", "MultiTableHeaderUI", "MultiTableUI", "MultiTextUI", "MultiToolBarUI", "MultiToolTipUI", "MultiTreeUI", "MultiViewportUI", "MutableAttributeSet", "MutableComboBoxModel", "MutableTreeNode", "Name", "NameAlreadyBoundException", "NameClassPair", "NameComponent", "NameComponentHelper", "NameComponentHolder", "NamedValue", "NameHelper", "NameHolder", "NameNotFoundException", "NameParser", "NamespaceChangeListener", "NameValuePair", "NameValuePairHelper", "Naming", "NamingContext", "NamingContextHelper", "NamingContextHolder", "NamingContextOperations", "NamingEnumeration", "NamingEvent", "NamingException", "NamingExceptionEvent", "NamingListener", "NamingManager", "NamingSecurityException", "NegativeArraySizeException", "NetPermission", "NO_IMPLEMENT", "NO_MEMORY", "NO_PERMISSION", "NO_RESOURCES", "NO_RESPONSE", "NoClassDefFoundError", "NoInitialContextException", "NoninvertibleTransformException", "NoPermissionException", "NoRouteToHostException", "NoSuchAlgorithmException", "NoSuchAttributeException", "NoSuchElementException", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NoSuchObjectException", "NoSuchProviderException", "NotActiveException", "NotBoundException", "NotContextException", "NotEmpty", "NotEmptyHelper", "NotEmptyHolder", "NotFound", "NotFoundHelper", "NotFoundHolder", "NotFoundReason", "NotFoundReasonHelper", "NotFoundReasonHolder", "NotOwnerException", "NotSerializableException", "NullPointerException", "Number", "NumberFormat", "NumberFormatException", "NVList", "OBJ_ADAPTER", "Object", "Object", "OBJECT_NOT_EXIST", "ObjectChangeListener", "ObjectFactory", "ObjectFactoryBuilder", "ObjectHelper", "ObjectHolder", "ObjectImpl", "ObjectImpl", "ObjectInput", "ObjectInputStream", "ObjectInputStream.GetField", "ObjectInputValidation", "ObjectOutput", "ObjectOutputStream", "ObjectOutputStream.PutField", "ObjectStreamClass", "ObjectStreamConstants", "ObjectStreamException", "ObjectStreamField", "ObjectView", "ObjID", "Observable", "Observer", "OctetSeqHelper", "OctetSeqHolder", "OMGVMCID", "OpenType", "Operation", "OperationNotSupportedException", "Option", "OptionalDataException", "OptionPaneUI", "ORB", "ORB", "OutOfMemoryError", "OutputStream", "OutputStream", "OutputStream", "OutputStreamWriter", "OverlayLayout", "Owner", "Package", "PackedColorModel", "Pageable", "PageAttributes", "PageAttributes.ColorType", "PageAttributes.MediaType", "PageAttributes.OrientationRequestedType", "PageAttributes.OriginType", "PageAttributes.PrintQualityType", "PageFormat", "Paint", "PaintContext", "PaintEvent", "Panel", "PanelUI", "Paper", "ParagraphView", "ParagraphView", "ParameterBlock", "ParameterDescriptor", "ParseException", "ParsePosition", "Parser", "ParserDelegator", "PartialResultException", "PasswordAuthentication", "PasswordView", "Patch", "PathIterator", "Permission", "Permission", "PermissionCollection", "Permissions", "PERSIST_STORE", "PhantomReference", "PipedInputStream", "PipedOutputStream", "PipedReader", "PipedWriter", "PixelGrabber", "PixelInterleavedSampleModel", "PKCS8EncodedKeySpec", "PlainDocument", "PlainView", "Point", "Point2D", "Point2D.Double", "Point2D.Float", "Policy", "Policy", "PolicyError", "PolicyHelper", "PolicyHolder", "PolicyListHelper", "PolicyListHolder", "PolicyOperations", "PolicyTypeHelper", "Polygon", "PopupMenu", "PopupMenuEvent", "PopupMenuListener", "PopupMenuUI", "Port", "Port.Info", "PortableRemoteObject", "PortableRemoteObjectDelegate", "Position", "Position.Bias", "PreparedStatement", "Principal", "Principal", "PrincipalHolder", "Printable", "PrinterAbortException", "PrinterException", "PrinterGraphics", "PrinterIOException", "PrinterJob", "PrintGraphics", "PrintJob", "PrintStream", "PrintWriter", "PRIVATE_MEMBER", "PrivateKey", "PrivilegedAction", "PrivilegedActionException", "PrivilegedExceptionAction", "Process", "ProfileDataException", "ProgressBarUI", "ProgressMonitor", "ProgressMonitorInputStream", "Properties", "PropertyChangeEvent", "PropertyChangeListener", "PropertyChangeSupport", "PropertyDescriptor", "PropertyEditor", "PropertyEditorManager", "PropertyEditorSupport", "PropertyPermission", "PropertyResourceBundle", "PropertyVetoException", "ProtectionDomain", "ProtocolException", "Provider", "ProviderException", "Proxy", "PUBLIC_MEMBER", "PublicKey", "PushbackInputStream", "PushbackReader", "QuadCurve2D", "QuadCurve2D.Double", "QuadCurve2D.Float", "Random", "RandomAccessFile", "Raster", "RasterFormatException", "RasterOp", "Reader", "Receiver", "Rectangle", "Rectangle2D", "Rectangle2D.Double", "Rectangle2D.Float", "RectangularShape", "Ref", "RefAddr", "Reference", "Reference", "Referenceable", "ReferenceQueue", "ReferralException", "ReflectPermission", "Registry", "RegistryHandler", "RemarshalException", "Remote", "RemoteCall", "RemoteException", "RemoteObject", "RemoteRef", "RemoteServer", "RemoteStub", "RenderableImage", "RenderableImageOp", "RenderableImageProducer", "RenderContext", "RenderedImage", "RenderedImageFactory", "Renderer", "RenderingHints", "RenderingHints.Key", "RepaintManager", "ReplicateScaleFilter", "Repository", "RepositoryIdHelper", "Request", "RescaleOp", "Resolver", "ResolveResult", "ResourceBundle", "ResponseHandler", "ResultSet", "ResultSetMetaData", "ReverbType", "RGBImageFilter", "RMIClassLoader", "RMIClientSocketFactory", "RMIFailureHandler", "RMISecurityException", "RMISecurityManager", "RMIServerSocketFactory", "RMISocketFactory", "Robot", "RootPaneContainer", "RootPaneUI", "RoundRectangle2D", "RoundRectangle2D.Double", "RoundRectangle2D.Float", "RowMapper", "RSAKey", "RSAKeyGenParameterSpec", "RSAPrivateCrtKey", "RSAPrivateCrtKeySpec", "RSAPrivateKey", "RSAPrivateKeySpec", "RSAPublicKey", "RSAPublicKeySpec", "RTFEditorKit", "RuleBasedCollator", "Runnable", "Runtime", "RunTime", "RuntimeException", "RunTimeOperations", "RuntimePermission", "SampleModel", "SchemaViolationException", "Scrollable", "Scrollbar", "ScrollBarUI", "ScrollPane", "ScrollPaneConstants", "ScrollPaneLayout", "ScrollPaneLayout.UIResource", "ScrollPaneUI", "SearchControls", "SearchResult", "SecureClassLoader", "SecureRandom", "SecureRandomSpi", "Security", "SecurityException", "SecurityManager", "SecurityPermission", "Segment", "SeparatorUI", "Sequence", "SequenceInputStream", "Sequencer", "Sequencer.SyncMode", "Serializable", "SerializablePermission", "ServantObject", "ServerCloneException", "ServerError", "ServerException", "ServerNotActiveException", "ServerRef", "ServerRequest", "ServerRuntimeException", "ServerSocket", "ServiceDetail", "ServiceDetailHelper", "ServiceInformation", "ServiceInformationHelper", "ServiceInformationHolder", "ServiceUnavailableException", "Set", "SetOverrideType", "SetOverrideTypeHelper", "Shape", "ShapeGraphicAttribute", "Short", "ShortHolder", "ShortLookupTable", "ShortMessage", "ShortSeqHelper", "ShortSeqHolder", "Signature", "SignatureException", "SignatureSpi", "SignedObject", "Signer", "SimpleAttributeSet", "SimpleBeanInfo", "SimpleDateFormat", "SimpleTimeZone", "SinglePixelPackedSampleModel", "SingleSelectionModel", "SizeLimitExceededException", "SizeRequirements", "SizeSequence", "Skeleton", "SkeletonMismatchException", "SkeletonNotFoundException", "SliderUI", "Socket", "SocketException", "SocketImpl", "SocketImplFactory", "SocketOptions", "SocketPermission", "SocketSecurityException", "SoftBevelBorder", "SoftReference", "SortedMap", "SortedSet", "Soundbank", "SoundbankReader", "SoundbankResource", "SourceDataLine", "SplitPaneUI", "SQLData", "SQLException", "SQLInput", "SQLOutput", "SQLPermission", "SQLWarning", "Stack", "StackOverflowError", "StateEdit", "StateEditable", "StateFactory", "Statement", "Streamable", "StreamableValue", "StreamCorruptedException", "StreamTokenizer", "StrictMath", "String", "StringBuffer", "StringBufferInputStream", "StringCharacterIterator", "StringContent", "StringHolder", "StringIndexOutOfBoundsException", "StringReader", "StringRefAddr", "StringSelection", "StringTokenizer", "StringValueHelper", "StringWriter", "Stroke", "Struct", "StructMember", "StructMemberHelper", "Stub", "StubDelegate", "StubNotFoundException", "Style", "StyleConstants", "StyleConstants.CharacterConstants", "StyleConstants.ColorConstants", "StyleConstants.FontConstants", "StyleConstants.ParagraphConstants", "StyleContext", "StyledDocument", "StyledEditorKit", "StyledEditorKit.AlignmentAction", "StyledEditorKit.BoldAction", "StyledEditorKit.FontFamilyAction", "StyledEditorKit.FontSizeAction", "StyledEditorKit.ForegroundAction", "StyledEditorKit.ItalicAction", "StyledEditorKit.StyledTextAction", "StyledEditorKit.UnderlineAction", "StyleSheet", "StyleSheet.BoxPainter", "StyleSheet.ListPainter", "SwingConstants", "SwingPropertyChangeSupport", "SwingUtilities", "SyncFailedException", "Synthesizer", "SysexMessage", "System", "SystemColor", "SystemException", "SystemFlavorMap", "TabableView", "TabbedPaneUI", "TabExpander", "TableCellEditor", "TableCellRenderer", "TableColumn", "TableColumnModel", "TableColumnModelEvent", "TableColumnModelListener", "TableHeaderUI", "TableModel", "TableModelEvent", "TableModelListener", "TableUI", "TableView", "TabSet", "TabStop", "TagElement", "TargetDataLine", "TCKind", "TextAction", "TextArea", "TextAttribute", "TextComponent", "TextEvent", "TextField", "TextHitInfo", "TextLayout", "TextLayout.CaretPolicy", "TextListener", "TextMeasurer", "TextUI", "TexturePaint", "Thread", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "Tie", "TileObserver", "Time", "TimeLimitExceededException", "Timer", "Timer", "TimerTask", "Timestamp", "TimeZone", "TitledBorder", "ToolBarUI", "Toolkit", "ToolTipManager", "ToolTipUI", "TooManyListenersException", "Track", "TRANSACTION_REQUIRED", "TRANSACTION_ROLLEDBACK", "TransactionRequiredException", "TransactionRolledbackException", "Transferable", "TransformAttribute", "TRANSIENT", "Transmitter", "Transparency", "TreeCellEditor", "TreeCellRenderer", "TreeExpansionEvent", "TreeExpansionListener", "TreeMap", "TreeModel", "TreeModelEvent", "TreeModelListener", "TreeNode", "TreePath", "TreeSelectionEvent", "TreeSelectionListener", "TreeSelectionModel", "TreeSet", "TreeUI", "TreeWillExpandListener", "TypeCode", "TypeCodeHolder", "TypeMismatch", "Types", "UID", "UIDefaults", "UIDefaults.ActiveValue", "UIDefaults.LazyInputMap", "UIDefaults.LazyValue", "UIDefaults.ProxyLazyValue", "UIManager", "UIManager.LookAndFeelInfo", "UIResource", "ULongLongSeqHelper", "ULongLongSeqHolder", "ULongSeqHelper", "ULongSeqHolder", "UndeclaredThrowableException", "UndoableEdit", "UndoableEditEvent", "UndoableEditListener", "UndoableEditSupport", "UndoManager", "UnexpectedException", "UnicastRemoteObject", "UnionMember", "UnionMemberHelper", "UNKNOWN", "UnknownError", "UnknownException", "UnknownGroupException", "UnknownHostException", "UnknownHostException", "UnknownObjectException", "UnknownServiceException", "UnknownUserException", "UnmarshalException", "UnrecoverableKeyException", "Unreferenced", "UnresolvedPermission", "UnsatisfiedLinkError", "UnsolicitedNotification", "UnsolicitedNotificationEvent", "UnsolicitedNotificationListener", "UNSUPPORTED_POLICY", "UNSUPPORTED_POLICY_VALUE", "UnsupportedAudioFileException", "UnsupportedClassVersionError", "UnsupportedEncodingException", "UnsupportedFlavorException", "UnsupportedLookAndFeelException", "UnsupportedOperationException", "URL", "URLClassLoader", "URLConnection", "URLDecoder", "URLEncoder", "URLStreamHandler", "URLStreamHandlerFactory", "UserException", "UShortSeqHelper", "UShortSeqHolder", "UTFDataFormatException", "Util", "UtilDelegate", "Utilities", "ValueBase", "ValueBaseHelper", "ValueBaseHolder", "ValueFactory", "ValueHandler", "ValueMember", "ValueMemberHelper", "VariableHeightLayoutCache", "Vector", "VerifyError", "VersionSpecHelper", "VetoableChangeListener", "VetoableChangeSupport", "View", "ViewFactory", "ViewportLayout", "ViewportUI", "VirtualMachineError", "Visibility", "VisibilityHelper", "VM_ABSTRACT", "VM_CUSTOM", "VM_NONE", "VM_TRUNCATABLE", "VMID", "VoiceStatus", "Void", "WCharSeqHelper", "WCharSeqHolder", "WeakHashMap", "WeakReference", "Window", "WindowAdapter", "WindowConstants", "WindowEvent", "WindowListener", "WrappedPlainView", "WritableRaster", "WritableRenderedImage", "WriteAbortedException", "Writer", "WrongTransaction", "WStringValueHelper", "X509Certificate", "X509CRL", "X509CRLEntry", "X509EncodedKeySpec", "X509Extension", "ZipEntry", "ZipException", "ZipFile", "ZipInputStream", "ZipOutputStream", "ZoneView", "_BindingIteratorImplBase", "_BindingIteratorStub", "_IDLTypeStub", "_NamingContextImplBase", "_NamingContextStub", "_PolicyStub", "_Remote_Stub", "#", "null"};
    }
}

