/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.LocatableEvent;
import depurador.DepuradorEntorno;
import depurador.DepuradorManagerException;
import depurador.DepuradorMemoriaManager_arbol_treeWillExpandAdapter;
import depurador.MemoriaTreeNodo;
import depurador.MemoriaTreeNodoExpansible;
import depurador.MemoriaTreeNodoModificable;
import depurador.Preferencias;
import depurador.PrimitivoMemoriaTreeNodo;
import depurador.SourceMapper;
import depurador.StackFrameMemoriaTreeNodo;
import depurador.ThreadMemoriaTreeNodo;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DepuradorMemoriaManager {
    private JTree memoriaTree;

    private void redibujarMemoria() {
        DefaultMutableTreeNode raiz = new DefaultMutableTreeNode("Threads");
        Iterator threadsIterator = DepuradorEntorno.getVirtualMachine().allThreads().iterator();
        int fila1 = 0;
        int x2 = 0;
        boolean y2 = false;
        while (threadsIterator.hasNext()) {
            ++x2;
            ThreadReference thread = (ThreadReference)threadsIterator.next();
            ThreadMemoriaTreeNodo raizThread = new ThreadMemoriaTreeNodo(thread);
            if (thread == DepuradorEntorno.getThreadActual()) {
                try {
                    fila1 = x2;
                    raizThread.expandir();
                    Enumeration<TreeNode> enumeration = raizThread.children();
                    if (enumeration.hasMoreElements()) {
                        StackFrameMemoriaTreeNodo nodoAExpandir = (StackFrameMemoriaTreeNodo)enumeration.nextElement();
                        nodoAExpandir.expandir();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            raiz.add(raizThread);
        }
        this.memoriaTree = new JTree(raiz);
        this.memoriaTree.expandPath(this.memoriaTree.getPathForRow(fila1));
        this.memoriaTree.expandPath(this.memoriaTree.getPathForRow(fila1 + 1));
        this.memoriaTree.addTreeWillExpandListener(new DepuradorMemoriaManager_arbol_treeWillExpandAdapter(this));
    }

    public JTree getMemoriaTree() {
        this.redibujarMemoria();
        return this.memoriaTree;
    }

    public void dibujarMemoriaTexto(LocatableEvent e2) {
        try {
            SourceMapper sourceMapper = new SourceMapper(Preferencias.CLASS_PATH);
            File ficheroFuente = sourceMapper.sourceFile(e2.location());
            System.out.println("\tMetodo: " + e2.location().method().name() + " (" + e2.location().method().declaringType().name() + ")");
            StackFrame st = e2.thread().frame(0);
            ObjectReference _this = st.thisObject();
            if (_this != null) {
                Iterator camposThis = _this.referenceType().allFields().iterator();
                while (camposThis != null && camposThis.hasNext()) {
                    Field f2 = (Field)camposThis.next();
                    System.out.println("\tthis." + f2.name() + " = " + st.thisObject().getValue(f2));
                }
            }
            System.out.println("\tFichero: " + ficheroFuente + ": " + e2.location().lineNumber());
            System.out.println("\tFichero sin mapper: " + e2.location().sourcePath());
            Iterator t2 = e2.location().method().variables().iterator();
            while (t2.hasNext()) {
                LocalVariable variable = (LocalVariable)t2.next();
                System.out.print("\tVariable: " + variable.name());
                if (variable.isVisible(st)) {
                    System.out.println("\t = " + st.getValue(variable));
                    continue;
                }
                System.out.println("");
            }
        }
        catch (AbsentInformationException ex) {
            ex.printStackTrace();
        }
        catch (IncompatibleThreadStateException ex) {
            ex.printStackTrace();
        }
    }

    public void cambiarValor(MemoriaTreeNodoModificable treeNodo, String valor) throws DepuradorManagerException {
        if (treeNodo instanceof PrimitivoMemoriaTreeNodo) {
            PrimitivoMemoriaTreeNodo nodo = (PrimitivoMemoriaTreeNodo)treeNodo;
            if (nodo.getPrimitiveType() instanceof IntegerType) {
                try {
                    treeNodo.setValue(DepuradorEntorno.getVirtualMachine().mirrorOf(Integer.valueOf(valor)));
                }
                catch (ClassNotLoadedException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidTypeException ex) {
                    ex.printStackTrace();
                }
                catch (NumberFormatException ex) {
                    throw new DepuradorManagerException(7, "El valor no es valido para el tipo de variable");
                }
            } else if (nodo.getPrimitiveType() instanceof CharType) {
                try {
                    treeNodo.setValue(DepuradorEntorno.getVirtualMachine().mirrorOf(valor.charAt(0)));
                }
                catch (ClassNotLoadedException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidTypeException ex) {
                    ex.printStackTrace();
                }
            } else if (nodo.getPrimitiveType() instanceof FloatType) {
                try {
                    treeNodo.setValue(DepuradorEntorno.getVirtualMachine().mirrorOf(Float.valueOf(valor).floatValue()));
                }
                catch (ClassNotLoadedException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidTypeException ex) {
                    ex.printStackTrace();
                }
                catch (NumberFormatException ex) {
                    throw new DepuradorManagerException(7, "El valor no es valido para el tipo de variable");
                }
            }
        }
    }

    void arbol_treeWillExpand(TreeExpansionEvent e2) throws ExpandVetoException {
        block3: {
            TreePath camino = e2.getPath();
            Object o2 = this.memoriaTree.getLastSelectedPathComponent();
            o2 = camino.getPathComponent(camino.getPathCount() - 1);
            if (!(o2 instanceof DefaultMutableTreeNode) || !(o2 instanceof MemoriaTreeNodo)) break block3;
            MemoriaTreeNodo nodo = (MemoriaTreeNodo)o2;
            try {
                if (nodo.esExpansible()) {
                    ((MemoriaTreeNodoExpansible)((Object)nodo)).expandir();
                }
            }
            catch (IncompatibleThreadStateException ex) {
                ex.printStackTrace();
            }
        }
    }
}

