/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.StepRequest;
import depurador.DepuradorBreakpointManager;
import depurador.DepuradorEntorno;
import depurador.DepuradorEventHandler;
import depurador.DepuradorEventNotifier;
import depurador.DepuradorManagerException;
import depurador.DepuradorMemoriaManager;
import depurador.DepuradorUserInterface;
import depurador.FicheroJava;
import depurador.HiloEscuchaConsola;
import depurador.MemoriaTreeNodoModificable;
import depurador.Preferencias;
import depurador.Profiler;
import depurador.SourceMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;

public class DepuradorManager
implements DepuradorEventNotifier {
    private Vector ficherosVector = new Vector();
    private Vector breakpointsVector = new Vector();
    private File mainFile = null;
    private DepuradorUserInterface userInterface;
    private String JDKPath = "C:\\jdk1.3";
    private DepuradorEventHandler depuradorEventHandler;
    private SourceMapper sourceMapper;
    private DepuradorMemoriaManager memoriaManager;
    private DepuradorBreakpointManager breakpointManager = new DepuradorBreakpointManager();
    private HiloEscuchaConsola hiloConsola = null;

    public DepuradorManager(DepuradorUserInterface userInterface) {
        this.userInterface = userInterface;
    }

    public int indexForFile(File f2) {
        int i2 = 0;
        while (i2 < this.ficherosVector.size()) {
            if (((FicheroJava)this.ficherosVector.elementAt((int)i2)).fichero.equals(f2)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private String estadoThread(ThreadReference thread) {
        String resultado = "";
        switch (thread.status()) {
            case 3: {
                resultado = "monitor";
                break;
            }
            case 5: {
                resultado = "not started";
                break;
            }
            case 1: {
                resultado = "running";
                break;
            }
            case 2: {
                resultado = "sleeping";
                break;
            }
            case -1: {
                resultado = "desconocido";
                break;
            }
            case 4: {
                resultado = "wait";
                break;
            }
            case 0: {
                resultado = "zombie";
            }
        }
        return resultado;
    }

    public void nuevoFichero(File f2) throws DepuradorManagerException {
        if (f2.exists()) {
            if (this.ficherosVector.indexOf(f2) != -1) {
                throw new DepuradorManagerException(5, "Fichero ya a\u00f1adido");
            }
            this.ficherosVector.add(new FicheroJava(f2));
            this.userInterface.nuevoFicheroAbierto(f2);
        }
    }

    public void sacarFichero(File f2) throws DepuradorManagerException {
        int index = this.indexForFile(f2);
        if (index == -1) {
            throw new DepuradorManagerException(3, "El fichero no esta abierto");
        }
        this.ficherosVector.remove(index);
        this.userInterface.ficheroSacado(f2);
    }

    public Vector getFicheros() {
        return this.ficherosVector;
    }

    public void setMainFile(int index) throws DepuradorManagerException {
        FicheroJava ficheroJava = (FicheroJava)this.ficherosVector.get(index);
        if (ficheroJava == null) {
            throw new DepuradorManagerException(2, "El indice de fichero no es valido");
        }
        this.mainFile = ficheroJava.fichero;
    }

    public File getMainFile() {
        return this.mainFile;
    }

    public void setMainFile(File f2) throws DepuradorManagerException {
        try {
            this.setMainFile(this.indexForFile(f2));
        }
        catch (DepuradorManagerException ex) {
            throw new DepuradorManagerException(3, "El fichero no esta abierto, se debe a\u00f1adir antes");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void compilar(int index) throws DepuradorManagerException {
        try {
            String linea;
            FicheroJava ficheroJava = (FicheroJava)this.ficherosVector.get(index);
            System.out.println("classpath: " + Preferencias.CLASS_PATH + Preferencias.PACKAGE_MAIN);
            String classpath = Preferencias.CLASS_PATH + ";" + ficheroJava.fichero.getParent();
            String comando = Preferencias.JDK_HOME + "\\bin\\javac.exe -g -verbose -classpath \"" + classpath + "\" \"" + ficheroJava.fichero.getAbsolutePath() + "\"";
            Process proceso = null;
            try {
                proceso = Runtime.getRuntime().exec(comando);
            }
            catch (IOException e2) {
                throw new DepuradorManagerException(99, "No se puede ejecutar el compilador. Asegurese de que la ruta es correcta o que tiene permisos");
            }
            System.out.println(comando);
            BufferedReader lector = new BufferedReader(new InputStreamReader(proceso.getErrorStream()));
            String errores = "";
            int num_parsing = 0;
            while ((linea = lector.readLine()) != null) {
                void var8_11;
                if (!var8_11.startsWith("[")) {
                    errores = errores + (String)var8_11 + "\n";
                }
                if (var8_11.startsWith("[parsing started")) {
                    ++num_parsing;
                }
                if (num_parsing != 1 || !var8_11.startsWith("[checking")) continue;
                StringTokenizer tk = new StringTokenizer((String)var8_11);
                tk.nextToken();
                String nombreClase = tk.nextToken();
                nombreClase = nombreClase.substring(0, nombreClase.length() - 1);
                ficheroJava.addClase(nombreClase);
            }
            int salida = 1;
            try {
                salida = proceso.waitFor();
            }
            catch (IllegalThreadStateException ex) {
                ex.fillInStackTrace();
            }
            catch (InterruptedException ex) {
                ex.fillInStackTrace();
            }
            if (salida != 0) {
                this.userInterface.informacionDeCompilacion(errores);
                throw new DepuradorManagerException(1, "Hubo errores durante la compilacion.");
            }
            this.userInterface.informacionDeCompilacion("Compilacion de " + ficheroJava.fichero + " correcta");
        }
        catch (IOException ex) {
            throw new DepuradorManagerException(99, "Se produjo una excepcion grave de E/S");
        }
    }

    public void compilar(File f2) throws DepuradorManagerException {
        int index = this.indexForFile(f2);
        if (index == -1) {
            throw new DepuradorManagerException(3, "El fichero no esta abierto");
        }
        this.compilar(index);
    }

    public void compilarTodo() throws DepuradorManagerException {
        int i2 = 0;
        while (i2 < this.ficherosVector.size()) {
            this.compilar(((FicheroJava)this.ficherosVector.elementAt((int)i2)).fichero);
            ++i2;
        }
    }

    public void comenzarDepuracion(boolean compilar) throws DepuradorManagerException {
        File ficheroProfiler;
        File ficheroMain;
        if (compilar) {
            this.compilarTodo();
        }
        if ((ficheroMain = this.getMainFile()) == null || !ficheroMain.exists()) {
            throw new DepuradorManagerException(4, "Fichero main no se encuentra, o no se ha indicado");
        }
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        Map losArgumentos = manager.defaultConnector().defaultArguments();
        String nombreClaseMain = ficheroMain.getName().substring(0, ficheroMain.getName().lastIndexOf("."));
        if (!Preferencias.PACKAGE_MAIN.equals("")) {
            nombreClaseMain = Preferencias.PACKAGE_MAIN + "." + nombreClaseMain;
        }
        ((Connector.Argument)losArgumentos.get("home")).setValue(Preferencias.JDK_HOME);
        ((Connector.Argument)losArgumentos.get("main")).setValue(nombreClaseMain + (Preferencias.PARAMETROS.length() > 0 ? " " + Preferencias.PARAMETROS : ""));
        if (Preferencias.PROFILING && !(ficheroProfiler = new File(Preferencias.JDK_HOME + File.separator + "jre" + File.separator + "bin" + File.separator + "jtiprof.dll")).exists()) {
            Preferencias.PROFILING = false;
            JFrame dummy = new JFrame();
            JOptionPane.showMessageDialog(dummy, "No se encuentra " + ficheroProfiler.getAbsoluteFile() + " Se har\u00e1 la depuraci\u00f3n sin Profiling.", "Error", 0);
            dummy.dispose();
        }
        if (Preferencias.PROFILING) {
            ((Connector.Argument)losArgumentos.get("options")).setValue("-Xrunjtiprof -cp \"" + ficheroMain.getParent() + ";" + Preferencias.CLASS_PATH + "\"");
        } else {
            ((Connector.Argument)losArgumentos.get("options")).setValue("-cp \"" + ficheroMain.getParent() + ";" + Preferencias.CLASS_PATH + "\"");
        }
        try {
            if (Preferencias.PROFILING) {
                new Thread(){

                    public void run() {
                        new Profiler("localhost", 2500).setVisible(true);
                    }
                }.start();
            }
            VirtualMachine vm = manager.defaultConnector().launch(losArgumentos);
            this.hiloConsola = new HiloEscuchaConsola(this.userInterface, vm.process().getInputStream());
            vm.setDebugTraceMode(0);
            DepuradorEntorno.setVirtualMachine(vm);
            this.breakpointManager.generarClassPrepareRequests();
        }
        catch (IOException ex) {
            throw new DepuradorManagerException(5, "imposible comenzar la depuracion, se produjo un error de E/S");
        }
        catch (VMStartException ex) {
            throw new DepuradorManagerException(5, "imposible comenzar la depuracion. Se obtuvo: " + ex.toString());
        }
        catch (IllegalConnectorArgumentsException ex) {
            // empty catch block
        }
        this.depuradorEventHandler = new DepuradorEventHandler();
        this.depuradorEventHandler.addEventNotifier(this);
        this.memoriaManager = new DepuradorMemoriaManager();
        this.depuradorEventHandler.start();
        DepuradorEntorno.setThreadActual((ThreadReference)DepuradorEntorno.getVirtualMachine().allThreads().get(2));
        this.sourceMapper = new SourceMapper(ficheroMain.getParent() + ";" + Preferencias.CLASS_PATH);
        MethodEntryRequest r2 = DepuradorEntorno.getVirtualMachine().eventRequestManager().createMethodEntryRequest();
        r2.setSuspendPolicy(2);
        r2.addClassFilter(nombreClaseMain);
        DepuradorEntorno.getVirtualMachine().resume();
        DepuradorEntorno.setEstadoActual(2);
    }

    public void parar_depuracion() throws DepuradorManagerException {
        int estado = DepuradorEntorno.getEstadoActual();
        if (estado != 1 && estado != 2) {
            throw new DepuradorManagerException(6, "No se esta depurando.");
        }
        this.hiloConsola.stop();
        DepuradorEntorno.getVirtualMachine().exit(1);
        this.breakpointManager.borrarSolicitudes();
    }

    public void pausar_depuracion() throws DepuradorManagerException {
        block7: {
            int estado = DepuradorEntorno.getEstadoActual();
            if (estado != 2) {
                throw new DepuradorManagerException(6, "No se esta ejecutando.");
            }
            System.out.println("DepuradorManager: Tratando de pausar...");
            DepuradorEntorno.getVirtualMachine().suspend();
            DepuradorEntorno.setEstadoActual(1);
            try {
                if (!DepuradorEntorno.getThreadActual().isSuspended()) break block7;
                StackFrame frame = DepuradorEntorno.getThreadActual().frame(0);
                DepuradorEntorno.setLocationActual(frame.location());
                System.out.println("\tPausado en: " + frame.location());
                System.out.println("\tEstado del thread: " + this.estadoThread(DepuradorEntorno.getThreadActual()));
                File ficheroFuente = this.sourceMapper.sourceFile(DepuradorEntorno.getLocationActual());
                if (ficheroFuente == null) {
                    try {
                        this.step_out();
                    }
                    catch (DepuradorManagerException ex) {
                        ex.printStackTrace();
                    }
                    break block7;
                }
                this.userInterface.nuevaSituacionParada(ficheroFuente, DepuradorEntorno.getLocationActual().lineNumber(), this.memoriaManager.getMemoriaTree());
            }
            catch (IncompatibleThreadStateException ex) {
                ex.printStackTrace();
            }
            catch (ObjectCollectedException ex) {
                ex.printStackTrace();
                DepuradorEntorno.setEstadoActual(2);
                DepuradorEntorno.getVirtualMachine().resume();
            }
        }
    }

    public void step_over() throws DepuradorManagerException {
        if (DepuradorEntorno.getEstadoActual() != 1) {
            throw new DepuradorManagerException(6, "no se puede hacer un step ahora");
        }
        System.out.println("DepuradorManager: Creando Step OVER Request...");
        StepRequest s2 = DepuradorEntorno.getVirtualMachine().eventRequestManager().createStepRequest(DepuradorEntorno.getThreadActual(), -2, 2);
        s2.addCountFilter(1);
        s2.setSuspendPolicy(1);
        s2.enable();
        DepuradorEntorno.setEstadoActual(2);
        DepuradorEntorno.getThreadActual().resume();
    }

    public void step_into() throws DepuradorManagerException {
        if (DepuradorEntorno.getEstadoActual() != 1) {
            throw new DepuradorManagerException(6, "no se puede hacer un step ahora");
        }
        System.out.println("DepuradorManager: Creando Step INTO Request...");
        StepRequest s2 = DepuradorEntorno.getVirtualMachine().eventRequestManager().createStepRequest(DepuradorEntorno.getThreadActual(), -2, 1);
        s2.addCountFilter(1);
        s2.setSuspendPolicy(1);
        s2.addCountFilter(1);
        s2.enable();
        DepuradorEntorno.setEstadoActual(2);
        DepuradorEntorno.getThreadActual().resume();
    }

    public void step_out() throws DepuradorManagerException {
        if (DepuradorEntorno.getEstadoActual() != 1) {
            throw new DepuradorManagerException(6, "no se puede hacer un step ahora");
        }
        System.out.println("DepuradorManager: Creando Step OUT Request...");
        StepRequest s2 = DepuradorEntorno.getVirtualMachine().eventRequestManager().createStepRequest(DepuradorEntorno.getThreadActual(), -2, 3);
        s2.addCountFilter(1);
        s2.setSuspendPolicy(1);
        s2.enable();
        DepuradorEntorno.setEstadoActual(2);
        DepuradorEntorno.getThreadActual().resume();
    }

    public void continuar() throws DepuradorManagerException {
        if (DepuradorEntorno.getEstadoActual() != 1) {
            throw new DepuradorManagerException(6, "no se puede hacer un step ahora");
        }
        System.out.println("Generando un resume...");
        DepuradorEntorno.getThreadActual().resume();
        DepuradorEntorno.setEstadoActual(2);
    }

    public void cambiarValor(MemoriaTreeNodoModificable nodo, String valor) throws DepuradorManagerException {
        if (DepuradorEntorno.getEstadoActual() != 1) {
            throw new DepuradorManagerException(6, "no se puede hacer un step ahora");
        }
        this.memoriaManager.cambiarValor(nodo, valor);
    }

    public JTree arbolDeMemoria() throws DepuradorManagerException {
        if (DepuradorEntorno.getEstadoActual() != 1) {
            throw new DepuradorManagerException(6, "no se puede hacer un step ahora");
        }
        return this.memoriaManager.getMemoriaTree();
    }

    public void crearBreakpoint(String patron, int linea) throws DepuradorManagerException {
        if (DepuradorEntorno.getEstadoActual() != 0) {
            throw new DepuradorManagerException(6, "no se puede hacer un step ahora");
        }
        System.out.println("Solicitando breakpoint para el patron: " + patron + ": " + linea);
        this.breakpointManager.addBreakpointSpec(patron, linea);
    }

    public void crearBreakpoint(File f2, int linea) throws DepuradorManagerException {
        int index = this.indexForFile(f2);
        if (index == -1) {
            throw new DepuradorManagerException(3, "El fichero no esta abierto, o no fue compilado");
        }
        FicheroJava ficheroJava = (FicheroJava)this.ficherosVector.elementAt(index);
        Vector clases = ficheroJava.clases;
        int i2 = 0;
        while (i2 < clases.size()) {
            this.crearBreakpoint((String)clases.elementAt(i2), linea);
            ++i2;
        }
    }

    public void vmStartEvent(VMStartEvent e2) {
        System.out.println("DepuradorManager: Recibido un VMStartEvent");
        this.userInterface.comienzoDepuracion();
    }

    public void vmDeathEvent(VMDeathEvent e2) {
        System.out.println("DepuradorManager: Recibido un VMDeathEvent");
        this.depuradorEventHandler.stop();
        DepuradorEntorno.setEstadoActual(0);
        this.userInterface.finDepuracion();
        DepuradorEntorno.eliminarVirtualMachine();
        this.breakpointManager.borrarSolicitudes();
        this.hiloConsola.stop();
    }

    public void vmDisconnectEvent(VMDisconnectEvent e2) {
        System.out.println("DepuradorManager: Recibido un VMDisconnectEvent");
        this.depuradorEventHandler.stop();
        DepuradorEntorno.setEstadoActual(0);
        this.userInterface.finDepuracion();
        DepuradorEntorno.eliminarVirtualMachine();
        this.breakpointManager.borrarSolicitudes();
        this.hiloConsola.stop();
    }

    public void threadStartEvent(ThreadStartEvent e2) {
        System.out.println("DepuradorManager: Recibido un ThreadStartEvent");
    }

    public void threadDeathEvent(ThreadDeathEvent e2) {
        System.out.println("DepuradorManager: Recibido un ThreadDeathEvent");
    }

    public void classPrepareEvent(ClassPrepareEvent e2) {
        System.out.println("DepuradorManager: Recibido un ClassPrepareEvent");
        System.out.println("\tNombre de la Clase: " + e2.referenceType().name());
        e2.virtualMachine().eventRequestManager().deleteEventRequest(e2.request());
        try {
            this.breakpointManager.nuevaClaseCargada(e2);
            DepuradorEntorno.getVirtualMachine().resume();
        }
        catch (DepuradorManagerException ex) {
            ex.printStackTrace();
        }
    }

    public void classUnloadEvent(ClassUnloadEvent e2) {
        System.out.println("DepuradorManager: Recibido un ClassUnloadEvent");
    }

    public void breakpointEvent(BreakpointEvent e2) {
        System.out.println("DepuradorManager: Recibido un BreakpointEvent " + e2.location());
        DepuradorEntorno.setEstadoActual(1);
        DepuradorEntorno.setLocationActual(e2.location());
        DepuradorEntorno.setThreadActual(e2.thread());
        e2.request().enable();
        DepuradorEntorno.getVirtualMachine().eventRequestManager().deleteEventRequests(DepuradorEntorno.getVirtualMachine().eventRequestManager().stepRequests());
        File ficheroFuente = this.sourceMapper.sourceFile(e2.location());
        if (ficheroFuente == null) {
            try {
                this.step_out();
            }
            catch (DepuradorManagerException ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("\t" + ficheroFuente);
            this.userInterface.nuevaSituacionParada(ficheroFuente, e2.location().lineNumber(), this.memoriaManager.getMemoriaTree());
        }
    }

    public void fieldWatchEvent(WatchpointEvent e2) {
        System.out.println("DepuradorManager: Recibido un WatchpointEvent");
    }

    public void stepEvent(StepEvent e2) {
        DepuradorEntorno.setEstadoActual(1);
        DepuradorEntorno.setLocationActual(e2.location());
        DepuradorEntorno.setThreadActual(e2.thread());
        System.out.println("DepuradorManager: Recibido un StepEvent");
        e2.virtualMachine().eventRequestManager().deleteEventRequest(e2.request());
        File ficheroFuente = this.sourceMapper.sourceFile(e2.location());
        if (ficheroFuente == null) {
            try {
                this.step_out();
            }
            catch (DepuradorManagerException ex) {
                ex.printStackTrace();
            }
        } else {
            this.userInterface.nuevaSituacionParada(ficheroFuente, e2.location().lineNumber(), this.memoriaManager.getMemoriaTree());
        }
    }

    public void exceptionEvent(ExceptionEvent e2) {
        System.out.println("DepuradorManager: Recibido un ExceptionEvent");
    }

    public void methodEntryEvent(MethodEntryEvent e2) {
        DepuradorEntorno.setEstadoActual(1);
        DepuradorEntorno.setLocationActual(e2.location());
        System.out.println("DepuradorManager: Recibido un MethodEntryEvent");
        e2.virtualMachine().eventRequestManager().deleteEventRequest(e2.request());
        try {
            this.userInterface.nuevaSituacionParada(new File(e2.method().location().sourcePath()), e2.method().location().lineNumber(), this.memoriaManager.getMemoriaTree());
        }
        catch (AbsentInformationException ex) {
            System.out.println("\t Archivo fuente: *No disponible*");
        }
    }

    public void methodExitEvent(MethodExitEvent e2) {
        System.out.println("DepuradorManager: Recibido un MethodExitEvent");
    }

    public void vmInterrupted() {
        System.out.println("DepuradorManager: la VM se ha interrumpido");
        this.depuradorEventHandler.stop();
        DepuradorEntorno.setEstadoActual(0);
        this.userInterface.finDepuracion();
        DepuradorEntorno.eliminarVirtualMachine();
        this.breakpointManager.borrarSolicitudes();
        this.hiloConsola.stop();
    }

    public void receivedEvent(Event event) {
        System.out.println("DepuradorManager: Recibido un evento desconocido: " + event);
    }
}

