/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import depurador.BreakpointSpec;
import depurador.DepuradorEntorno;
import depurador.DepuradorManagerException;
import java.util.Iterator;
import java.util.Vector;

public class DepuradorBreakpointManager {
    private Vector breakpointSolicitados = new Vector();

    private int indexOf(String classpattern) {
        int i2 = 0;
        while (i2 < this.breakpointSolicitados.size()) {
            BreakpointSpec spec = (BreakpointSpec)this.breakpointSolicitados.elementAt(i2);
            if (spec.classPattern.equals(classpattern)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void addBreakpointSpec(String classpattern, int linea) {
        int index = this.indexOf(classpattern);
        if (index != -1) {
            BreakpointSpec spec = (BreakpointSpec)this.breakpointSolicitados.elementAt(index);
            spec.addLinea(linea);
        } else {
            this.breakpointSolicitados.add(new BreakpointSpec(classpattern, linea));
        }
    }

    public void generarClassPrepareRequests() {
        EventRequestManager eManager = DepuradorEntorno.getVirtualMachine().eventRequestManager();
        int i2 = this.breakpointSolicitados.size() - 1;
        while (i2 >= 0) {
            BreakpointSpec spec = (BreakpointSpec)this.breakpointSolicitados.elementAt(i2);
            ClassPrepareRequest request = eManager.createClassPrepareRequest();
            request.addClassFilter(spec.classPattern);
            request.setSuspendPolicy(1);
            spec.setPrepareRequest(request);
            request.enable();
            --i2;
        }
    }

    public void nuevaClaseCargada(ClassPrepareEvent e2) throws DepuradorManagerException {
        EventRequestManager eManager = DepuradorEntorno.getVirtualMachine().eventRequestManager();
        BreakpointSpec spec = null;
        int numLinea = 0;
        try {
            int i2 = 0;
            while (i2 < this.breakpointSolicitados.size()) {
                spec = (BreakpointSpec)this.breakpointSolicitados.elementAt(i2);
                if (e2.request().equals(spec.prepareRequest)) {
                    Vector lineas = spec.numLineas;
                    int j2 = 0;
                    while (j2 < lineas.size()) {
                        numLinea = (Integer)lineas.elementAt(j2);
                        try {
                            Iterator locationIterator = e2.referenceType().locationsOfLine(numLinea).iterator();
                            if (locationIterator.hasNext()) {
                                Location loc = (Location)locationIterator.next();
                                BreakpointRequest rec = eManager.createBreakpointRequest(loc);
                                rec.setSuspendPolicy(1);
                                rec.enable();
                                System.out.println("Creado " + rec);
                            }
                        }
                        catch (InvalidLineNumberException ex) {
                            System.out.println("La linea " + e2.referenceType().name() + ": " + numLinea + " no vale, se ignora");
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        catch (AbsentInformationException ex) {
            ex.printStackTrace();
        }
    }

    public void borrarSolicitudes() {
        this.breakpointSolicitados = new Vector();
    }
}

