/*
 * Decompiled with CFR 0.152.
 */
package depurador;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import depurador.MemoriaTreeNodo;
import depurador.MemoriaTreeNodoExpansible;
import depurador.ObjetoMemoriaTreeNodo;
import depurador.PrimitivoMemoriaTreeNodo;
import javax.swing.tree.DefaultMutableTreeNode;

public class ArrayMemoriaTreeNodo
extends MemoriaTreeNodo
implements MemoriaTreeNodoExpansible {
    private boolean estaExpandido = false;
    private String nombre;
    private ArrayType tipo;

    public ArrayMemoriaTreeNodo(ArrayType tipo, ArrayReference a2, String nombre) {
        super(a2);
        this.tipo = tipo;
        this.nombre = nombre;
        if (nombre == null) {
            this.nombre = "*sin nombre*";
        }
        this.add(new DefaultMutableTreeNode("info sin calcular"));
    }

    public boolean esExpansible() {
        return true;
    }

    public boolean esModificable() {
        return false;
    }

    public ArrayReference getArrayReference() {
        return (ArrayReference)this.getMirror();
    }

    public boolean estaExpandido() {
        return this.estaExpandido;
    }

    public MemoriaTreeNodo expandir() throws IncompatibleThreadStateException {
        if (this.estaExpandido) {
            return this;
        }
        this.removeAllChildren();
        int i2 = 0;
        while (i2 < this.getArrayReference().length()) {
            Value valor = this.getArrayReference().getValue(i2);
            if (valor != null) {
                MemoriaTreeNodo nuevoNodo;
                if (valor instanceof ObjectReference) {
                    if (valor instanceof ArrayReference) {
                        nuevoNodo = new ArrayMemoriaTreeNodo(this.tipo, (ArrayReference)valor, "[" + i2 + "]");
                        this.add(nuevoNodo);
                    } else {
                        try {
                            nuevoNodo = new ObjetoMemoriaTreeNodo((ReferenceType)((ArrayType)this.getArrayReference().type()).componentType(), (ObjectReference)valor, "[" + i2 + "]");
                            this.add(nuevoNodo);
                        }
                        catch (ClassNotLoadedException ex) {}
                    }
                } else if (valor.type() instanceof PrimitiveType) {
                    nuevoNodo = new PrimitivoMemoriaTreeNodo((PrimitiveType)valor.type(), this.getArrayReference(), i2);
                    this.add(nuevoNodo);
                }
            }
            ++i2;
        }
        this.estaExpandido = true;
        return this;
    }

    public String toString() {
        return "" + this.tipo.name() + " " + this.nombre;
    }
}

