/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ThreadGroupReferenceImpl
extends ObjectReferenceImpl
implements ThreadGroupReference,
VMListener {
    String name;
    ThreadGroupReference parent;
    boolean triedParent;

    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ThreadGroupReferenceImpl(VirtualMachine virtualMachine, long l2) {
        super(virtualMachine, l2);
        this.vm.state().addListener(this);
    }

    protected String description() {
        return "ThreadGroupReference " + this.uniqueID();
    }

    public String name() {
        if (this.name == null) {
            try {
                this.name = JDWP.ThreadGroupReference.Name.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).groupName;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.name;
    }

    public ThreadGroupReference parent() {
        if (!this.triedParent) {
            try {
                this.parent = JDWP.ThreadGroupReference.Parent.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).parentGroup;
                this.triedParent = true;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.parent;
    }

    public void suspend() {
        List list = this.threads();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ThreadReference)iterator.next()).suspend();
        }
        List list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).suspend();
        }
    }

    public void resume() {
        List list = this.threads();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ThreadReference)iterator.next()).resume();
        }
        List list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).resume();
        }
    }

    private JDWP.ThreadGroupReference.Children kids() {
        JDWP.ThreadGroupReference.Children children = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                children = cache.kids;
            }
            if (children == null) {
                children = JDWP.ThreadGroupReference.Children.process(this.vm, this);
                if (cache != null) {
                    cache.kids = children;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching children ");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return children;
    }

    public List threads() {
        return Arrays.asList(this.kids().childThreads);
    }

    public List threadGroups() {
        return Arrays.asList(this.kids().childGroups);
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    byte typeValueKey() {
        return 103;
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        JDWP.ThreadGroupReference.Children kids = null;

        private Cache() {
        }
    }
}

