/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventSet;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.EventQueueImpl;
import com.sun.tools.jdi.EventSetImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.Packet;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TargetVM
implements Runnable {
    private Map waitingQueue = new HashMap(32, 0.75f);
    private boolean shouldListen = true;
    private List eventQueues = Collections.synchronizedList(new ArrayList(2));
    private VirtualMachineImpl vm;
    private ConnectionService connection;
    private Thread readerThread;
    private EventController eventController = null;
    private boolean eventsHeld = false;
    private static final int OVERLOADED_QUEUE = 2000;
    private static final int UNDERLOADED_QUEUE = 100;

    TargetVM(VirtualMachineImpl virtualMachineImpl, ConnectionService connectionService) {
        this.vm = virtualMachineImpl;
        this.connection = connectionService;
        this.readerThread = new Thread(virtualMachineImpl.threadGroupForJDI(), this, "JDI Target VM Interface");
        this.readerThread.setDaemon(true);
    }

    void start() {
        this.readerThread.start();
    }

    private void dumpPacket(Packet packet, boolean bl) {
        CharSequence charSequence;
        String string;
        String string2 = string = bl ? "Sending" : "Receiving";
        if (bl) {
            this.vm.printTrace(string + " Command. id=" + packet.id + ", length=" + packet.data.length + ", commandSet=" + packet.cmdSet + ", command=" + packet.cmd + ", flags=" + packet.flags);
        } else {
            charSequence = (packet.flags & 0x80) != 0 ? "Reply" : "Event";
            this.vm.printTrace(string + " " + (String)charSequence + ". id=" + packet.id + ", length=" + packet.data.length + ", errorCode=" + packet.errorCode + ", flags=" + packet.flags);
        }
        charSequence = new StringBuffer(80);
        ((StringBuffer)charSequence).append("0000: ");
        int n2 = 0;
        while (n2 < packet.data.length) {
            String string3;
            int n3;
            if (n2 > 0 && n2 % 16 == 0) {
                this.vm.printTrace(((StringBuffer)charSequence).toString());
                ((StringBuffer)charSequence).setLength(0);
                ((StringBuffer)charSequence).append(String.valueOf(n2));
                ((StringBuffer)charSequence).append(": ");
                n3 = ((StringBuffer)charSequence).length();
                int n4 = 0;
                while (n4 < 6 - n3) {
                    ((StringBuffer)charSequence).insert(0, '0');
                    ++n4;
                }
            }
            if ((string3 = Integer.toHexString(n3 = 0xFF & packet.data[n2])).length() == 1) {
                ((StringBuffer)charSequence).append('0');
            }
            ((StringBuffer)charSequence).append(string3);
            ((StringBuffer)charSequence).append(' ');
            ++n2;
        }
        if (((StringBuffer)charSequence).length() > 6) {
            this.vm.printTrace(((StringBuffer)charSequence).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object object2;
        if ((this.vm.traceFlags & 1) != 0) {
            this.vm.printTrace("Target VM interface thread running");
        }
        while (this.shouldListen) {
            Packet packet;
            Packet packet2;
            try {
                packet2 = this.connection.receivePacket();
            }
            catch (IOException iOException) {
                if (!this.shouldListen) break;
                this.shouldListen = false;
                this.connection.close();
                break;
            }
            if ((this.vm.traceFlags & VirtualMachineImpl.TRACE_RAW_RECEIVES) != 0) {
                this.dumpPacket(packet2, false);
            }
            if ((packet2.flags & 0x80) == 0) {
                this.handleVMCommand(packet2);
                continue;
            }
            this.vm.state().notifyCommandComplete(packet2.id);
            String string = String.valueOf(packet2.id);
            object2 = this.waitingQueue;
            synchronized (object2) {
                packet = (Packet)this.waitingQueue.get(string);
                if (packet != null) {
                    this.waitingQueue.remove(string);
                }
            }
            if (packet == null) {
                System.err.println("Recieved reply with no sender!");
                continue;
            }
            packet.errorCode = packet2.errorCode;
            packet.data = packet2.data;
            packet.replied = true;
            object = packet;
            synchronized (object) {
                packet.notify();
            }
        }
        this.vm.vmManager.disposeVirtualMachine(this.vm);
        object2 = this.eventQueues;
        synchronized (object2) {
            object = this.eventQueues.iterator();
            while (object.hasNext()) {
                ((EventQueueImpl)object.next()).close();
            }
        }
        object = this.waitingQueue;
        synchronized (object) {
            Iterator iterator = this.waitingQueue.values().iterator();
            while (iterator.hasNext()) {
                Packet packet;
                Packet packet3 = packet = (Packet)iterator.next();
                synchronized (packet3) {
                    packet.notify();
                }
            }
            this.waitingQueue.clear();
        }
        if ((this.vm.traceFlags & 1) != 0) {
            this.vm.printTrace("Target VM interface thread exiting");
        }
    }

    protected void handleVMCommand(Packet packet) {
        switch (packet.cmdSet) {
            case 64: {
                this.handleEventCmdSet(packet);
                break;
            }
            default: {
                System.err.println("Ignoring cmd " + packet.id + "/" + packet.cmdSet + "/" + packet.cmd + " from the VM");
                return;
            }
        }
    }

    protected void handleEventCmdSet(Packet packet) {
        EventSetImpl eventSetImpl = new EventSetImpl((VirtualMachine)this.vm, packet);
        if (eventSetImpl != null) {
            this.queueEventSet(eventSetImpl);
        }
    }

    private EventController eventController() {
        if (this.eventController == null) {
            this.eventController = new EventController(this.vm);
        }
        return this.eventController;
    }

    private synchronized void controlEventFlow(int n2) {
        if (!this.eventsHeld && n2 > 2000) {
            this.eventController().hold();
            this.eventsHeld = true;
        } else if (this.eventsHeld && n2 < 100) {
            this.eventController().release();
            this.eventsHeld = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDequeueEventSet() {
        int n2 = 0;
        List list = this.eventQueues;
        synchronized (list) {
            Iterator iterator = this.eventQueues.iterator();
            while (iterator.hasNext()) {
                EventQueueImpl eventQueueImpl = (EventQueueImpl)iterator.next();
                n2 = Math.max(n2, eventQueueImpl.size());
            }
        }
        this.controlEventFlow(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEventSet(EventSet eventSet) {
        int n2 = 0;
        List list = this.eventQueues;
        synchronized (list) {
            Iterator iterator = this.eventQueues.iterator();
            while (iterator.hasNext()) {
                EventQueueImpl eventQueueImpl = (EventQueueImpl)iterator.next();
                eventQueueImpl.enqueue(eventSet);
                n2 = Math.max(n2, eventQueueImpl.size());
            }
        }
        this.controlEventFlow(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Packet packet) {
        String string = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            this.waitingQueue.put(string, packet);
        }
        if ((this.vm.traceFlags & VirtualMachineImpl.TRACE_RAW_SENDS) != 0) {
            this.dumpPacket(packet, true);
        }
        try {
            this.connection.sendPacket(packet);
        }
        catch (IOException iOException) {
            throw new VMDisconnectedException(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForReply(Packet packet) {
        Packet packet2 = packet;
        synchronized (packet2) {
            while (!packet.replied && this.shouldListen) {
                try {
                    packet.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (packet.replied) return;
            throw new VMDisconnectedException();
        }
    }

    void addEventQueue(EventQueueImpl eventQueueImpl) {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("New event queue added");
        }
        this.eventQueues.add(eventQueueImpl);
    }

    void stopListening() {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("Target VM i/f closing event queues");
        }
        this.shouldListen = false;
        this.connection.close();
    }

    private static class EventController
    extends Thread {
        VirtualMachineImpl vm;
        int controlRequest = 0;

        EventController(VirtualMachineImpl virtualMachineImpl) {
            super(virtualMachineImpl.threadGroupForJDI(), "JDI Event Control Thread");
            this.vm = virtualMachineImpl;
            this.setDaemon(true);
            this.setPriority(7);
            super.start();
        }

        synchronized void hold() {
            ++this.controlRequest;
            this.notifyAll();
        }

        synchronized void release() {
            --this.controlRequest;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                int n2;
                EventController eventController = this;
                synchronized (eventController) {
                    while (this.controlRequest == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    n2 = this.controlRequest;
                    this.controlRequest = 0;
                }
                try {
                    if (n2 > 0) {
                        JDWP.VirtualMachine.HoldEvents.process(this.vm);
                        continue;
                    }
                    JDWP.VirtualMachine.ReleaseEvents.process(this.vm);
                    continue;
                }
                catch (JDWPException jDWPException) {
                    jDWPException.toJDIException().printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

