/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.SharedMemoryConnection;
import com.sun.tools.jdi.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class SharedMemoryTransport
implements TransportService {
    private static final String NAME = "dt_shmem";
    private Map listenMap = new HashMap();

    SharedMemoryTransport() {
        System.loadLibrary(NAME);
        this.initialize();
    }

    public String name() {
        return NAME;
    }

    public boolean supportsMultipleConnections() {
        return true;
    }

    private native void initialize();

    private native long startListening0(String var1) throws IOException;

    private native long attach0(String var1) throws IOException;

    private native void stopListening0(long var1) throws IOException;

    private native long accept0(long var1) throws IOException;

    private native String name(long var1) throws IOException;

    public ConnectionService attach(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("address is null");
        }
        long l2 = this.attach0(string);
        return new SharedMemoryConnection(l2);
    }

    public String startListening(String string) throws IOException {
        long l2 = this.startListening0(string);
        string = this.name(l2);
        this.listenMap.put(string, new Long(l2));
        return string;
    }

    public String startListening() throws IOException {
        return this.startListening(null);
    }

    public void stopListening(String string) throws IOException {
        Long l2 = (Long)this.listenMap.remove(string);
        if (l2 == null) {
            throw new IllegalArgumentException("Invalid address");
        }
        this.stopListening0(l2);
    }

    public ConnectionService accept(String string) throws IOException {
        Long l2 = (Long)this.listenMap.get(string);
        if (l2 == null) {
            throw new IllegalArgumentException("Invalid address");
        }
        long l3 = l2;
        long l4 = this.accept0(l3);
        return new SharedMemoryConnection(l4);
    }
}

