/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.Packet;
import java.io.IOException;

class SharedMemoryConnection
implements ConnectionService {
    private long id;
    private Object receiveLock = new Object();
    private Object sendLock = new Object();
    private boolean closed = false;

    SharedMemoryConnection(long l2) throws IOException {
        this.id = l2;
    }

    private native void close0(long var1);

    private native byte receiveByte0(long var1) throws IOException;

    private native void sendByte0(long var1, byte var3) throws IOException;

    private native void receivePacket0(long var1, Packet var3) throws IOException;

    private native void sendPacket0(long var1, Packet var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                if (!this.closed) {
                    this.closed = true;
                    this.close0(this.id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte receiveByte() throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            return this.receiveByte0(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendByte(byte by) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            this.sendByte0(this.id, by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet receivePacket() throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            Packet packet = new Packet();
            this.receivePacket0(this.id, packet);
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            this.sendPacket0(this.id, packet);
        }
    }
}

