/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ReferenceTypeImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class SDE {
    private static final int INIT_SIZE_FILE = 3;
    private static final int INIT_SIZE_LINE = 100;
    private static final int INIT_SIZE_STRATUM = 3;
    static final String BASE_STRATUM_NAME = "Java";
    static final String NullString = null;
    private FileTableRecord[] fileTable = null;
    private LineTableRecord[] lineTable = null;
    private StratumTableRecord[] stratumTable = null;
    private int fileIndex = 0;
    private int lineIndex = 0;
    private int stratumIndex = 0;
    private int currentFileId = 0;
    private int defaultStratumIndex = -1;
    private int baseStratumIndex = -2;
    private int sdePos = 0;
    final String sourceDebugExtension;
    String jplsFilename = null;
    String defaultStratumId = null;
    boolean isValid = false;

    SDE(String string) {
        this.sourceDebugExtension = string;
        this.decode();
    }

    SDE() {
        this.sourceDebugExtension = null;
        this.createProxyForAbsentSDE();
    }

    char sdePeek() {
        if (this.sdePos >= this.sourceDebugExtension.length()) {
            this.syntax();
        }
        return this.sourceDebugExtension.charAt(this.sdePos);
    }

    char sdeRead() {
        if (this.sdePos >= this.sourceDebugExtension.length()) {
            this.syntax();
        }
        return this.sourceDebugExtension.charAt(this.sdePos++);
    }

    void sdeAdvance() {
        ++this.sdePos;
    }

    void syntax() {
        throw new InternalError("bad SourceDebugExtension syntax - position " + this.sdePos);
    }

    void syntax(String string) {
        throw new InternalError("bad SourceDebugExtension syntax: " + string);
    }

    void assureLineTableSize() {
        int n2;
        int n3 = n2 = this.lineTable == null ? 0 : this.lineTable.length;
        if (this.lineIndex >= n2) {
            int n4 = n2 == 0 ? 100 : n2 * 2;
            LineTableRecord[] lineTableRecordArray = new LineTableRecord[n4];
            int n5 = 0;
            while (n5 < n2) {
                lineTableRecordArray[n5] = this.lineTable[n5];
                ++n5;
            }
            while (n5 < n4) {
                lineTableRecordArray[n5] = new LineTableRecord();
                ++n5;
            }
            this.lineTable = lineTableRecordArray;
        }
    }

    void assureFileTableSize() {
        int n2;
        int n3 = n2 = this.fileTable == null ? 0 : this.fileTable.length;
        if (this.fileIndex >= n2) {
            int n4 = n2 == 0 ? 3 : n2 * 2;
            FileTableRecord[] fileTableRecordArray = new FileTableRecord[n4];
            int n5 = 0;
            while (n5 < n2) {
                fileTableRecordArray[n5] = this.fileTable[n5];
                ++n5;
            }
            while (n5 < n4) {
                fileTableRecordArray[n5] = new FileTableRecord();
                ++n5;
            }
            this.fileTable = fileTableRecordArray;
        }
    }

    void assureStratumTableSize() {
        int n2;
        int n3 = n2 = this.stratumTable == null ? 0 : this.stratumTable.length;
        if (this.stratumIndex >= n2) {
            int n4 = n2 == 0 ? 3 : n2 * 2;
            StratumTableRecord[] stratumTableRecordArray = new StratumTableRecord[n4];
            int n5 = 0;
            while (n5 < n2) {
                stratumTableRecordArray[n5] = this.stratumTable[n5];
                ++n5;
            }
            while (n5 < n4) {
                stratumTableRecordArray[n5] = new StratumTableRecord();
                ++n5;
            }
            this.stratumTable = stratumTableRecordArray;
        }
    }

    String readLine() {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        this.ignoreWhite();
        while ((c2 = this.sdeRead()) != '\n' && c2 != '\r') {
            stringBuffer.append(c2);
        }
        if (c2 == '\r' && this.sdePeek() == '\n') {
            this.sdeRead();
        }
        this.ignoreWhite();
        return stringBuffer.toString();
    }

    private int defaultStratumTableIndex() {
        if (this.defaultStratumIndex == -1 && this.defaultStratumId != null) {
            this.defaultStratumIndex = this.stratumTableIndex(this.defaultStratumId);
        }
        return this.defaultStratumIndex;
    }

    int stratumTableIndex(String string) {
        if (string == null) {
            return this.defaultStratumTableIndex();
        }
        int n2 = 0;
        while (n2 < this.stratumIndex - 1) {
            if (this.stratumTable[n2].id.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return this.defaultStratumTableIndex();
    }

    Stratum stratum(String string) {
        int n2 = this.stratumTableIndex(string);
        return new Stratum(n2);
    }

    List availableStrata() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < this.stratumIndex - 1) {
            StratumTableRecord stratumTableRecord = this.stratumTable[n2];
            arrayList.add(stratumTableRecord.id);
            ++n2;
        }
        return arrayList;
    }

    void ignoreWhite() {
        char c2;
        while ((c2 = this.sdePeek()) == ' ' || c2 == '\t') {
            this.sdeAdvance();
        }
    }

    void ignoreLine() {
        char c2;
        while ((c2 = this.sdeRead()) != '\n' && c2 != '\r') {
        }
        if (c2 == '\r' && this.sdePeek() == '\n') {
            this.sdeAdvance();
        }
        this.ignoreWhite();
    }

    int readNumber() {
        char c2;
        int n2 = 0;
        this.ignoreWhite();
        while ((c2 = this.sdePeek()) >= '0' && c2 <= '9') {
            this.sdeAdvance();
            n2 = n2 * 10 + c2 - 48;
        }
        this.ignoreWhite();
        return n2;
    }

    void storeFile(int n2, String string, String string2) {
        this.assureFileTableSize();
        this.fileTable[this.fileIndex].fileId = n2;
        this.fileTable[this.fileIndex].sourceName = string;
        this.fileTable[this.fileIndex].sourcePath = string2;
        ++this.fileIndex;
    }

    void fileLine() {
        boolean bl = false;
        String string = null;
        if (this.sdePeek() == '+') {
            this.sdeAdvance();
            bl = true;
        }
        int n2 = this.readNumber();
        String string2 = this.readLine();
        if (bl) {
            string = this.readLine();
        }
        this.storeFile(n2, string2, string);
    }

    void storeLine(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.assureLineTableSize();
        this.lineTable[this.lineIndex].jplsStart = n2;
        this.lineTable[this.lineIndex].jplsEnd = n3;
        this.lineTable[this.lineIndex].jplsLineInc = n4;
        this.lineTable[this.lineIndex].njplsStart = n5;
        this.lineTable[this.lineIndex].njplsEnd = n6;
        this.lineTable[this.lineIndex].fileId = n7;
        ++this.lineIndex;
    }

    void lineLine() {
        int n2 = 1;
        int n3 = 1;
        int n4 = this.readNumber();
        if (this.sdePeek() == '#') {
            this.sdeAdvance();
            this.currentFileId = this.readNumber();
        }
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            n2 = this.readNumber();
        }
        if (this.sdeRead() != ':') {
            this.syntax();
        }
        int n5 = this.readNumber();
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            n3 = this.readNumber();
        }
        this.ignoreLine();
        this.storeLine(n5, n5 + n2 * n3 - 1, n3, n4, n4 + n2 - 1, this.currentFileId);
    }

    void storeStratum(String string) {
        if (this.stratumIndex > 0 && this.stratumTable[this.stratumIndex - 1].fileIndex == this.fileIndex && this.stratumTable[this.stratumIndex - 1].lineIndex == this.lineIndex) {
            --this.stratumIndex;
        }
        this.assureStratumTableSize();
        this.stratumTable[this.stratumIndex].id = string;
        this.stratumTable[this.stratumIndex].fileIndex = this.fileIndex;
        this.stratumTable[this.stratumIndex].lineIndex = this.lineIndex;
        ++this.stratumIndex;
        this.currentFileId = 0;
    }

    void stratumSection() {
        this.storeStratum(this.readLine());
    }

    void fileSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.fileLine();
        }
    }

    void lineSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.lineLine();
        }
    }

    void ignoreSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.ignoreLine();
        }
    }

    void createJavaStratum() {
        this.baseStratumIndex = this.stratumIndex;
        this.storeStratum(BASE_STRATUM_NAME);
        this.storeFile(1, this.jplsFilename, NullString);
        this.storeLine(1, 65536, 1, 1, 65536, 1);
        this.storeStratum("Aux");
    }

    void decode() {
        if (this.sourceDebugExtension.length() < 4 || this.sdeRead() != 'S' || this.sdeRead() != 'M' || this.sdeRead() != 'A' || this.sdeRead() != 'P') {
            return;
        }
        this.ignoreLine();
        this.jplsFilename = this.readLine();
        this.defaultStratumId = this.readLine();
        this.createJavaStratum();
        block6: while (true) {
            if (this.sdeRead() != '*') {
                this.syntax();
            }
            switch (this.sdeRead()) {
                case 'S': {
                    this.stratumSection();
                    continue block6;
                }
                case 'F': {
                    this.fileSection();
                    continue block6;
                }
                case 'L': {
                    this.lineSection();
                    continue block6;
                }
                case 'E': {
                    this.storeStratum("*terminator*");
                    this.isValid = true;
                    return;
                }
            }
            this.ignoreSection();
        }
    }

    void createProxyForAbsentSDE() {
        this.jplsFilename = null;
        this.defaultStratumId = BASE_STRATUM_NAME;
        this.defaultStratumIndex = this.stratumIndex;
        this.createJavaStratum();
        this.storeStratum("*terminator*");
    }

    private int stiLineTableIndex(int n2, int n3) {
        int n4 = this.stratumTable[n2].lineIndex;
        int n5 = this.stratumTable[n2 + 1].lineIndex;
        int n6 = n4;
        while (n6 < n5) {
            if (n3 >= this.lineTable[n6].jplsStart && n3 <= this.lineTable[n6].jplsEnd) {
                return n6;
            }
            ++n6;
        }
        return -1;
    }

    private int stiLineNumber(int n2, int n3, int n4) {
        return this.lineTable[n3].njplsStart + (n4 - this.lineTable[n3].jplsStart) / this.lineTable[n3].jplsLineInc;
    }

    private int fileTableIndex(int n2, int n3) {
        int n4 = this.stratumTable[n2].fileIndex;
        int n5 = this.stratumTable[n2 + 1].fileIndex;
        int n6 = n4;
        while (n6 < n5) {
            if (this.fileTable[n6].fileId == n3) {
                return n6;
            }
            ++n6;
        }
        return -1;
    }

    private int stiFileTableIndex(int n2, int n3) {
        return this.fileTableIndex(n2, this.lineTable[n3].fileId);
    }

    boolean isValid() {
        return this.isValid;
    }

    class LineStratum {
        private final int sti;
        private final int lti;
        private final ReferenceTypeImpl refType;
        private final int jplsLine;
        private String sourceName = null;
        private String sourcePath = null;

        private LineStratum(int n2, int n3, ReferenceTypeImpl referenceTypeImpl, int n4) {
            this.sti = n2;
            this.lti = n3;
            this.refType = referenceTypeImpl;
            this.jplsLine = n4;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof LineStratum) {
                LineStratum lineStratum = (LineStratum)object;
                return this.lti == lineStratum.lti && this.sti == lineStratum.sti && this.lineNumber() == lineStratum.lineNumber() && this.refType.equals(lineStratum.refType);
            }
            return false;
        }

        int lineNumber() {
            return SDE.this.stiLineNumber(this.sti, this.lti, this.jplsLine);
        }

        void getSourceInfo() {
            if (this.sourceName != null) {
                return;
            }
            int n2 = SDE.this.stiFileTableIndex(this.sti, this.lti);
            if (n2 == -1) {
                throw new InternalError("Bad SourceDebugExtension, no matching source id " + ((SDE)SDE.this).lineTable[this.lti].fileId + " jplsLine: " + this.jplsLine);
            }
            FileTableRecord fileTableRecord = SDE.this.fileTable[n2];
            this.sourceName = fileTableRecord.sourceName;
            this.sourcePath = fileTableRecord.getSourcePath(this.refType);
        }

        String sourceName() {
            this.getSourceInfo();
            return this.sourceName;
        }

        String sourcePath() {
            this.getSourceInfo();
            return this.sourcePath;
        }
    }

    class Stratum {
        private final int sti;

        private Stratum(int n2) {
            this.sti = n2;
        }

        String id() {
            return ((SDE)SDE.this).stratumTable[this.sti].id;
        }

        boolean isJava() {
            return this.sti == SDE.this.baseStratumIndex;
        }

        List sourceNames(ReferenceTypeImpl referenceTypeImpl) {
            int n2 = ((SDE)SDE.this).stratumTable[this.sti].fileIndex;
            int n3 = ((SDE)SDE.this).stratumTable[this.sti + 1].fileIndex;
            ArrayList<String> arrayList = new ArrayList<String>(n3 - n2);
            int n4 = n2;
            while (n4 < n3) {
                arrayList.add(((SDE)SDE.this).fileTable[n4].sourceName);
                ++n4;
            }
            return arrayList;
        }

        List sourcePaths(ReferenceTypeImpl referenceTypeImpl) {
            int n2 = ((SDE)SDE.this).stratumTable[this.sti].fileIndex;
            int n3 = ((SDE)SDE.this).stratumTable[this.sti + 1].fileIndex;
            ArrayList<String> arrayList = new ArrayList<String>(n3 - n2);
            int n4 = n2;
            while (n4 < n3) {
                arrayList.add(SDE.this.fileTable[n4].getSourcePath(referenceTypeImpl));
                ++n4;
            }
            return arrayList;
        }

        LineStratum lineStratum(ReferenceTypeImpl referenceTypeImpl, int n2) {
            int n3 = SDE.this.stiLineTableIndex(this.sti, n2);
            if (n3 < 0) {
                return null;
            }
            return new LineStratum(this.sti, n3, referenceTypeImpl, n2);
        }
    }

    private class StratumTableRecord {
        String id;
        int fileIndex;
        int lineIndex;

        private StratumTableRecord() {
        }
    }

    private class LineTableRecord {
        int jplsStart;
        int jplsEnd;
        int jplsLineInc;
        int njplsStart;
        int njplsEnd;
        int fileId;

        private LineTableRecord() {
        }
    }

    private class FileTableRecord {
        int fileId;
        String sourceName;
        String sourcePath;
        boolean isConverted = false;

        private FileTableRecord() {
        }

        String getSourcePath(ReferenceTypeImpl referenceTypeImpl) {
            if (!this.isConverted) {
                if (this.sourcePath == null) {
                    this.sourcePath = referenceTypeImpl.baseSourceDir() + this.sourceName;
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    while (n2 < this.sourcePath.length()) {
                        char c2 = this.sourcePath.charAt(n2);
                        if (c2 == '/') {
                            stringBuffer.append(File.separatorChar);
                        } else {
                            stringBuffer.append(c2);
                        }
                        ++n2;
                    }
                    this.sourcePath = stringBuffer.toString();
                }
                this.isConverted = true;
            }
            return this.sourcePath;
        }
    }
}

