/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Value;
import com.sun.tools.jdi.ArrayReferenceImpl;
import com.sun.tools.jdi.BooleanValueImpl;
import com.sun.tools.jdi.ByteValueImpl;
import com.sun.tools.jdi.CharValueImpl;
import com.sun.tools.jdi.ClassLoaderReferenceImpl;
import com.sun.tools.jdi.ClassObjectReferenceImpl;
import com.sun.tools.jdi.DoubleValueImpl;
import com.sun.tools.jdi.FloatValueImpl;
import com.sun.tools.jdi.IntegerValueImpl;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.LocationImpl;
import com.sun.tools.jdi.LongValueImpl;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.Packet;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ShortValueImpl;
import com.sun.tools.jdi.StringReferenceImpl;
import com.sun.tools.jdi.ThreadGroupReferenceImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import com.sun.tools.jdi.VoidValueImpl;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class PacketStream {
    final VirtualMachineImpl vm;
    private int inCursor = 0;
    final Packet pkt;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean isCommitted = false;

    PacketStream(VirtualMachineImpl virtualMachineImpl, int n2, int n3) {
        this.vm = virtualMachineImpl;
        this.pkt = new Packet();
        this.pkt.cmdSet = (short)n2;
        this.pkt.cmd = (short)n3;
    }

    PacketStream(VirtualMachineImpl virtualMachineImpl, Packet packet) {
        this.vm = virtualMachineImpl;
        this.pkt = packet;
        this.isCommitted = true;
    }

    int id() {
        return this.pkt.id;
    }

    void send() {
        if (!this.isCommitted) {
            this.pkt.data = this.dataStream.toByteArray();
            this.vm.sendToTarget(this.pkt);
            this.isCommitted = true;
        }
    }

    void waitForReply() throws JDWPException {
        if (!this.isCommitted) {
            throw new InternalException("waitForReply without send");
        }
        this.vm.waitForTargetReply(this.pkt);
        if (this.pkt.errorCode != 0) {
            throw new JDWPException(this.pkt.errorCode);
        }
    }

    void writeBoolean(boolean bl) {
        if (bl) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte by) {
        this.dataStream.write(by);
    }

    void writeChar(char c2) {
        this.dataStream.write((byte)(c2 >>> 8 & 0xFF));
        this.dataStream.write((byte)(c2 >>> 0 & 0xFF));
    }

    void writeShort(short s2) {
        this.dataStream.write((byte)(s2 >>> 8 & 0xFF));
        this.dataStream.write((byte)(s2 >>> 0 & 0xFF));
    }

    void writeInt(int n2) {
        this.dataStream.write((byte)(n2 >>> 24 & 0xFF));
        this.dataStream.write((byte)(n2 >>> 16 & 0xFF));
        this.dataStream.write((byte)(n2 >>> 8 & 0xFF));
        this.dataStream.write((byte)(n2 >>> 0 & 0xFF));
    }

    void writeLong(long l2) {
        this.dataStream.write((byte)(l2 >>> 56 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 48 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 40 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 32 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 24 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 16 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 8 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 0 & 0xFFL));
    }

    void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    void writeDouble(double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    void writeID(int n2, long l2) {
        if (n2 == 8) {
            this.writeLong(l2);
        } else {
            this.writeInt((int)l2);
        }
    }

    void writeNullObjectRef() {
        this.writeObjectRef(0L);
    }

    void writeObjectRef(long l2) {
        this.writeID(this.vm.sizeofObjectRef, l2);
    }

    void writeClassRef(long l2) {
        this.writeID(this.vm.sizeofClassRef, l2);
    }

    void writeMethodRef(long l2) {
        this.writeID(this.vm.sizeofMethodRef, l2);
    }

    void writeFieldRef(long l2) {
        this.writeID(this.vm.sizeofFieldRef, l2);
    }

    void writeFrameRef(long l2) {
        this.writeID(this.vm.sizeofFrameRef, l2);
    }

    void writeByteArray(byte[] byArray) {
        this.dataStream.write(byArray, 0, byArray.length);
    }

    void writeString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.writeInt(byArray.length);
            this.writeByteArray(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalException("Cannot convert string to UTF8 bytes");
        }
    }

    void writeLocation(Location location) {
        byte by;
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)location.declaringType();
        if (referenceTypeImpl instanceof ClassType) {
            by = 1;
        } else if (referenceTypeImpl instanceof InterfaceType) {
            by = 2;
        } else {
            throw new InternalException("Invalid Location");
        }
        this.writeByte(by);
        this.writeClassRef(referenceTypeImpl.ref());
        this.writeMethodRef(((MethodImpl)location.method()).ref());
        this.writeLong(location.codeIndex());
    }

    void writeValue(Value value) {
        try {
            this.writeValueChecked(value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new RuntimeException("Internal error: Invalid Tag/Type pair");
        }
    }

    void writeValueChecked(Value value) throws InvalidTypeException {
        this.writeByte(ValueImpl.typeValueKey(value));
        this.writeUntaggedValue(value);
    }

    void writeUntaggedValue(Value value) {
        try {
            this.writeUntaggedValueChecked(value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new RuntimeException("Internal error: Invalid Tag/Type pair");
        }
    }

    void writeUntaggedValueChecked(Value value) throws InvalidTypeException {
        byte by = ValueImpl.typeValueKey(value);
        if (PacketStream.isObjectTag(by)) {
            if (value == null) {
                this.writeObjectRef(0L);
            } else {
                if (!(value instanceof ObjectReference)) {
                    throw new InvalidTypeException();
                }
                this.writeObjectRef(((ObjectReferenceImpl)value).ref());
            }
        } else {
            switch (by) {
                case 66: {
                    if (!(value instanceof ByteValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeByte(((PrimitiveValue)value).byteValue());
                    break;
                }
                case 67: {
                    if (!(value instanceof CharValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeChar(((PrimitiveValue)value).charValue());
                    break;
                }
                case 70: {
                    if (!(value instanceof FloatValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeFloat(((PrimitiveValue)value).floatValue());
                    break;
                }
                case 68: {
                    if (!(value instanceof DoubleValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeDouble(((PrimitiveValue)value).doubleValue());
                    break;
                }
                case 73: {
                    if (!(value instanceof IntegerValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeInt(((PrimitiveValue)value).intValue());
                    break;
                }
                case 74: {
                    if (!(value instanceof LongValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeLong(((PrimitiveValue)value).longValue());
                    break;
                }
                case 83: {
                    if (!(value instanceof ShortValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeShort(((PrimitiveValue)value).shortValue());
                    break;
                }
                case 90: {
                    if (!(value instanceof BooleanValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeBoolean(((PrimitiveValue)value).booleanValue());
                }
            }
        }
    }

    byte readByte() {
        byte by = this.pkt.data[this.inCursor];
        ++this.inCursor;
        return by;
    }

    boolean readBoolean() {
        byte by = this.readByte();
        return by != 0;
    }

    char readChar() {
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        int n3 = this.pkt.data[this.inCursor++] & 0xFF;
        return (char)((n2 << 8) + n3);
    }

    short readShort() {
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        int n3 = this.pkt.data[this.inCursor++] & 0xFF;
        return (short)((n2 << 8) + n3);
    }

    int readInt() {
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        int n3 = this.pkt.data[this.inCursor++] & 0xFF;
        int n4 = this.pkt.data[this.inCursor++] & 0xFF;
        int n5 = this.pkt.data[this.inCursor++] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    long readLong() {
        long l2 = this.pkt.data[this.inCursor++] & 0xFF;
        long l3 = this.pkt.data[this.inCursor++] & 0xFF;
        long l4 = this.pkt.data[this.inCursor++] & 0xFF;
        long l5 = this.pkt.data[this.inCursor++] & 0xFF;
        long l6 = this.pkt.data[this.inCursor++] & 0xFF;
        long l7 = this.pkt.data[this.inCursor++] & 0xFF;
        long l8 = this.pkt.data[this.inCursor++] & 0xFF;
        long l9 = this.pkt.data[this.inCursor++] & 0xFF;
        return (l2 << 56) + (l3 << 48) + (l4 << 40) + (l5 << 32) + (l6 << 24) + (l7 << 16) + (l8 << 8) + l9;
    }

    float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    String readString() {
        String string;
        int n2 = this.readInt();
        try {
            string = new String(this.pkt.data, this.inCursor, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
            string = "Conversion error!";
        }
        this.inCursor += n2;
        return string;
    }

    private long readID(int n2) {
        if (n2 == 8) {
            return this.readLong();
        }
        return this.readInt();
    }

    long readObjectRef() {
        return this.readID(this.vm.sizeofObjectRef);
    }

    long readClassRef() {
        return this.readID(this.vm.sizeofClassRef);
    }

    ObjectReferenceImpl readTaggedObjectReference() {
        byte by = this.readByte();
        return this.vm.objectMirror(this.readObjectRef(), by);
    }

    ObjectReferenceImpl readObjectReference() {
        return this.vm.objectMirror(this.readObjectRef());
    }

    StringReferenceImpl readStringReference() {
        long l2 = this.readObjectRef();
        return this.vm.stringMirror(l2);
    }

    ArrayReferenceImpl readArrayReference() {
        long l2 = this.readObjectRef();
        return this.vm.arrayMirror(l2);
    }

    ThreadReferenceImpl readThreadReference() {
        long l2 = this.readObjectRef();
        return this.vm.threadMirror(l2);
    }

    ThreadGroupReferenceImpl readThreadGroupReference() {
        long l2 = this.readObjectRef();
        return this.vm.threadGroupMirror(l2);
    }

    ClassLoaderReferenceImpl readClassLoaderReference() {
        long l2 = this.readObjectRef();
        return this.vm.classLoaderMirror(l2);
    }

    ClassObjectReferenceImpl readClassObjectReference() {
        long l2 = this.readObjectRef();
        return this.vm.classObjectMirror(l2);
    }

    ReferenceTypeImpl readReferenceType() {
        byte by = this.readByte();
        long l2 = this.readObjectRef();
        return this.vm.referenceType(l2, by);
    }

    long readMethodRef() {
        return this.readID(this.vm.sizeofMethodRef);
    }

    long readFieldRef() {
        return this.readID(this.vm.sizeofFieldRef);
    }

    Field readField() {
        ReferenceTypeImpl referenceTypeImpl = this.readReferenceType();
        long l2 = this.readFieldRef();
        return referenceTypeImpl.getFieldMirror(l2);
    }

    long readFrameRef() {
        return this.readID(this.vm.sizeofFrameRef);
    }

    ValueImpl readValue() {
        byte by = this.readByte();
        return this.readUntaggedValue(by);
    }

    ValueImpl readUntaggedValue(byte by) {
        ValueImpl valueImpl = null;
        if (PacketStream.isObjectTag(by)) {
            valueImpl = this.vm.objectMirror(this.readObjectRef(), by);
        } else {
            switch (by) {
                case 66: {
                    valueImpl = new ByteValueImpl(this.vm, this.readByte());
                    break;
                }
                case 67: {
                    valueImpl = new CharValueImpl(this.vm, this.readChar());
                    break;
                }
                case 70: {
                    valueImpl = new FloatValueImpl(this.vm, this.readFloat());
                    break;
                }
                case 68: {
                    valueImpl = new DoubleValueImpl(this.vm, this.readDouble());
                    break;
                }
                case 73: {
                    valueImpl = new IntegerValueImpl(this.vm, this.readInt());
                    break;
                }
                case 74: {
                    valueImpl = new LongValueImpl(this.vm, this.readLong());
                    break;
                }
                case 83: {
                    valueImpl = new ShortValueImpl(this.vm, this.readShort());
                    break;
                }
                case 90: {
                    valueImpl = new BooleanValueImpl(this.vm, this.readBoolean());
                    break;
                }
                case 86: {
                    valueImpl = new VoidValueImpl(this.vm);
                }
            }
        }
        return valueImpl;
    }

    Location readLocation() {
        byte by = this.readByte();
        long l2 = this.readObjectRef();
        long l3 = this.readMethodRef();
        long l4 = this.readLong();
        if (l2 != 0L) {
            ReferenceTypeImpl referenceTypeImpl = this.vm.referenceType(l2, by);
            return new LocationImpl(this.vm, referenceTypeImpl, l3, l4);
        }
        return null;
    }

    byte[] readByteArray(int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.pkt.data, this.inCursor, byArray, 0, n2);
        this.inCursor += n2;
        return byArray;
    }

    List readArrayRegion() {
        byte by = this.readByte();
        int n2 = this.readInt();
        ArrayList<ValueImpl> arrayList = new ArrayList<ValueImpl>(n2);
        boolean bl = PacketStream.isObjectTag(by);
        int n3 = 0;
        while (n3 < n2) {
            if (bl) {
                by = this.readByte();
            }
            ValueImpl valueImpl = this.readUntaggedValue(by);
            arrayList.add(valueImpl);
            ++n3;
        }
        return arrayList;
    }

    void writeArrayRegion(List list) {
        this.writeInt(list.size());
        int n2 = 0;
        while (n2 < list.size()) {
            ValueImpl valueImpl = (ValueImpl)list.get(n2);
            this.writeUntaggedValue(valueImpl);
            ++n2;
        }
    }

    int skipBytes(int n2) {
        this.inCursor += n2;
        return n2;
    }

    byte command() {
        return (byte)this.pkt.cmd;
    }

    static boolean isObjectTag(byte by) {
        return by == 76 || by == 91 || by == 115 || by == 116 || by == 103 || by == 108 || by == 99;
    }
}

