/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.LineInfo;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.SDE;
import com.sun.tools.jdi.StratumLineInfo;

public class LocationImpl
extends MirrorImpl
implements Location {
    private final ReferenceTypeImpl declaringType;
    private Method method;
    private long methodRef;
    private long codeIndex;
    private LineInfo baseLineInfo = null;
    private LineInfo otherLineInfo = null;

    LocationImpl(VirtualMachine virtualMachine, Method method, long l2) {
        super(virtualMachine);
        this.method = method;
        this.codeIndex = method.isNative() ? -1L : l2;
        this.declaringType = (ReferenceTypeImpl)method.declaringType();
    }

    LocationImpl(VirtualMachine virtualMachine, ReferenceTypeImpl referenceTypeImpl, long l2, long l3) {
        super(virtualMachine);
        this.method = null;
        this.codeIndex = l3;
        this.declaringType = referenceTypeImpl;
        this.methodRef = l2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Location) {
            Location location = (Location)object;
            return this.method().equals(location.method()) && this.codeIndex() == location.codeIndex() && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.method().hashCode() + (int)this.codeIndex();
    }

    public int compareTo(Object object) {
        LocationImpl locationImpl = (LocationImpl)object;
        int n2 = this.method().compareTo(locationImpl.method());
        if (n2 == 0) {
            long l2 = this.codeIndex() - locationImpl.codeIndex();
            if (l2 < 0L) {
                return -1;
            }
            if (l2 > 0L) {
                return 1;
            }
            return 0;
        }
        return n2;
    }

    public ReferenceType declaringType() {
        return this.declaringType;
    }

    public Method method() {
        if (this.method == null) {
            this.method = this.declaringType.getMethodMirror(this.methodRef);
            if (this.method.isNative()) {
                this.codeIndex = -1L;
            }
        }
        return this.method;
    }

    public long codeIndex() {
        this.method();
        return this.codeIndex;
    }

    LineInfo getBaseLineInfo(SDE.Stratum stratum) {
        if (this.baseLineInfo != null) {
            return this.baseLineInfo;
        }
        MethodImpl methodImpl = (MethodImpl)this.method();
        LineInfo lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        this.addBaseLineInfo(lineInfo);
        return lineInfo;
    }

    LineInfo getLineInfo(SDE.Stratum stratum) {
        if (stratum.isJava()) {
            return this.getBaseLineInfo(stratum);
        }
        LineInfo lineInfo = this.otherLineInfo;
        if (lineInfo != null && stratum.id().equals(lineInfo.liStratum())) {
            return lineInfo;
        }
        int n2 = this.lineNumber("Java");
        SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, n2);
        if (lineStratum != null && lineStratum.lineNumber() != -1) {
            lineInfo = new StratumLineInfo(stratum.id(), lineStratum.lineNumber(), lineStratum.sourceName(), lineStratum.sourcePath());
        } else {
            MethodImpl methodImpl = (MethodImpl)this.method();
            lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        }
        this.addStratumLineInfo(lineInfo);
        return lineInfo;
    }

    void addStratumLineInfo(LineInfo lineInfo) {
        this.otherLineInfo = lineInfo;
    }

    void addBaseLineInfo(LineInfo lineInfo) {
        this.baseLineInfo = lineInfo;
    }

    public String sourceName() throws AbsentInformationException {
        return this.sourceName(this.vm.getDefaultStratum());
    }

    public String sourceName(String string) throws AbsentInformationException {
        return this.sourceName(this.declaringType.stratum(string));
    }

    String sourceName(SDE.Stratum stratum) throws AbsentInformationException {
        return this.getLineInfo(stratum).liSourceName();
    }

    public String sourcePath() throws AbsentInformationException {
        return this.sourcePath(this.vm.getDefaultStratum());
    }

    public String sourcePath(String string) throws AbsentInformationException {
        return this.sourcePath(this.declaringType.stratum(string));
    }

    String sourcePath(SDE.Stratum stratum) throws AbsentInformationException {
        return this.getLineInfo(stratum).liSourcePath();
    }

    public int lineNumber() {
        return this.lineNumber(this.vm.getDefaultStratum());
    }

    public int lineNumber(String string) {
        return this.lineNumber(this.declaringType.stratum(string));
    }

    int lineNumber(SDE.Stratum stratum) {
        return this.getLineInfo(stratum).liLineNumber();
    }

    public String toString() {
        if (this.lineNumber() == -1) {
            return this.method().toString() + "+" + this.codeIndex();
        }
        return this.declaringType().name() + ":" + this.lineNumber();
    }
}

