/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.Locatable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.jdi.EventRequestManagerImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.Packet;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EventSetImpl
extends ArrayList
implements EventSet {
    private VirtualMachineImpl vm;
    private Packet pkt;
    private byte suspendPolicy;
    private boolean needsFiltering = false;

    public String toString() {
        String string = "event set, policy:" + this.suspendPolicy + ", count:" + this.size() + " = {";
        Iterator iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            if (!bl) {
                string = string + ", ";
            }
            string = string + event.toString();
            bl = false;
        }
        string = string + "}";
        return string;
    }

    EventSetImpl(VirtualMachine virtualMachine, Packet packet) {
        this.vm = (VirtualMachineImpl)virtualMachine;
        this.pkt = packet;
    }

    EventSetImpl(VirtualMachine virtualMachine, byte by) {
        this(virtualMachine, null);
        this.suspendPolicy = 0;
        switch (by) {
            case 100: {
                super.add(new VMDisconnectEventImpl());
                break;
            }
            default: {
                throw new InternalException("Bad singleton event code");
            }
        }
    }

    EventSetImpl(EventSetImpl eventSetImpl, boolean bl) {
        this((VirtualMachine)eventSetImpl.vm, null);
        this.suspendPolicy = eventSetImpl.suspendPolicy;
        Iterator iterator = eventSetImpl.iterator();
        while (iterator.hasNext()) {
            EventImpl eventImpl = (EventImpl)iterator.next();
            if (eventImpl.internalEvent != bl) continue;
            super.add(eventImpl);
        }
    }

    synchronized void build() {
        if (this.pkt == null) {
            return;
        }
        PacketStream packetStream = new PacketStream(this.vm, this.pkt);
        JDWP.Event.Composite composite = new JDWP.Event.Composite(this.vm, packetStream);
        this.suspendPolicy = composite.suspendPolicy;
        if ((this.vm.traceFlags & 4) != 0) {
            switch (this.suspendPolicy) {
                case 2: {
                    this.vm.printTrace("EventSet: SUSPEND_ALL");
                    break;
                }
                case 1: {
                    this.vm.printTrace("EventSet: SUSPEND_EVENT_THREAD");
                    break;
                }
                case 0: {
                    this.vm.printTrace("EventSet: SUSPEND_NONE");
                }
            }
        }
        int n2 = 0;
        while (n2 < composite.events.length) {
            EventImpl eventImpl = this.createEvent(composite.events[n2]);
            if ((this.vm.traceFlags & 4) != 0) {
                this.vm.printTrace("Event: " + eventImpl);
            }
            super.add(eventImpl);
            ++n2;
        }
        this.pkt = null;
    }

    EventSet userFilter() {
        if (this.needsFiltering) {
            return new EventSetImpl(this, false);
        }
        return this;
    }

    EventSet internalFilter() {
        if (this.needsFiltering) {
            return new EventSetImpl(this, true);
        }
        return null;
    }

    EventImpl createEvent(JDWP.Event.Composite.Events events) {
        JDWP.Event.Composite.Events.EventsCommon eventsCommon = events.aEventsCommon;
        switch (events.eventKind) {
            case 6: {
                return new ThreadStartEventImpl((JDWP.Event.Composite.Events.ThreadStart)eventsCommon);
            }
            case 7: {
                return new ThreadDeathEventImpl((JDWP.Event.Composite.Events.ThreadDeath)eventsCommon);
            }
            case 4: {
                return new ExceptionEventImpl((JDWP.Event.Composite.Events.Exception)eventsCommon);
            }
            case 2: {
                return new BreakpointEventImpl((JDWP.Event.Composite.Events.Breakpoint)eventsCommon);
            }
            case 40: {
                return new MethodEntryEventImpl((JDWP.Event.Composite.Events.MethodEntry)eventsCommon);
            }
            case 41: {
                return new MethodExitEventImpl((JDWP.Event.Composite.Events.MethodExit)eventsCommon);
            }
            case 20: {
                return new AccessWatchpointEventImpl((JDWP.Event.Composite.Events.FieldAccess)eventsCommon);
            }
            case 21: {
                return new ModificationWatchpointEventImpl((JDWP.Event.Composite.Events.FieldModification)eventsCommon);
            }
            case 1: {
                return new StepEventImpl((JDWP.Event.Composite.Events.SingleStep)eventsCommon);
            }
            case 8: {
                return new ClassPrepareEventImpl((JDWP.Event.Composite.Events.ClassPrepare)eventsCommon);
            }
            case 9: {
                return new ClassUnloadEventImpl((JDWP.Event.Composite.Events.ClassUnload)eventsCommon);
            }
            case 90: {
                return new VMStartEventImpl((JDWP.Event.Composite.Events.VMStart)eventsCommon);
            }
            case 99: {
                return new VMDeathEventImpl((JDWP.Event.Composite.Events.VMDeath)eventsCommon);
            }
        }
        System.err.println("Ignoring event cmd " + events.eventKind + " from the VM");
        return null;
    }

    public VirtualMachine virtualMachine() {
        return this.vm;
    }

    public int suspendPolicy() {
        return EventRequestManagerImpl.JDWPtoJDISuspendPolicy(this.suspendPolicy);
    }

    private ThreadReference eventThread() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            if (!(event instanceof ThreadedEventImpl)) continue;
            return ((ThreadedEventImpl)event).thread();
        }
        return null;
    }

    public void resume() {
        switch (this.suspendPolicy()) {
            case 2: {
                this.vm.resume();
                break;
            }
            case 1: {
                ThreadReference threadReference = this.eventThread();
                if (threadReference == null) {
                    throw new InternalException("Inconsistent suspend policy");
                }
                threadReference.resume();
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new InternalException("Invalid suspend policy");
            }
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    public EventIterator eventIterator() {
        return new Itr();
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public class Itr
    implements EventIterator {
        int cursor = 0;

        public boolean hasNext() {
            return this.cursor != EventSetImpl.this.size();
        }

        public Object next() {
            try {
                Object e2 = EventSetImpl.this.get(this.cursor);
                ++this.cursor;
                return e2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public Event nextEvent() {
            return (Event)this.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ModificationWatchpointEventImpl
    extends WatchpointEventImpl
    implements ModificationWatchpointEvent {
        Value newValue;

        ModificationWatchpointEventImpl(JDWP.Event.Composite.Events.FieldModification fieldModification) {
            super(fieldModification, fieldModification.requestID, fieldModification.thread, fieldModification.location, fieldModification.refTypeTag, fieldModification.typeID, fieldModification.fieldID, fieldModification.object);
            this.newValue = fieldModification.valueToBe;
        }

        public Value valueToBe() {
            return this.newValue;
        }

        String eventName() {
            return "ModificationWatchpoint";
        }
    }

    class AccessWatchpointEventImpl
    extends WatchpointEventImpl
    implements AccessWatchpointEvent {
        AccessWatchpointEventImpl(JDWP.Event.Composite.Events.FieldAccess fieldAccess) {
            super(fieldAccess, fieldAccess.requestID, fieldAccess.thread, fieldAccess.location, fieldAccess.refTypeTag, fieldAccess.typeID, fieldAccess.fieldID, fieldAccess.object);
        }

        String eventName() {
            return "AccessWatchpoint";
        }
    }

    abstract class WatchpointEventImpl
    extends LocatableEventImpl
    implements WatchpointEvent {
        private final ReferenceTypeImpl refType;
        private final long fieldID;
        private final ObjectReference object;
        private Field field;

        WatchpointEventImpl(JDWP.Event.Composite.Events.EventsCommon eventsCommon, int n2, ThreadReference threadReference, Location location, byte by, long l2, long l3, ObjectReference objectReference) {
            super(eventsCommon, n2, threadReference, location);
            this.field = null;
            this.refType = this.vm.referenceType(l2, by);
            this.fieldID = l3;
            this.object = objectReference;
        }

        public Field field() {
            if (this.field == null) {
                this.field = this.refType.getFieldMirror(this.fieldID);
            }
            return this.field;
        }

        public ObjectReference object() {
            return this.object;
        }

        public Value valueCurrent() {
            if (this.object == null) {
                return this.refType.getValue(this.field());
            }
            return this.object.getValue(this.field());
        }
    }

    class VMDisconnectEventImpl
    extends EventImpl
    implements VMDisconnectEvent {
        VMDisconnectEventImpl() {
            super((byte)100);
        }

        String eventName() {
            return "VMDisconnectEvent";
        }
    }

    class VMDeathEventImpl
    extends EventImpl
    implements VMDeathEvent {
        VMDeathEventImpl(JDWP.Event.Composite.Events.VMDeath vMDeath) {
            super(vMDeath, vMDeath.requestID);
        }

        String eventName() {
            return "VMDeathEvent";
        }
    }

    class VMStartEventImpl
    extends ThreadedEventImpl
    implements VMStartEvent {
        VMStartEventImpl(JDWP.Event.Composite.Events.VMStart vMStart) {
            super(vMStart, vMStart.requestID, vMStart.thread);
        }

        String eventName() {
            return "VMStartEvent";
        }
    }

    class ThreadStartEventImpl
    extends ThreadedEventImpl
    implements ThreadStartEvent {
        ThreadStartEventImpl(JDWP.Event.Composite.Events.ThreadStart threadStart) {
            super(threadStart, threadStart.requestID, threadStart.thread);
        }

        String eventName() {
            return "ThreadStartEvent";
        }
    }

    class ThreadDeathEventImpl
    extends ThreadedEventImpl
    implements ThreadDeathEvent {
        ThreadDeathEventImpl(JDWP.Event.Composite.Events.ThreadDeath threadDeath) {
            super(threadDeath, threadDeath.requestID, threadDeath.thread);
        }

        String eventName() {
            return "ThreadDeathEvent";
        }
    }

    class ExceptionEventImpl
    extends LocatableEventImpl
    implements ExceptionEvent {
        private ObjectReference exception;
        private Location catchLocation;

        ExceptionEventImpl(JDWP.Event.Composite.Events.Exception exception) {
            super(exception, exception.requestID, exception.thread, exception.location);
            this.exception = exception.exception;
            this.catchLocation = exception.catchLocation;
        }

        public ObjectReference exception() {
            return this.exception;
        }

        public Location catchLocation() {
            return this.catchLocation;
        }

        String eventName() {
            return "ExceptionEvent";
        }
    }

    class ClassUnloadEventImpl
    extends EventImpl
    implements ClassUnloadEvent {
        private String classSignature;

        ClassUnloadEventImpl(JDWP.Event.Composite.Events.ClassUnload classUnload) {
            super(classUnload, classUnload.requestID);
            this.classSignature = classUnload.signature;
        }

        public String className() {
            return this.classSignature.substring(1, this.classSignature.length() - 1).replace('/', '.');
        }

        public String classSignature() {
            return this.classSignature;
        }

        String eventName() {
            return "ClassUnloadEvent";
        }
    }

    class ClassPrepareEventImpl
    extends ThreadedEventImpl
    implements ClassPrepareEvent {
        private ReferenceType referenceType;

        ClassPrepareEventImpl(JDWP.Event.Composite.Events.ClassPrepare classPrepare) {
            super(classPrepare, classPrepare.requestID, classPrepare.thread);
            this.referenceType = this.vm.referenceType(classPrepare.typeID, classPrepare.refTypeTag, classPrepare.signature);
            ((ReferenceTypeImpl)this.referenceType).setStatus(classPrepare.status);
        }

        public ReferenceType referenceType() {
            return this.referenceType;
        }

        String eventName() {
            return "ClassPrepareEvent";
        }
    }

    class MethodExitEventImpl
    extends LocatableEventImpl
    implements MethodExitEvent {
        MethodExitEventImpl(JDWP.Event.Composite.Events.MethodExit methodExit) {
            super(methodExit, methodExit.requestID, methodExit.thread, methodExit.location);
        }

        String eventName() {
            return "MethodExitEvent";
        }
    }

    class MethodEntryEventImpl
    extends LocatableEventImpl
    implements MethodEntryEvent {
        MethodEntryEventImpl(JDWP.Event.Composite.Events.MethodEntry methodEntry) {
            super(methodEntry, methodEntry.requestID, methodEntry.thread, methodEntry.location);
        }

        String eventName() {
            return "MethodEntryEvent";
        }
    }

    class StepEventImpl
    extends LocatableEventImpl
    implements StepEvent {
        StepEventImpl(JDWP.Event.Composite.Events.SingleStep singleStep) {
            super(singleStep, singleStep.requestID, singleStep.thread, singleStep.location);
        }

        String eventName() {
            return "StepEvent";
        }
    }

    class BreakpointEventImpl
    extends LocatableEventImpl
    implements BreakpointEvent {
        BreakpointEventImpl(JDWP.Event.Composite.Events.Breakpoint breakpoint) {
            super(breakpoint, breakpoint.requestID, breakpoint.thread, breakpoint.location);
        }

        String eventName() {
            return "BreakpointEvent";
        }
    }

    abstract class LocatableEventImpl
    extends ThreadedEventImpl
    implements Locatable {
        private Location location;

        LocatableEventImpl(JDWP.Event.Composite.Events.EventsCommon eventsCommon, int n2, ThreadReference threadReference, Location location) {
            super(eventsCommon, n2, threadReference);
            this.location = location;
        }

        public Location location() {
            return this.location;
        }

        public Method method() {
            return this.location.method();
        }

        public String toString() {
            return this.eventName() + "@" + this.location().toString() + " in thread " + this.thread().name();
        }
    }

    abstract class ThreadedEventImpl
    extends EventImpl {
        private ThreadReference thread;

        ThreadedEventImpl(JDWP.Event.Composite.Events.EventsCommon eventsCommon, int n2, ThreadReference threadReference) {
            super(eventsCommon, n2);
            this.thread = threadReference;
        }

        public ThreadReference thread() {
            return this.thread;
        }

        public String toString() {
            return this.eventName() + " in thread " + this.thread.name();
        }
    }

    abstract class EventImpl
    extends MirrorImpl
    implements Event {
        private byte eventCmd;
        private EventRequest request;
        private boolean internalEvent;

        protected EventImpl(JDWP.Event.Composite.Events.EventsCommon eventsCommon, int n2) {
            super(EventSetImpl.this.vm);
            this.internalEvent = false;
            this.eventCmd = eventsCommon.eventKind();
            this.request = this.requestFromRequestId(n2);
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        protected EventImpl(byte by) {
            super(EventSetImpl.this.vm);
            this.internalEvent = false;
            this.eventCmd = by;
            this.request = null;
        }

        public EventRequest request() {
            return this.request;
        }

        private EventRequest requestFromRequestId(int n2) {
            if (n2 == 0) {
                return null;
            }
            EventRequestManagerImpl eventRequestManagerImpl = this.vm.eventRequestManagerImpl();
            EventRequest eventRequest = eventRequestManagerImpl.request(this.eventCmd, n2);
            if (eventRequest == null) {
                this.internalEvent = true;
                EventSetImpl.this.needsFiltering = true;
            }
            return eventRequest;
        }

        abstract String eventName();

        public String toString() {
            return this.eventName();
        }
    }
}

