/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.VMDeathRequest;
import com.sun.jdi.request.WatchpointRequest;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.FieldImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class EventRequestManagerImpl
extends MirrorImpl
implements EventRequestManager {
    List[] requestLists;
    static /* synthetic */ Class class$com$sun$tools$jdi$JDWP$EventKind;

    static int JDWPtoJDISuspendPolicy(byte by) {
        switch (by) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal policy constant: " + by);
    }

    static byte JDItoJDWPSuspendPolicy(int n2) {
        switch (n2) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal policy constant: " + n2);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    EventRequestManagerImpl(VirtualMachine virtualMachine) {
        super(virtualMachine);
        int n2;
        Field[] fieldArray = (class$com$sun$tools$jdi$JDWP$EventKind == null ? (class$com$sun$tools$jdi$JDWP$EventKind = EventRequestManagerImpl.class$("com.sun.tools.jdi.JDWP$EventKind")) : class$com$sun$tools$jdi$JDWP$EventKind).getDeclaredFields();
        int n3 = 0;
        int n4 = 0;
        while (n4 < fieldArray.length) {
            try {
                n2 = fieldArray[n4].getInt(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Got: " + illegalAccessException);
            }
            if (n2 > n3) {
                n3 = n2;
            }
            ++n4;
        }
        this.requestLists = new List[n3 + 1];
        n2 = 0;
        while (n2 <= n3) {
            this.requestLists[n2] = new ArrayList();
            ++n2;
        }
    }

    public ClassPrepareRequest createClassPrepareRequest() {
        return new ClassPrepareRequestImpl();
    }

    public ClassUnloadRequest createClassUnloadRequest() {
        return new ClassUnloadRequestImpl();
    }

    public ExceptionRequest createExceptionRequest(ReferenceType referenceType, boolean bl, boolean bl2) {
        this.validateMirrorOrNull(referenceType);
        return new ExceptionRequestImpl(referenceType, bl, bl2);
    }

    public StepRequest createStepRequest(ThreadReference threadReference, int n2, int n3) {
        this.validateMirror(threadReference);
        return new StepRequestImpl(threadReference, n2, n3);
    }

    public ThreadDeathRequest createThreadDeathRequest() {
        return new ThreadDeathRequestImpl();
    }

    public ThreadStartRequest createThreadStartRequest() {
        return new ThreadStartRequestImpl();
    }

    public MethodEntryRequest createMethodEntryRequest() {
        return new MethodEntryRequestImpl();
    }

    public MethodExitRequest createMethodExitRequest() {
        return new MethodExitRequestImpl();
    }

    public BreakpointRequest createBreakpointRequest(Location location) {
        this.validateMirror(location);
        if (location.codeIndex() == -1L) {
            throw new NativeMethodException("Cannot set breakpoints on native methods");
        }
        return new BreakpointRequestImpl(location);
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(com.sun.jdi.Field field) {
        this.validateMirror(field);
        if (!this.vm.canWatchFieldAccess()) {
            throw new UnsupportedOperationException("target VM does not support access watchpoints");
        }
        return new AccessWatchpointRequestImpl(field);
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(com.sun.jdi.Field field) {
        this.validateMirror(field);
        if (!this.vm.canWatchFieldModification()) {
            throw new UnsupportedOperationException("target VM does not support modification watchpoints");
        }
        return new ModificationWatchpointRequestImpl(field);
    }

    public VMDeathRequest createVMDeathRequest() {
        if (!this.vm.canRequestVMDeathEvent()) {
            throw new UnsupportedOperationException("target VM does not support requesting VM death events");
        }
        return new VMDeathRequestImpl();
    }

    public void deleteEventRequest(EventRequest eventRequest) {
        this.validateMirror(eventRequest);
        ((EventRequestImpl)eventRequest).delete();
    }

    public void deleteEventRequests(List list) {
        this.validateMirrors(list);
        Iterator iterator = new ArrayList(list).iterator();
        while (iterator.hasNext()) {
            ((EventRequestImpl)iterator.next()).delete();
        }
    }

    public void deleteAllBreakpoints() {
        this.requestList(2).clear();
        try {
            JDWP.EventRequest.ClearAllBreakpoints.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public List stepRequests() {
        return this.unmodifiableRequestList(1);
    }

    public List classPrepareRequests() {
        return this.unmodifiableRequestList(8);
    }

    public List classUnloadRequests() {
        return this.unmodifiableRequestList(9);
    }

    public List threadStartRequests() {
        return this.unmodifiableRequestList(6);
    }

    public List threadDeathRequests() {
        return this.unmodifiableRequestList(7);
    }

    public List exceptionRequests() {
        return this.unmodifiableRequestList(4);
    }

    public List breakpointRequests() {
        return this.unmodifiableRequestList(2);
    }

    public List accessWatchpointRequests() {
        return this.unmodifiableRequestList(20);
    }

    public List modificationWatchpointRequests() {
        return this.unmodifiableRequestList(21);
    }

    public List methodEntryRequests() {
        return this.unmodifiableRequestList(40);
    }

    public List methodExitRequests() {
        return this.unmodifiableRequestList(41);
    }

    public List vmDeathRequests() {
        return this.unmodifiableRequestList(99);
    }

    List unmodifiableRequestList(int n2) {
        return Collections.unmodifiableList(this.requestList(n2));
    }

    EventRequest request(int n2, int n3) {
        List list = this.requestList(n2);
        int n4 = list.size() - 1;
        while (n4 >= 0) {
            EventRequestImpl eventRequestImpl = (EventRequestImpl)list.get(n4);
            if (eventRequestImpl.id == n3) {
                return eventRequestImpl;
            }
            --n4;
        }
        return null;
    }

    List requestList(int n2) {
        return this.requestLists[n2];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class VMDeathRequestImpl
    extends EventRequestImpl
    implements VMDeathRequest {
        VMDeathRequestImpl() {
        }

        int eventCmd() {
            return 99;
        }

        public String toString() {
            return "VM death request " + this.state();
        }
    }

    class ModificationWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements ModificationWatchpointRequest {
        ModificationWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
        }

        int eventCmd() {
            return 21;
        }

        public String toString() {
            return "modification watchpoint request " + this.field + this.state();
        }
    }

    class AccessWatchpointRequestImpl
    extends WatchpointRequestImpl
    implements AccessWatchpointRequest {
        AccessWatchpointRequestImpl(com.sun.jdi.Field field) {
            super(field);
        }

        int eventCmd() {
            return 20;
        }

        public String toString() {
            return "access watchpoint request " + this.field + this.state();
        }
    }

    abstract class WatchpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements WatchpointRequest {
        final com.sun.jdi.Field field;

        WatchpointRequestImpl(com.sun.jdi.Field field) {
            this.field = field;
            this.filters.add(0, JDWP.EventRequest.Set.Modifier.FieldOnly.create((ReferenceTypeImpl)field.declaringType(), ((FieldImpl)field).ref()));
        }

        public com.sun.jdi.Field field() {
            return this.field;
        }
    }

    class ThreadStartRequestImpl
    extends ThreadVisibleEventRequestImpl
    implements ThreadStartRequest {
        ThreadStartRequestImpl() {
        }

        int eventCmd() {
            return 6;
        }

        public String toString() {
            return "thread start request " + this.state();
        }
    }

    class ThreadDeathRequestImpl
    extends ThreadVisibleEventRequestImpl
    implements ThreadDeathRequest {
        ThreadDeathRequestImpl() {
        }

        int eventCmd() {
            return 7;
        }

        public String toString() {
            return "thread death request " + this.state();
        }
    }

    class StepRequestImpl
    extends ClassVisibleEventRequestImpl
    implements StepRequest {
        ThreadReferenceImpl thread;
        int size;
        int depth;

        StepRequestImpl(ThreadReference threadReference, int n2, int n3) {
            int n4;
            int n5;
            this.thread = (ThreadReferenceImpl)threadReference;
            this.size = n2;
            this.depth = n3;
            switch (n2) {
                case -1: {
                    n5 = 0;
                    break;
                }
                case -2: {
                    n5 = 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid step size");
                }
            }
            switch (n3) {
                case 1: {
                    n4 = 0;
                    break;
                }
                case 2: {
                    n4 = 1;
                    break;
                }
                case 3: {
                    n4 = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid step depth");
                }
            }
            List list = EventRequestManagerImpl.this.stepRequests();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StepRequest stepRequest = (StepRequest)iterator.next();
                if (stepRequest == this || !stepRequest.isEnabled() || !stepRequest.thread().equals(threadReference)) continue;
                throw new DuplicateRequestException("Only one step request allowed per thread");
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.Step.create(this.thread, n5, n4));
        }

        public int depth() {
            return this.depth;
        }

        public int size() {
            return this.size;
        }

        public ThreadReference thread() {
            return this.thread;
        }

        int eventCmd() {
            return 1;
        }

        public String toString() {
            return "step request " + this.thread() + this.state();
        }
    }

    class MethodExitRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodExitRequest {
        MethodExitRequestImpl() {
        }

        int eventCmd() {
            return 41;
        }

        public String toString() {
            return "method exit request " + this.state();
        }
    }

    class MethodEntryRequestImpl
    extends ClassVisibleEventRequestImpl
    implements MethodEntryRequest {
        MethodEntryRequestImpl() {
        }

        int eventCmd() {
            return 40;
        }

        public String toString() {
            return "method entry request " + this.state();
        }
    }

    class ExceptionRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ExceptionRequest {
        ReferenceType exception;
        boolean caught;
        boolean uncaught;

        ExceptionRequestImpl(ReferenceType referenceType, boolean bl, boolean bl2) {
            this.exception = null;
            this.caught = true;
            this.uncaught = true;
            this.exception = referenceType;
            this.caught = bl;
            this.uncaught = bl2;
            ReferenceTypeImpl referenceTypeImpl = this.exception == null ? new ClassTypeImpl(this.vm, 0L) : (ReferenceTypeImpl)this.exception;
            this.filters.add(JDWP.EventRequest.Set.Modifier.ExceptionOnly.create(referenceTypeImpl, this.caught, this.uncaught));
        }

        public ReferenceType exception() {
            return this.exception;
        }

        public boolean notifyCaught() {
            return this.caught;
        }

        public boolean notifyUncaught() {
            return this.uncaught;
        }

        int eventCmd() {
            return 4;
        }

        public String toString() {
            return "exception request " + this.exception() + this.state();
        }
    }

    class ClassUnloadRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassUnloadRequest {
        ClassUnloadRequestImpl() {
        }

        int eventCmd() {
            return 9;
        }

        public String toString() {
            return "class unload request " + this.state();
        }
    }

    class ClassPrepareRequestImpl
    extends ClassVisibleEventRequestImpl
    implements ClassPrepareRequest {
        ClassPrepareRequestImpl() {
        }

        int eventCmd() {
            return 8;
        }

        public String toString() {
            return "class prepare request " + this.state();
        }
    }

    class BreakpointRequestImpl
    extends ClassVisibleEventRequestImpl
    implements BreakpointRequest {
        private final Location location;

        BreakpointRequestImpl(Location location) {
            this.location = location;
            this.filters.add(0, JDWP.EventRequest.Set.Modifier.LocationOnly.create(location));
        }

        public Location location() {
            return this.location;
        }

        int eventCmd() {
            return 2;
        }

        public String toString() {
            return "breakpoint request " + this.location() + this.state();
        }
    }

    abstract class ClassVisibleEventRequestImpl
    extends ThreadVisibleEventRequestImpl {
        ClassVisibleEventRequestImpl() {
        }

        public synchronized void addClassFilter(ReferenceType referenceType) {
            this.validateMirror(referenceType);
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassOnly.create((ReferenceTypeImpl)referenceType));
        }

        public synchronized void addClassFilter(String string) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (string == null) {
                throw new NullPointerException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassMatch.create(string));
        }

        public synchronized void addClassExclusionFilter(String string) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (string == null) {
                throw new NullPointerException();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ClassExclude.create(string));
        }

        public synchronized void addInstanceFilter(ObjectReference objectReference) {
            this.validateMirror(objectReference);
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (!this.vm.canUseInstanceFilters()) {
                throw new UnsupportedOperationException("target does not support instance filters");
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.InstanceOnly.create((ObjectReferenceImpl)objectReference));
        }
    }

    abstract class ThreadVisibleEventRequestImpl
    extends EventRequestImpl {
        ThreadVisibleEventRequestImpl() {
        }

        public synchronized void addThreadFilter(ThreadReference threadReference) {
            this.validateMirror(threadReference);
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.ThreadOnly.create((ThreadReferenceImpl)threadReference));
        }
    }

    abstract class EventRequestImpl
    extends MirrorImpl
    implements EventRequest {
        int id;
        List filters;
        boolean isEnabled;
        boolean deleted;
        byte suspendPolicy;
        private Map clientProperties;

        EventRequestImpl() {
            super(EventRequestManagerImpl.this.vm);
            this.filters = new ArrayList();
            this.isEnabled = false;
            this.deleted = false;
            this.suspendPolicy = (byte)2;
            this.clientProperties = null;
            this.requestList().add(this);
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        abstract int eventCmd();

        InvalidRequestStateException invalidState() {
            return new InvalidRequestStateException(this.toString());
        }

        String state() {
            return this.deleted ? " (deleted)" : (this.isEnabled() ? " (enabled)" : " (disabled)");
        }

        List requestList() {
            return EventRequestManagerImpl.this.requestList(this.eventCmd());
        }

        void delete() {
            if (!this.deleted) {
                this.requestList().remove(this);
                this.disable();
                this.deleted = true;
            }
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void enable() {
            this.setEnabled(true);
        }

        public void disable() {
            this.setEnabled(false);
        }

        public synchronized void setEnabled(boolean bl) {
            if (this.deleted) {
                throw this.invalidState();
            }
            if (bl != this.isEnabled) {
                if (this.isEnabled) {
                    this.clear();
                } else {
                    this.set();
                }
            }
        }

        public synchronized void addCountFilter(int n2) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            if (n2 < 1) {
                throw new IllegalArgumentException("count is less than one");
            }
            this.filters.add(JDWP.EventRequest.Set.Modifier.Count.create(n2));
        }

        public void setSuspendPolicy(int n2) {
            if (this.isEnabled() || this.deleted) {
                throw this.invalidState();
            }
            this.suspendPolicy = EventRequestManagerImpl.JDItoJDWPSuspendPolicy(n2);
        }

        public int suspendPolicy() {
            return EventRequestManagerImpl.JDWPtoJDISuspendPolicy(this.suspendPolicy);
        }

        synchronized void set() {
            JDWP.EventRequest.Set.Modifier[] modifierArray = this.filters.toArray(new JDWP.EventRequest.Set.Modifier[this.filters.size()]);
            try {
                this.id = JDWP.EventRequest.Set.process((VirtualMachineImpl)this.vm, (byte)((byte)this.eventCmd()), (byte)this.suspendPolicy, (JDWP.EventRequest.Set.Modifier[])modifierArray).requestID;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            this.isEnabled = true;
        }

        synchronized void clear() {
            try {
                JDWP.EventRequest.Clear.process(this.vm, (byte)this.eventCmd(), this.id);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
            this.isEnabled = false;
        }

        private Map getProperties() {
            if (this.clientProperties == null) {
                this.clientProperties = new HashMap(2);
            }
            return this.clientProperties;
        }

        public final Object getProperty(Object object) {
            if (this.clientProperties == null) {
                return null;
            }
            return this.getProperties().get(object);
        }

        public final void putProperty(Object object, Object object2) {
            if (object2 != null) {
                this.getProperties().put(object, object2);
            } else {
                this.getProperties().remove(object);
            }
        }
    }
}

