/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ClassLoaderReferenceImpl
extends ObjectReferenceImpl
implements ClassLoaderReference,
VMListener {
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ClassLoaderReferenceImpl(VirtualMachine virtualMachine, long l2) {
        super(virtualMachine, l2);
        this.vm.state().addListener(this);
    }

    protected String description() {
        return "ClassLoaderReference " + this.uniqueID();
    }

    public List definedClasses() {
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        Iterator iterator = this.vm.allClasses().iterator();
        while (iterator.hasNext()) {
            ReferenceType referenceType = (ReferenceType)iterator.next();
            if (!this.equals(referenceType.classLoader())) continue;
            arrayList.add(referenceType);
        }
        return arrayList;
    }

    public List visibleClasses() {
        List list = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                list = cache.visibleClasses;
            }
            if (list == null) {
                JDWP.ClassLoaderReference.VisibleClasses.ClassInfo[] classInfoArray = JDWP.ClassLoaderReference.VisibleClasses.process((VirtualMachineImpl)this.vm, (ClassLoaderReferenceImpl)this).classes;
                list = new ArrayList<ReferenceTypeImpl>(classInfoArray.length);
                int n2 = 0;
                while (n2 < classInfoArray.length) {
                    list.add(this.vm.referenceType(classInfoArray[n2].typeID, classInfoArray[n2].refTypeTag));
                    ++n2;
                }
                list = Collections.unmodifiableList(list);
                if (cache != null) {
                    cache.visibleClasses = list;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching visible classes (count = " + list.size() + ")");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    Type findType(String string) throws ClassNotLoadedException {
        Object object;
        List list = this.visibleClasses();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ReferenceType)iterator.next();
            if (!object.signature().equals(string)) continue;
            return object;
        }
        object = new JNITypeParser(string);
        throw new ClassNotLoadedException(((JNITypeParser)object).typeName(), "Class " + ((JNITypeParser)object).typeName() + " not loaded");
    }

    byte typeValueKey() {
        return 108;
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        List visibleClasses = null;

        private Cache() {
        }
    }
}

