/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayTypeImpl
extends ReferenceTypeImpl
implements ArrayType {
    protected ArrayTypeImpl(VirtualMachine virtualMachine, long l2) {
        super(virtualMachine, l2);
    }

    public ArrayReference newInstance(int n2) {
        try {
            return (ArrayReference)((Object)JDWP.ArrayType.NewInstance.process((VirtualMachineImpl)this.vm, (ArrayTypeImpl)this, (int)n2).newArray);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public String componentSignature() {
        return this.signature().substring(1);
    }

    public String componentTypeName() {
        JNITypeParser jNITypeParser = new JNITypeParser(this.componentSignature());
        return jNITypeParser.typeName();
    }

    Type type() throws ClassNotLoadedException {
        return this.findType(this.componentSignature());
    }

    void addVisibleMethods(Map map) {
    }

    public List allMethods() {
        return new ArrayList(0);
    }

    Type findComponentType(String string) throws ClassNotLoadedException {
        byte by = (byte)string.charAt(0);
        if (PacketStream.isObjectTag(by)) {
            JNITypeParser jNITypeParser = new JNITypeParser(this.componentSignature());
            List list = this.vm.classesByName(jNITypeParser.typeName());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)iterator.next();
                ClassLoaderReference classLoaderReference = referenceType.classLoader();
                if (!(classLoaderReference == null ? this.classLoader() == null : classLoaderReference.equals(this.classLoader()))) continue;
                return referenceType;
            }
            throw new ClassNotLoadedException(this.componentTypeName());
        }
        return this.vm.primitiveTypeMirror(by);
    }

    public Type componentType() throws ClassNotLoadedException {
        return this.findComponentType(this.componentSignature());
    }

    static boolean isComponentAssignable(Type type, Type type2) {
        if (type2 instanceof PrimitiveType) {
            return type2.equals(type);
        }
        if (type instanceof PrimitiveType) {
            return false;
        }
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)type2;
        ReferenceTypeImpl referenceTypeImpl2 = (ReferenceTypeImpl)type;
        return referenceTypeImpl.isAssignableTo(referenceTypeImpl2);
    }

    boolean isAssignableTo(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            try {
                Type type = ((ArrayType)referenceType).componentType();
                return ArrayTypeImpl.isComponentAssignable(type, this.componentType());
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                return false;
            }
        }
        if (referenceType instanceof InterfaceType) {
            return referenceType.name().equals("java.lang.Cloneable");
        }
        return referenceType.name().equals("java.lang.Object");
    }

    List inheritedTypes() {
        return new ArrayList(0);
    }

    void getModifiers() {
        block4: {
            if (this.modifiers != -1) {
                return;
            }
            try {
                Type type = this.componentType();
                if (type instanceof PrimitiveType) {
                    this.modifiers = 17;
                    break block4;
                }
                ReferenceType referenceType = (ReferenceType)type;
                this.modifiers = referenceType.modifiers();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                classNotLoadedException.printStackTrace();
            }
        }
    }

    public String toString() {
        return "array class " + this.name() + " (" + this.loaderString() + ")";
    }

    public boolean isPrepared() {
        return true;
    }

    public boolean isVerified() {
        return true;
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean failedToInitialize() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isFinal() {
        return true;
    }
}

