/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    int length = -1;

    ArrayReferenceImpl(VirtualMachine virtualMachine, long l2) {
        super(virtualMachine, l2);
    }

    protected ClassTypeImpl invokableReferenceType(Method method) {
        return (ClassTypeImpl)method.declaringType();
    }

    ArrayTypeImpl arrayType() {
        return (ArrayTypeImpl)this.type();
    }

    public int length() {
        if (this.length == -1) {
            try {
                this.length = JDWP.ArrayReference.Length.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this).arrayLength;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.length;
    }

    public Value getValue(int n2) {
        List list = this.getValues(n2, 1);
        return (Value)list.get(0);
    }

    public List getValues() {
        return this.getValues(0, -1);
    }

    private void validateArrayAccess(int n2, int n3) {
        if (n2 < 0 || n2 > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array index: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("Invalid array range length: " + n3);
        }
        if (n2 + n3 > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array range: " + n2 + " to " + (n2 + n3 - 1));
        }
    }

    public List getValues(int n2, int n3) {
        List list;
        if (n3 == -1) {
            n3 = this.length() - n2;
        }
        this.validateArrayAccess(n2, n3);
        if (n3 == 0) {
            return new ArrayList();
        }
        try {
            list = JDWP.ArrayReference.GetValues.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this, (int)n2, (int)n3).values;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    public void setValue(int n2, Value value) throws InvalidTypeException, ClassNotLoadedException {
        ArrayList<Value> arrayList = new ArrayList<Value>(1);
        arrayList.add(value);
        this.setValues(n2, arrayList, 0, 1);
    }

    public void setValues(List list) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(0, list, 0, -1);
    }

    public void setValues(int n2, List list, int n3, int n4) throws InvalidTypeException, ClassNotLoadedException {
        if (n4 == -1) {
            n4 = Math.min(this.length() - n2, list.size() - n3);
        }
        this.validateMirrorsOrNulls(list);
        this.validateArrayAccess(n2, n4);
        if (n3 < 0 || n3 > list.size()) {
            throw new IndexOutOfBoundsException("Invalid source index: " + n3);
        }
        if (n3 + n4 > list.size()) {
            throw new IndexOutOfBoundsException("Invalid source range: " + n3 + " to " + (n3 + n4 - 1));
        }
        boolean bl = false;
        ValueImpl[] valueImplArray = new ValueImpl[n4];
        int n5 = 0;
        while (n5 < n4) {
            block9: {
                ValueImpl valueImpl = (ValueImpl)list.get(n3 + n5);
                try {
                    valueImplArray[n5] = ValueImpl.prepareForAssignment(valueImpl, new Component());
                    bl = true;
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    if (valueImpl == null) break block9;
                    throw classNotLoadedException;
                }
            }
            ++n5;
        }
        if (bl) {
            try {
                JDWP.ArrayReference.SetValues.process(this.vm, this, n2, valueImplArray);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
    }

    public String toString() {
        return "instance of " + this.arrayType().componentTypeName() + "[" + this.length() + "] (id=" + this.uniqueID() + ")";
    }

    byte typeValueKey() {
        return 91;
    }

    void validateAssignment(ValueContainer valueContainer) throws InvalidTypeException, ClassNotLoadedException {
        block3: {
            try {
                super.validateAssignment(valueContainer);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                boolean bl = false;
                JNITypeParser jNITypeParser = new JNITypeParser(valueContainer.signature());
                JNITypeParser jNITypeParser2 = new JNITypeParser(this.arrayType().signature());
                int n2 = jNITypeParser.dimensionCount();
                if (n2 <= jNITypeParser2.dimensionCount()) {
                    String string = jNITypeParser.componentSignature(n2);
                    Type type = valueContainer.findType(string);
                    String string2 = jNITypeParser2.componentSignature(n2);
                    Type type2 = this.arrayType().findComponentType(string2);
                    bl = ArrayTypeImpl.isComponentAssignable(type, type2);
                }
                if (bl) break block3;
                throw new InvalidTypeException("Cannot assign " + this.arrayType().name() + " to " + valueContainer.typeName());
            }
        }
    }

    class Component
    implements ValueContainer {
        Component() {
        }

        public Type type() throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().componentType();
        }

        public String typeName() {
            return ArrayReferenceImpl.this.arrayType().componentTypeName();
        }

        public String signature() {
            return ArrayReferenceImpl.this.arrayType().componentSignature();
        }

        public Type findType(String string) throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().findComponentType(string);
        }
    }
}

