/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.Gen;
import com.sun.tools.javah.Util;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import sun.tools.java.ArrayType;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.MethodType;
import sun.tools.java.Type;
import sun.tools.tree.DoubleExpression;
import sun.tools.tree.Expression;
import sun.tools.tree.FloatExpression;
import sun.tools.tree.IntExpression;
import sun.tools.tree.LongExpression;

public class LLNI
extends Gen {
    protected final char pathChar = File.separatorChar;
    protected final char innerDelim = (char)36;
    protected Hashtable doneHandleTypes;
    MemberDefinition[] fields;
    private boolean doubleAlign;
    private int padFieldNum = 0;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    LLNI(boolean bl) {
        this.doubleAlign = bl;
    }

    protected String getIncludes() {
        return "";
    }

    protected void write(OutputStream outputStream, String string) throws ClassNotFoundException {
        String string2 = this.mangleClassName(string);
        PrintWriter printWriter = this.wrapWriter(outputStream);
        this.fields = this.env.getLocalFieldsAndMethods(string);
        this.generateDeclsForClass(printWriter, string, string2);
    }

    protected void generateDeclsForClass(PrintWriter printWriter, String string, String string2) throws ClassNotFoundException {
        this.doneHandleTypes = new Hashtable();
        this.genHandleType(null, "java.lang.Class");
        this.genHandleType(null, "java.lang.ClassLoader");
        this.genHandleType(null, "java.lang.Object");
        this.genHandleType(null, "java.lang.String");
        this.genHandleType(null, "java.lang.Thread");
        this.genHandleType(null, "java.lang.ThreadGroup");
        this.genHandleType(null, "java.lang.Throwable");
        printWriter.println("/* LLNI Header for class " + string + " */\n");
        printWriter.println("#ifndef _Included_" + string2);
        printWriter.println("#define _Included_" + string2);
        printWriter.println("#include \"typedefs.h\"");
        printWriter.println("#include \"llni.h\"");
        printWriter.println("#include \"jni.h\"\n");
        this.forwardDecls(printWriter, string);
        this.structSectionForClass(printWriter, string, string2);
        this.methodSectionForClass(printWriter, string, string2);
        printWriter.println("#endif");
    }

    protected void genHandleType(PrintWriter printWriter, String string) {
        String string2 = this.mangleClassName(string);
        if (!this.doneHandleTypes.containsKey(string2)) {
            this.doneHandleTypes.put(string2, string2);
            if (printWriter != null) {
                printWriter.println("#ifndef DEFINED_" + string2);
                printWriter.println("    #define DEFINED_" + string2);
                printWriter.println("    GEN_HANDLE_TYPES(" + string2 + ");");
                printWriter.println("#endif\n");
            }
        }
    }

    protected String mangleClassName(String string) {
        return string.replace('.', '_').replace(this.pathChar, '_').replace('$', '_');
    }

    protected void forwardDecls(PrintWriter printWriter, String string) throws ClassNotFoundException {
        if (string.equals("java.lang.Object")) {
            return;
        }
        this.genHandleType(printWriter, string);
        String string2 = this.env.getSuperClassName(string);
        this.forwardDecls(printWriter, string2);
        int n2 = 0;
        while (n2 < this.fields.length) {
            String string3;
            MemberDefinition memberDefinition = this.fields[n2];
            if ((!memberDefinition.isStatic() && memberDefinition.isVariable() || memberDefinition.isNative()) && (string3 = memberDefinition.getType().getTypeSignature()).charAt(0) != '[') {
                this.forwardDeclsFromSig(printWriter, string3);
            }
            ++n2;
        }
    }

    protected void forwardDeclsFromSig(PrintWriter printWriter, String string) {
        int n2 = string.length();
        int n3 = string.charAt(0) == '(' ? 1 : 0;
        while (n3 < n2) {
            if (string.charAt(n3) == 'L') {
                int n4 = n3 + 1;
                while (string.charAt(n4) != ';') {
                    ++n4;
                }
                this.genHandleType(printWriter, string.substring(n3 + 1, n4));
                n3 = n4 + 1;
                continue;
            }
            ++n3;
        }
    }

    protected void structSectionForClass(PrintWriter printWriter, String string, String string2) throws ClassNotFoundException {
        if (string2.equals("java_lang_Object")) {
            printWriter.println("/* struct java_lang_Object is defined in typedefs.h. */");
            printWriter.println();
            return;
        }
        printWriter.println("#if !defined(__i386)");
        printWriter.println("#pragma pack(4)");
        printWriter.println("#endif");
        printWriter.println();
        printWriter.println("struct " + string2 + " {");
        printWriter.println("    ObjHeader h;");
        printWriter.print(this.fieldDefs(string, string2));
        if (string.equals("java.lang.Class")) {
            printWriter.println("    Class *LLNI_mask(cClass);  /* Fake field; don't access (see oobj.h) */");
        }
        printWriter.println("};\n\n#pragma pack()");
        printWriter.println();
    }

    private boolean doField(FieldDefsRes fieldDefsRes, MemberDefinition memberDefinition, String string, boolean bl) throws ClassNotFoundException {
        String string2;
        if (memberDefinition.isVariable() && (string2 = this.addStructMember(memberDefinition, string, bl)) != null) {
            if (!fieldDefsRes.printedOne) {
                if (fieldDefsRes.bottomMost) {
                    if (fieldDefsRes.s.length() != 0) {
                        fieldDefsRes.s = fieldDefsRes.s + "    /* local members: */\n";
                    }
                } else {
                    fieldDefsRes.s = fieldDefsRes.s + "    /* inherited members from " + fieldDefsRes.className + ": */\n";
                }
                fieldDefsRes.printedOne = true;
            }
            fieldDefsRes.s = fieldDefsRes.s + string2;
            return true;
        }
        return false;
    }

    private int doTwoWordFields(FieldDefsRes fieldDefsRes, String string, int n2, String string2, boolean bl) throws ClassNotFoundException {
        boolean bl2 = true;
        MemberDefinition[] memberDefinitionArray = this.env.getLocalFieldsAndMethods(string);
        int n3 = 0;
        while (n3 < memberDefinitionArray.length) {
            MemberDefinition memberDefinition = memberDefinitionArray[n3];
            if (memberDefinition.isVariable()) {
                boolean bl3;
                int n4 = memberDefinition.getType().getTypeCode();
                boolean bl4 = bl3 = n4 == 5 || n4 == 7;
                if (bl3 && this.doField(fieldDefsRes, memberDefinition, string2, bl2 && bl)) {
                    n2 += 8;
                    bl2 = false;
                }
            }
            ++n3;
        }
        return n2;
    }

    protected String fieldDefs(String string, String string2) throws ClassNotFoundException {
        FieldDefsRes fieldDefsRes = this.fieldDefs(string, string2, true);
        return fieldDefsRes.s;
    }

    protected FieldDefsRes fieldDefs(String string, String string2, boolean bl) throws ClassNotFoundException {
        int n2;
        FieldDefsRes fieldDefsRes;
        boolean bl2 = false;
        String string3 = this.env.getSuperClassName(string);
        if (string3 != null) {
            fieldDefsRes = new FieldDefsRes(string, this.fieldDefs(string3, string2, false), bl);
            n2 = fieldDefsRes.parent.byteSize;
        } else {
            fieldDefsRes = new FieldDefsRes(string, null, bl);
            n2 = 0;
        }
        MemberDefinition[] memberDefinitionArray = this.env.getLocalFieldsAndMethods(string);
        int n3 = 0;
        while (n3 < memberDefinitionArray.length) {
            MemberDefinition memberDefinition = memberDefinitionArray[n3];
            if (memberDefinition.isVariable()) {
                int n4;
                boolean bl3;
                if (this.doubleAlign && !bl2 && n2 % 8 == 0) {
                    n2 = this.doTwoWordFields(fieldDefsRes, string, n2, string2, false);
                    bl2 = true;
                }
                boolean bl4 = bl3 = (n4 = memberDefinition.getType().getTypeCode()) == 5 || n4 == 7;
                if (!(this.doubleAlign && bl3 || !this.doField(fieldDefsRes, memberDefinition, string2, false))) {
                    n2 += 4;
                }
            }
            ++n3;
        }
        if (this.doubleAlign && !bl2) {
            if (n2 % 8 != 0) {
                n2 += 4;
            }
            n2 = this.doTwoWordFields(fieldDefsRes, string, n2, string2, true);
        }
        fieldDefsRes.byteSize = n2;
        return fieldDefsRes;
    }

    protected String addStructMember(MemberDefinition memberDefinition, String string, boolean bl) throws ClassNotFoundException {
        String string2 = null;
        if (memberDefinition.isStatic()) {
            string2 = this.addStaticStructMember(memberDefinition, string);
            if (string2 == null) {
                string2 = "    /* Inaccessible static: " + memberDefinition + " */\n";
            }
        } else {
            if (bl) {
                string2 = "    java_int padWord" + this.padFieldNum++ + ";\n";
            }
            string2 = "    " + this.llniType(memberDefinition.getType(), false, false) + " " + this.llniFieldName(memberDefinition);
            if (this.isLongOrDouble(memberDefinition.getType())) {
                string2 = string2 + "[2]";
            }
            string2 = string2 + ";\n";
        }
        return string2;
    }

    protected String addStaticStructMember(MemberDefinition memberDefinition, String string) throws ClassNotFoundException {
        Expression expression;
        String string2 = null;
        if (!memberDefinition.isStatic()) {
            return string2;
        }
        if (!memberDefinition.isFinal()) {
            return string2;
        }
        try {
            expression = (Expression)memberDefinition.getValue(this.env);
        }
        catch (ClassNotFound classNotFound) {
            throw new ClassNotFoundException(classNotFound.getMessage());
        }
        if (expression != null) {
            String string3 = string + "_" + memberDefinition.getName().toString();
            String string4 = null;
            long l2 = 0L;
            if (expression instanceof IntExpression) {
                string4 = "L";
                l2 = ((Integer)expression.getValue()).intValue();
            }
            if (expression instanceof LongExpression) {
                string4 = isWindows ? "i64" : "LL";
                l2 = (Long)expression.getValue();
            }
            if (expression instanceof FloatExpression) {
                string4 = "f";
            }
            if (expression instanceof DoubleExpression) {
                string4 = "";
            }
            if (string4 != null) {
                string2 = string4.equals("L") && l2 == Integer.MIN_VALUE || string4.equals("LL") && l2 == Long.MIN_VALUE ? "    #undef  " + string3 + "\n" + "    #define " + string3 + " (" + (l2 + 1L) + string4 + "-1)\n" : "    #undef  " + string3 + "\n" + "    #define " + string3 + " " + expression.getValue().toString() + string4 + "\n";
            }
        }
        return string2;
    }

    protected void methodSectionForClass(PrintWriter printWriter, String string, String string2) throws ClassNotFoundException {
        String string3 = this.methodDecls(string, string2);
        if (string3.length() != 0) {
            printWriter.println("/* Native method declarations: */\n");
            printWriter.println("#ifdef __cplusplus");
            printWriter.println("extern \"C\" {");
            printWriter.println("#endif\n");
            printWriter.println(string3);
            printWriter.println("#ifdef __cplusplus");
            printWriter.println("}");
            printWriter.println("#endif");
        }
    }

    protected String methodDecls(String string, String string2) throws ClassNotFoundException {
        String string3 = "";
        int n2 = 0;
        while (n2 < this.fields.length) {
            MemberDefinition memberDefinition = this.fields[n2];
            if (memberDefinition.isNative()) {
                string3 = string3 + this.methodDecl(memberDefinition, string, string2);
            }
            ++n2;
        }
        return string3;
    }

    protected String methodDecl(MemberDefinition memberDefinition, String string, String string2) throws ClassNotFoundException {
        String string3 = memberDefinition.getType().getTypeSignature();
        boolean bl = this.needLongName(memberDefinition, string);
        if (string3.charAt(0) != '(') {
            Util.error("invalid.method.signature", string3);
        }
        MethodType methodType = (MethodType)memberDefinition.getType();
        Type type = methodType.getReturnType();
        String string4 = "JNIEXPORT " + this.jniType(type) + " JNICALL\n" + this.jniMethodName(memberDefinition, string2, bl) + "(JNIEnv *, " + this.cRcvrDecl(memberDefinition, string2);
        Type[] typeArray = methodType.getArgumentTypes();
        int n2 = 0;
        while (n2 < typeArray.length) {
            string4 = string4 + ", " + this.jniType(typeArray[n2]);
            ++n2;
        }
        string4 = string4 + ");\n";
        return string4;
    }

    protected final boolean needLongName(MemberDefinition memberDefinition, String string) throws ClassNotFoundException {
        Identifier identifier = memberDefinition.getName();
        int n2 = 0;
        while (n2 < this.fields.length) {
            MemberDefinition memberDefinition2 = this.fields[n2];
            if (memberDefinition2 != memberDefinition && memberDefinition2.isNative() && identifier == memberDefinition2.getName()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final String jniMethodName(MemberDefinition memberDefinition, String string, boolean bl) {
        String string2 = "Java_" + string + "_" + memberDefinition.getName().toString();
        if (bl) {
            MethodType methodType = (MethodType)memberDefinition.getType();
            Type[] typeArray = methodType.getArgumentTypes();
            string2 = string2 + "__";
            int n2 = 0;
            while (n2 < typeArray.length) {
                string2 = string2 + this.nameToIdentifier(typeArray[n2].getTypeSignature());
                ++n2;
            }
        }
        return string2;
    }

    protected final String jniType(Type type) {
        if (type instanceof ArrayType) {
            Type type2 = type.getElementType();
            switch (type2.getTypeCode()) {
                case 0: {
                    return "jbooleanArray";
                }
                case 1: {
                    return "jbyteArray";
                }
                case 2: {
                    return "jcharArray";
                }
                case 3: {
                    return "jshortArray";
                }
                case 4: {
                    return "jintArray";
                }
                case 5: {
                    return "jlongArray";
                }
                case 6: {
                    return "jfloatArray";
                }
                case 7: {
                    return "jdoubleArray";
                }
                case 9: 
                case 10: {
                    return "jobjectArray";
                }
            }
        } else {
            switch (type.getTypeCode()) {
                case 11: {
                    return "void";
                }
                case 0: {
                    return "jboolean";
                }
                case 1: {
                    return "jbyte";
                }
                case 2: {
                    return "jchar";
                }
                case 3: {
                    return "jshort";
                }
                case 4: {
                    return "jint";
                }
                case 5: {
                    return "jlong";
                }
                case 6: {
                    return "jfloat";
                }
                case 7: {
                    return "jdouble";
                }
                case 10: {
                    if (type == Type.tString) {
                        return "jstring";
                    }
                    if (type == Type.tClassDesc) {
                        return "jclass";
                    }
                    return "jobject";
                }
            }
        }
        Util.bug("jni.unknown.type");
        return null;
    }

    protected String llniType(Type type, boolean bl, boolean bl2) {
        String string = null;
        if (type instanceof ArrayType) {
            Type type2 = type.getElementType();
            switch (type2.getTypeCode()) {
                case 0: {
                    string = "IArrayOfBoolean";
                    break;
                }
                case 1: {
                    string = "IArrayOfByte";
                    break;
                }
                case 2: {
                    string = "IArrayOfChar";
                    break;
                }
                case 3: {
                    string = "IArrayOfShort";
                    break;
                }
                case 4: {
                    string = "IArrayOfInt";
                    break;
                }
                case 5: {
                    string = "IArrayOfLong";
                    break;
                }
                case 6: {
                    string = "IArrayOfFloat";
                    break;
                }
                case 7: {
                    string = "IArrayOfDouble";
                    break;
                }
                case 9: 
                case 10: {
                    string = "IArrayOfRef";
                }
            }
            if (!bl) {
                string = "DEREFERENCED_" + string;
            }
        } else {
            switch (type.getTypeCode()) {
                case 11: {
                    string = "void";
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "java_int";
                    break;
                }
                case 5: {
                    string = bl2 ? "java_long" : "val32 /* java_long */";
                    break;
                }
                case 6: {
                    string = "java_float";
                    break;
                }
                case 7: {
                    string = bl2 ? "java_double" : "val32 /* java_double */";
                    break;
                }
                case 10: {
                    string = "I" + this.mangleClassName(type.getClassName().toString());
                    if (bl) break;
                    string = "DEREFERENCED_" + string;
                }
            }
        }
        return string;
    }

    protected final String cRcvrDecl(MemberDefinition memberDefinition, String string) {
        return memberDefinition.isStatic() ? "jclass" : "jobject";
    }

    protected String maskName(String string) {
        return "LLNI_mask(" + string + ")";
    }

    protected String llniFieldName(MemberDefinition memberDefinition) {
        return this.maskName(memberDefinition.getName().toString());
    }

    protected final boolean isLongOrDouble(Type type) {
        int n2 = type.getTypeCode();
        return n2 == 5 || n2 == 7;
    }

    protected final String nameToIdentifier(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (this.isASCIILetterOrDigit(c2)) {
                stringBuffer.append(c2);
            } else if (c2 == '/') {
                stringBuffer.append('_');
            } else if (c2 == '.') {
                stringBuffer.append('_');
            } else if (c2 == '_') {
                stringBuffer.append("_1");
            } else if (c2 == ';') {
                stringBuffer.append("_2");
            } else if (c2 == '[') {
                stringBuffer.append("_3");
            } else {
                stringBuffer.append("_0" + c2);
            }
            ++n3;
        }
        return new String(stringBuffer);
    }

    protected final boolean isASCIILetterOrDigit(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9';
    }

    private static class FieldDefsRes {
        public String className;
        public FieldDefsRes parent;
        public String s;
        public int byteSize;
        public boolean bottomMost;
        public boolean printedOne = false;

        FieldDefsRes(String string, FieldDefsRes fieldDefsRes, boolean bl) {
            this.className = string;
            this.parent = fieldDefsRes;
            this.bottomMost = bl;
            boolean bl2 = false;
            this.s = fieldDefsRes == null ? "" : fieldDefsRes.s;
        }
    }
}

