/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.Gen;
import com.sun.tools.javah.Mangle;
import com.sun.tools.javah.Util;
import java.io.OutputStream;
import java.io.PrintWriter;
import sun.tools.java.ArrayType;
import sun.tools.java.MemberDefinition;
import sun.tools.java.MethodType;
import sun.tools.java.Type;

public class JNI
extends Gen {
    public String getIncludes() {
        return "#include <jni.h>";
    }

    public void write(OutputStream outputStream, String string) throws ClassNotFoundException {
        Object object;
        String string2 = Mangle.mangle(string, 1);
        PrintWriter printWriter = this.wrapWriter(outputStream);
        printWriter.println(this.guardBegin(string2));
        printWriter.println(this.cppGuardBegin());
        MemberDefinition[] memberDefinitionArray = this.env.getAllFields(string);
        int n2 = 0;
        while (n2 < memberDefinitionArray.length) {
            if (memberDefinitionArray[n2].isStatic()) {
                object = null;
                object = this.defineForStatic(string, memberDefinitionArray[n2]);
                if (object != null) {
                    printWriter.println((String)object);
                }
            }
            ++n2;
        }
        object = this.env.getNativeMethods(string);
        int n3 = 0;
        while (n3 < ((MemberDefinition[])object).length) {
            MemberDefinition memberDefinition = object[n3];
            MethodType methodType = (MethodType)memberDefinition.getType();
            String string3 = memberDefinition.getName().toString();
            boolean bl = false;
            int n4 = 0;
            while (n4 < ((MemberDefinition[])object).length) {
                if (object[n4] != memberDefinition && string3.equals(object[n4].getName().toString())) {
                    bl = true;
                }
                ++n4;
            }
            printWriter.println("/*");
            printWriter.println(" * Class:     " + string2);
            printWriter.println(" * Method:    " + Mangle.mangle(string3, 2));
            printWriter.println(" * Signature: " + methodType.getTypeSignature());
            printWriter.println(" */");
            printWriter.println("JNIEXPORT " + this.jniType(methodType.getReturnType()) + " JNICALL " + Mangle.mangleMethod(memberDefinition, string, bl ? 8 : 7));
            printWriter.print("  (JNIEnv *, ");
            Type[] typeArray = methodType.getArgumentTypes();
            if (memberDefinition.isStatic()) {
                printWriter.print("jclass");
            } else {
                printWriter.print("jobject");
            }
            if (typeArray.length > 0) {
                printWriter.print(", ");
            }
            int n5 = 0;
            while (n5 < typeArray.length) {
                printWriter.print(this.jniType(typeArray[n5]));
                if (n5 != typeArray.length - 1) {
                    printWriter.print(", ");
                }
                ++n5;
            }
            printWriter.println(");\n");
            ++n3;
        }
        printWriter.println(this.cppGuardEnd());
        printWriter.println(this.guardEnd(string2));
    }

    protected final String jniType(Type type) {
        if (type instanceof ArrayType) {
            Type type2 = type.getElementType();
            switch (type2.getTypeCode()) {
                case 0: {
                    return "jbooleanArray";
                }
                case 1: {
                    return "jbyteArray";
                }
                case 2: {
                    return "jcharArray";
                }
                case 3: {
                    return "jshortArray";
                }
                case 4: {
                    return "jintArray";
                }
                case 5: {
                    return "jlongArray";
                }
                case 6: {
                    return "jfloatArray";
                }
                case 7: {
                    return "jdoubleArray";
                }
                case 9: 
                case 10: {
                    return "jobjectArray";
                }
            }
        } else {
            switch (type.getTypeCode()) {
                case 11: {
                    return "void";
                }
                case 0: {
                    return "jboolean";
                }
                case 1: {
                    return "jbyte";
                }
                case 2: {
                    return "jchar";
                }
                case 3: {
                    return "jshort";
                }
                case 4: {
                    return "jint";
                }
                case 5: {
                    return "jlong";
                }
                case 6: {
                    return "jfloat";
                }
                case 7: {
                    return "jdouble";
                }
                case 10: {
                    if (type == Type.tString) {
                        return "jstring";
                    }
                    if (type == Type.tClassDesc) {
                        return "jclass";
                    }
                    if (this.env.isThrowable(type)) {
                        return "jthrowable";
                    }
                    return "jobject";
                }
            }
        }
        Util.bug("jni.unknown.type");
        return null;
    }
}

