/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.SerialFieldTagImpl;

class SerializedForm {
    ListBuffer methods = new ListBuffer();
    private final ListBuffer fields = new ListBuffer();
    private boolean definesSerializableFields = false;
    private static final String SERIALIZABLE_FIELDS = "serialPersistentFields";
    private static final String READOBJECT = "readObject";
    private static final String WRITEOBJECT = "writeObject";
    private static final String READRESOLVE = "readResolve";
    private static final String WRITEREPLACE = "writeReplace";

    SerializedForm(DocEnv docEnv, Symbol.ClassSymbol classSymbol, ClassDocImpl classDocImpl) {
        if (classDocImpl.isExternalizable()) {
            String[] stringArray = new String[]{"java.io.ObjectInput"};
            String[] stringArray2 = new String[]{"java.io.ObjectOutput"};
            MethodDocImpl methodDocImpl = classDocImpl.findMethod("readExternal", stringArray);
            if (methodDocImpl != null) {
                this.methods.append(methodDocImpl);
            }
            if ((methodDocImpl = classDocImpl.findMethod("writeExternal", stringArray2)) != null) {
                this.methods.append(methodDocImpl);
                Tag[] tagArray = methodDocImpl.tags("serialData");
            }
        } else if (classDocImpl.isSerializable()) {
            Symbol.VarSymbol varSymbol = this.getDefinedSerializableFields(classSymbol);
            if (varSymbol != null) {
                this.definesSerializableFields = true;
                FieldDocImpl fieldDocImpl = docEnv.getFieldDoc(varSymbol);
                this.fields.append(fieldDocImpl);
                this.mapSerialFieldTagImplsToFieldDocImpls(fieldDocImpl, docEnv, classSymbol);
            } else {
                this.computeDefaultSerializableFields(docEnv, classSymbol, classDocImpl);
            }
            this.addMethodIfExist(docEnv, classSymbol, READOBJECT);
            this.addMethodIfExist(docEnv, classSymbol, WRITEOBJECT);
            this.addMethodIfExist(docEnv, classSymbol, READRESOLVE);
            this.addMethodIfExist(docEnv, classSymbol, WRITEREPLACE);
        }
    }

    private Symbol.VarSymbol getDefinedSerializableFields(Symbol.ClassSymbol classSymbol) {
        Name.Table table = classSymbol.name.table;
        Scope.Entry entry = classSymbol.members().lookup(table.fromString(SERIALIZABLE_FIELDS));
        while (entry != null) {
            Symbol.VarSymbol varSymbol;
            if (entry.sym != null && entry.sym.kind == 4 && ((varSymbol = (Symbol.VarSymbol)entry.sym).flags() & 8L) != 0L && (varSymbol.flags() & 2L) != 0L) {
                return varSymbol;
            }
            entry = entry.shadowed;
        }
        return null;
    }

    private void computeDefaultSerializableFields(DocEnv docEnv, Symbol.ClassSymbol classSymbol, ClassDocImpl classDocImpl) {
        Scope.Entry entry = classSymbol.members().elems;
        while (entry != null) {
            Symbol.VarSymbol varSymbol;
            if (entry.sym != null && entry.sym.kind == 4 && ((varSymbol = (Symbol.VarSymbol)entry.sym).flags() & 8L) == 0L && (varSymbol.flags() & 0x80L) == 0L) {
                FieldDocImpl fieldDocImpl = docEnv.getFieldDoc(varSymbol);
                this.fields.prepend(fieldDocImpl);
            }
            entry = entry.sibling;
        }
    }

    private void addMethodIfExist(DocEnv docEnv, Symbol.ClassSymbol classSymbol, String string) {
        Name.Table table = classSymbol.name.table;
        Scope.Entry entry = classSymbol.members().lookup(table.fromString(string));
        while (entry != null) {
            Symbol.MethodSymbol methodSymbol;
            if (entry.sym != null && entry.sym.kind == 16 && entry.sym.name.toString().equals(string) && ((methodSymbol = (Symbol.MethodSymbol)entry.sym).flags() & 8L) == 0L) {
                this.methods.append(docEnv.getMethodDoc(methodSymbol));
            }
            entry = entry.shadowed;
        }
    }

    private void mapSerialFieldTagImplsToFieldDocImpls(FieldDocImpl fieldDocImpl, DocEnv docEnv, Symbol.ClassSymbol classSymbol) {
        Name.Table table = classSymbol.name.table;
        SerialFieldTag[] serialFieldTagArray = fieldDocImpl.serialFieldTags();
        int n2 = 0;
        while (n2 < serialFieldTagArray.length) {
            Name name = table.fromString(serialFieldTagArray[n2].fieldName());
            Scope.Entry entry = classSymbol.members().lookup(name);
            while (entry != null) {
                if (entry.sym != null && entry.sym.kind == 4) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)entry.sym;
                    FieldDocImpl fieldDocImpl2 = docEnv.getFieldDoc(varSymbol);
                    ((SerialFieldTagImpl)serialFieldTagArray[n2]).mapToFieldDocImpl(fieldDocImpl2);
                    break;
                }
                entry = entry.shadowed;
            }
            ++n2;
        }
    }

    FieldDoc[] fields() {
        return (FieldDoc[])this.fields.toArray(new FieldDocImpl[this.fields.length()]);
    }

    MethodDoc[] methods() {
        return (MethodDoc[])this.methods.toArray(new MethodDoc[this.methods.length()]);
    }

    boolean definesSerializableFields() {
        return this.definesSerializableFields;
    }
}

