/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.TagImpl;

class SeeTagImpl
extends TagImpl
implements SeeTag {
    private String where;
    private String what;
    private PackageDoc referencedPackage;
    private ClassDoc referencedClass;
    private MemberDoc referencedMember;
    String label = "";

    SeeTagImpl(DocImpl docImpl, String string, String string2) {
        super(docImpl, string, string2);
        this.parseSeeString();
        if (this.where != null) {
            ClassDocImpl classDocImpl = null;
            if (docImpl instanceof MemberDoc) {
                classDocImpl = (ClassDocImpl)((ProgramElementDoc)((Object)docImpl)).containingClass();
            } else if (docImpl instanceof ClassDoc) {
                classDocImpl = (ClassDocImpl)docImpl;
            }
            this.findReferenced(classDocImpl);
        }
    }

    public String referencedClassName() {
        return this.where;
    }

    public PackageDoc referencedPackage() {
        return this.referencedPackage;
    }

    public ClassDoc referencedClass() {
        return this.referencedClass;
    }

    public String referencedMemberName() {
        return this.what;
    }

    public MemberDoc referencedMember() {
        return this.referencedMember;
    }

    private void parseSeeString() {
        int n2;
        int n3;
        int n4 = this.text.length();
        if (n4 == 0) {
            return;
        }
        switch (this.text.charAt(0)) {
            case '<': {
                if (this.text.charAt(n4 - 1) != '>') {
                    this.docenv().warning(this.holder, "tag.see.no_close_bracket_on_url", this.name, this.text);
                }
                return;
            }
            case '\"': {
                if (n4 == 1 || this.text.charAt(n4 - 1) != '\"') {
                    this.docenv().warning(this.holder, "tag.see.no_close_quote", this.name, this.text);
                }
                return;
            }
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 = 0;
        while (n7 < n4) {
            char c2 = this.text.charAt(n7);
            switch (c2) {
                case '(': {
                    ++n5;
                    break;
                }
                case ')': {
                    --n5;
                    break;
                }
                case '#': 
                case '.': 
                case '[': 
                case ']': {
                    break;
                }
                case ',': {
                    if (n5 > 0) break;
                    this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
                    return;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    if (n5 != 0) break;
                    n6 = n7;
                    n7 = n4;
                    break;
                }
                default: {
                    if (Character.isJavaIdentifierPart(c2)) break;
                    this.docenv().warning(this.holder, "tag.see.illegal_character", this.name, "" + c2, this.text);
                    return;
                }
            }
            ++n7;
        }
        if (n5 != 0) {
            this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
            return;
        }
        String string = "";
        String string2 = "";
        if (n6 > 0) {
            string = this.text.substring(n3, n6);
            string2 = this.text.substring(n6 + 1);
            n2 = 0;
            while (n2 < string2.length()) {
                char c3 = string2.charAt(n2);
                if (c3 != ' ' && c3 != '\t' && c3 != '\n') {
                    this.label = string2.substring(n2);
                    break;
                }
                ++n2;
            }
        } else {
            string = this.text;
            this.label = "";
        }
        n2 = string.indexOf(35);
        if (n2 >= 0) {
            this.where = string.substring(0, n2);
            this.what = string.substring(n2 + 1);
        } else if (string.indexOf(40) >= 0) {
            this.docenv().warning(this.holder, "tag.see.missing_sharp", this.name, this.text);
            this.where = "";
            this.what = string;
        } else {
            this.where = string;
            this.what = null;
        }
    }

    private void findReferenced(ClassDocImpl classDocImpl) {
        String string;
        if (this.where.length() > 0) {
            this.referencedClass = classDocImpl != null ? classDocImpl.findClass(this.where) : this.docenv().lookupClass(this.where);
            if (this.referencedClass == null) {
                this.referencedPackage = this.docenv().lookupPackage(this.where);
                return;
            }
        } else {
            if (classDocImpl == null) {
                this.docenv().warning(this.holder, "tag.see.class_not_specified", this.name, this.text);
                return;
            }
            this.referencedClass = classDocImpl;
        }
        this.where = this.referencedClass.qualifiedName();
        if (this.what == null) {
            return;
        }
        int n2 = this.what.indexOf(40);
        String string2 = string = n2 >= 0 ? this.what.substring(0, n2) : this.what;
        if (n2 > 0) {
            String[] stringArray = new ParameterParseMachine(this.what.substring(n2, this.what.length())).parseParameters();
            this.referencedMember = stringArray != null ? this.findExecutableMember(string, stringArray, this.referencedClass) : null;
        } else {
            this.referencedMember = this.findExecutableMember(string, null, this.referencedClass);
            FieldDoc fieldDoc = ((ClassDocImpl)this.referencedClass).findField(string);
            if (this.referencedMember == null || fieldDoc != null && fieldDoc.containingClass().subclassOf(this.referencedMember.containingClass())) {
                this.referencedMember = fieldDoc;
            }
        }
        if (this.referencedMember == null) {
            this.docenv().warning(this.holder, "tag.see.can_not_find_member", this.name, this.what, this.where);
        }
    }

    private MemberDoc findReferencedMethod(String string, String[] stringArray, ClassDoc classDoc) {
        MemberDoc memberDoc = this.findExecutableMember(string, stringArray, classDoc);
        ClassDoc[] classDocArray = classDoc.innerClasses();
        if (memberDoc == null) {
            int n2 = 0;
            while (n2 < classDocArray.length) {
                memberDoc = this.findReferencedMethod(string, stringArray, classDocArray[n2]);
                if (memberDoc != null) {
                    return memberDoc;
                }
                ++n2;
            }
        }
        return null;
    }

    private MemberDoc findExecutableMember(String string, String[] stringArray, ClassDoc classDoc) {
        if (string.equals(classDoc.name())) {
            return ((ClassDocImpl)classDoc).findConstructor(string, stringArray);
        }
        return ((ClassDocImpl)classDoc).findMethod(string, stringArray);
    }

    public String kind() {
        return "@see";
    }

    public String label() {
        return this.label;
    }

    class ParameterParseMachine {
        final int START = 0;
        final int TYPE = 1;
        final int NAME = 2;
        final int TNSPACE = 3;
        final int ARRAYDECORATION = 4;
        final int ARRAYSPACE = 5;
        String parameters;
        StringBuffer typeId;
        ListBuffer paramList;

        ParameterParseMachine(String string) {
            this.parameters = string;
            this.paramList = new ListBuffer();
            this.typeId = new StringBuffer();
        }

        public String[] parseParameters() {
            if (this.parameters.equals("()")) {
                return new String[0];
            }
            int n2 = 0;
            int n3 = 0;
            this.parameters = this.parameters.substring(1, this.parameters.length() - 1);
            char[] cArray = this.parameters.toCharArray();
            int n4 = 0;
            while (n4 < cArray.length) {
                char c2 = cArray[n4];
                switch (n2) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(c2)) {
                            this.typeId.append(c2);
                            n2 = 1;
                        }
                        n3 = 0;
                        break;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c2) || c2 == '.') {
                            this.typeId.append(c2);
                        } else if (c2 == '[') {
                            this.typeId.append(c2);
                            n2 = 4;
                        } else if (Character.isWhitespace(c2)) {
                            n2 = 3;
                        } else if (c2 == ',') {
                            this.addTypeToParamList();
                            n2 = 0;
                        }
                        n3 = 1;
                        break;
                    }
                    case 3: {
                        if (Character.isJavaIdentifierStart(c2)) {
                            if (n3 == 4) {
                                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.missing_comma_space", SeeTagImpl.this.name, "(" + this.parameters + ")");
                                return null;
                            }
                            this.addTypeToParamList();
                            n2 = 2;
                        } else if (c2 == '[') {
                            this.typeId.append(c2);
                            n2 = 4;
                        } else if (c2 == ',') {
                            this.addTypeToParamList();
                            n2 = 0;
                        }
                        n3 = 3;
                        break;
                    }
                    case 4: {
                        if (c2 == ']') {
                            this.typeId.append(c2);
                            n2 = 3;
                        } else if (!Character.isWhitespace(c2)) {
                            SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_char_in_arr_dim", SeeTagImpl.this.name, "(" + this.parameters + ")");
                            return null;
                        }
                        n3 = 4;
                        break;
                    }
                    case 2: {
                        if (c2 == ',') {
                            n2 = 0;
                        }
                        n3 = 2;
                    }
                }
                ++n4;
            }
            if (n2 == 4 || n2 == 0 && n3 == 3) {
                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_see_tag", "(" + this.parameters + ")");
            }
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
            }
            return (String[])this.paramList.toArray(new String[this.paramList.length()]);
        }

        void addTypeToParamList() {
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
                this.typeId.setLength(0);
            }
        }
    }
}

