/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import java.text.BreakIterator;
import java.text.Collator;
import java.util.Locale;

class DocLocale {
    final String localeName;
    final Locale locale;
    final Collator collator;
    private final DocEnv docenv;
    private final BreakIterator sentenceBreaker;
    private boolean useBreakIterator = false;
    private boolean printedLongBreakIteratorWarning = false;
    static final String[] sentenceTerminators = new String[]{"<p>", "</p>", "<h1>", "<h2>", "<h3>", "<h4>", "<h5>", "<h6>", "</h1>", "</h2>", "</h3>", "</h4>", "</h5>", "</h6>", "<hr>", "<pre>", "</pre>"};

    DocLocale(DocEnv docEnv, String string, boolean bl) {
        this.docenv = docEnv;
        this.localeName = string;
        this.useBreakIterator = bl;
        this.locale = this.getLocale();
        if (this.locale == null) {
            docEnv.exit();
        } else {
            Locale.setDefault(this.locale);
        }
        this.collator = Collator.getInstance(this.locale);
        this.sentenceBreaker = BreakIterator.getSentenceInstance(this.locale);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Locale getLocale() {
        Locale locale = null;
        if (this.localeName.length() <= 0) return Locale.getDefault();
        int n2 = this.localeName.indexOf(95);
        int n3 = -1;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (n2 == 2) {
            string = this.localeName.substring(0, n2);
            n3 = this.localeName.indexOf(95, n2 + 1);
            if (n3 > 0) {
                if (n3 != n2 + 3 || this.localeName.length() <= n3 + 1) {
                    this.docenv.error(null, "main.malformed_locale_name", this.localeName);
                    return null;
                }
                string2 = this.localeName.substring(n2 + 1, n3);
                string3 = this.localeName.substring(n3 + 1);
            } else {
                if (this.localeName.length() != n2 + 3) {
                    this.docenv.error(null, "main.malformed_locale_name", this.localeName);
                    return null;
                }
                string2 = this.localeName.substring(n2 + 1);
            }
        } else if (n2 == -1 && this.localeName.length() == 2) {
            string = this.localeName;
        } else {
            this.docenv.error(null, "main.malformed_locale_name", this.localeName);
            return null;
        }
        locale = this.searchLocale(string, string2, string3);
        if (locale == null) {
            this.docenv.error(null, "main.illegal_locale_name", this.localeName);
            return null;
        }
        return locale;
    }

    private Locale searchLocale(String string, String string2, String string3) {
        Locale[] localeArray = Locale.getAvailableLocales();
        int n2 = 0;
        while (n2 < localeArray.length) {
            if (localeArray[n2].getLanguage().equals(string) && (string2 == null || localeArray[n2].getCountry().equals(string2)) && (string3 == null || localeArray[n2].getVariant().equals(string3))) {
                return localeArray[n2];
            }
            ++n2;
        }
        return null;
    }

    String localeSpecificFirstSentence(DocImpl docImpl, String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n2 = string.indexOf("-->");
        if (string.trim().startsWith("<!--") && n2 != -1) {
            return this.localeSpecificFirstSentence(docImpl, string.substring(n2 + 3, string.length()));
        }
        this.sentenceBreaker.setText(string.replace('\n', ' '));
        int n3 = this.sentenceBreaker.first();
        int n4 = this.sentenceBreaker.next();
        String string2 = string.substring(n3, n4);
        if (this.locale.getLanguage().equals("en") && !this.useBreakIterator) {
            String string3 = this.englishLanguageFirstSentence(string);
            if (!string2.trim().equals(string3.trim())) {
                if (!this.printedLongBreakIteratorWarning) {
                    this.docenv.warning(docImpl, "javadoc.BreakIterator_Error_Long_0");
                    this.docenv.notice("javadoc.BreakIterator_Error_Long_1", string3);
                    this.docenv.notice("javadoc.BreakIterator_Error_Long_2");
                    this.docenv.notice("javadoc.BreakIterator_Error_Long_3");
                    this.docenv.notice("javadoc.BreakIterator_Error_Long_4", string2);
                    this.docenv.notice("javadoc.BreakIterator_Error_Long_5");
                    this.docenv.notice("javadoc.BreakIterator_Error_Long_6");
                    this.printedLongBreakIteratorWarning = true;
                } else {
                    this.docenv.warning(docImpl, "javadoc.BreakIterator_Error_Short_0");
                    this.docenv.notice("javadoc.BreakIterator_Error_Short_1", string3);
                    this.docenv.notice("javadoc.BreakIterator_Error_Short_2");
                    this.docenv.notice("javadoc.BreakIterator_Error_Short_3", string2);
                }
            }
            return string3;
        }
        return string2;
    }

    private String englishLanguageFirstSentence(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            switch (string.charAt(n3)) {
                case '.': {
                    bl = true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl) break;
                    return string.substring(0, n3);
                }
                case '<': {
                    if (n3 <= 0 || !this.htmlSentenceTerminatorFound(string, n3)) break;
                    return string.substring(0, n3);
                }
                default: {
                    bl = false;
                }
            }
            ++n3;
        }
        return string;
    }

    private boolean htmlSentenceTerminatorFound(String string, int n2) {
        int n3 = 0;
        while (n3 < sentenceTerminators.length) {
            String string2 = sentenceTerminators[n3];
            if (string.regionMatches(true, n2, string2, 0, string2.length())) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

