/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.util;

import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.LayoutCharacters;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Options;
import com.sun.tools.javac.v8.util.Pair;
import com.sun.tools.javac.v8.util.Position;
import com.sun.tools.javac.v8.util.Set;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Log
implements LayoutCharacters {
    private static final Context.Key logKey = new Context.Key();
    public static final Context.Key outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    public int MaxErrors = 100;
    public int MaxWarnings = 100;
    public boolean promptOnError;
    public boolean emitWarnings;
    private Name sourcename;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set recorded = Set.make();
    private byte[] buf = null;
    private int bp;
    private int lastLine;
    private static final String compilerRB = "com.sun.tools.javac.v8.resources.compiler";
    private static ResourceBundle messageRB;

    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        context.put(logKey, this);
        this.errWriter = printWriter;
        this.warnWriter = printWriter2;
        this.noticeWriter = printWriter3;
        Options options = Options.instance(context);
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-nowarn") == null;
        this.sourcename = Name.Table.instance((Context)context).__input;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter printWriter = (PrintWriter)context.get(outKey);
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err);
            context.put(outKey, printWriter);
        }
        return printWriter;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter printWriter) {
        this(context, printWriter, printWriter, printWriter);
    }

    public static Log instance(Context context) {
        Log log = (Log)context.get(logKey);
        if (log == null) {
            log = new Log(context);
        }
        return log;
    }

    public Name useSource(Name name) {
        Name name2 = this.sourcename;
        this.sourcename = name;
        if (name2 != this.sourcename) {
            this.buf = null;
        }
        return name2;
    }

    public Name currentSource() {
        return this.sourcename;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort"));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrLine(int n2, int n3, PrintWriter printWriter) {
        try {
            try {
                if (this.buf == null) {
                    FileInputStream fileInputStream = new FileInputStream(this.sourcename.toString());
                    this.buf = new byte[fileInputStream.available()];
                    fileInputStream.read(this.buf);
                    fileInputStream.close();
                    this.bp = 0;
                    this.lastLine = 1;
                } else if (this.lastLine > n2) {
                    this.bp = 0;
                    this.lastLine = 1;
                }
                while (this.bp < this.buf.length && this.lastLine < n2) {
                    switch (this.buf[this.bp]) {
                        case 13: {
                            ++this.bp;
                            if (this.bp < this.buf.length && this.buf[this.bp] == 10) {
                                ++this.bp;
                            }
                            ++this.lastLine;
                            break;
                        }
                        case 10: {
                            ++this.bp;
                            ++this.lastLine;
                            break;
                        }
                        default: {
                            ++this.bp;
                        }
                    }
                }
                int n4 = this.bp;
                while (n4 < this.buf.length && this.buf[n4] != 13 && this.buf[n4] != 10) {
                    ++n4;
                }
                Log.printLines(printWriter, new String(this.buf, this.bp, n4 - this.bp));
                byte[] byArray = new byte[n3];
                int n5 = 0;
                while (n5 < n3 - 1) {
                    byArray[n5] = 32;
                    ++n5;
                }
                byArray[n3 - 1] = 94;
                Log.printLines(printWriter, new String(byArray, 0, n3));
            }
            catch (IOException iOException) {
                Log.printLines(this.errWriter, Log.getLocalizedString("source.unavailable"));
                Object var8_10 = null;
                this.errWriter.flush();
            }
            Object var8_9 = null;
            this.errWriter.flush();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.errWriter.flush();
            throw throwable;
        }
    }

    public static void printLines(PrintWriter printWriter, String string) {
        int n2;
        while ((n2 = string.indexOf(10)) != -1) {
            printWriter.println(string.substring(0, n2));
            string = string.substring(n2 + 1);
        }
        if (string.length() != 0) {
            printWriter.println(string);
        }
    }

    private void printError(int n2, String string, PrintWriter printWriter) {
        if (n2 == 0) {
            printWriter.print(Log.getText("compiler.err.error", null, null, null, null, null, null, null));
            Log.printLines(printWriter, string);
        } else {
            int n3 = Position.line(n2);
            int n4 = Position.column(n2);
            Log.printLines(printWriter, this.sourcename + ":" + n3 + ": " + string);
            this.printErrLine(n3, n4, printWriter);
        }
        printWriter.flush();
    }

    public void error(int n2, String string) {
        this.error(n2, string, null, null, null, null, null, null, null);
    }

    public void error(int n2, String string, String string2) {
        this.error(n2, string, string2, null, null, null, null, null, null);
    }

    public void error(int n2, String string, String string2, String string3) {
        this.error(n2, string, string2, string3, null, null, null, null, null);
    }

    public void error(int n2, String string, String string2, String string3, String string4) {
        this.error(n2, string, string2, string3, string4, null, null, null, null);
    }

    public void error(int n2, String string, String string2, String string3, String string4, String string5) {
        this.error(n2, string, string2, string3, string4, string5, null, null, null);
    }

    public void error(int n2, String string, String string2, String string3, String string4, String string5, String string6) {
        this.error(n2, string, string2, string3, string4, string5, string6, null, null);
    }

    public void error(int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.error(n2, string, string2, string3, string4, string5, string6, string7, null);
    }

    public void error(int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Pair pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair(this.sourcename, new Integer(n2)))) {
            this.recorded.put(pair);
            String string9 = Log.getText("compiler.err." + string, string2, string3, string4, string5, string6, string7, string8);
            this.printError(n2, string9, this.errWriter);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void warning(int n2, String string) {
        this.warning(n2, string, null, null, null, null);
    }

    public void warning(int n2, String string, String string2) {
        this.warning(n2, string, string2, null, null, null);
    }

    public void warning(int n2, String string, String string2, String string3) {
        this.warning(n2, string, string2, string3, null, null);
    }

    public void warning(int n2, String string, String string2, String string3, String string4) {
        this.warning(n2, string, string2, string3, string4, null);
    }

    public void warning(int n2, String string, String string2, String string3, String string4, String string5) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            String string6 = Log.getText("compiler.warn." + string, string2, string3, string4, string5, null, null, null);
            this.printError(n2, Log.getText("compiler.warn.warning", null, null, null, null, null, null, null) + string6, this.warnWriter);
        }
        ++this.nwarnings;
    }

    public void note(String string) {
        this.note(string, null);
    }

    public void note(String string, String string2) {
        if (this.emitWarnings) {
            this.noticeWriter.print(Log.getText("compiler.note.note", null, null, null, null, null, null, null));
            String string3 = Log.getText("compiler.note." + string, string2, null, null, null, null, null, null);
            Log.printLines(this.noticeWriter, string3);
            this.noticeWriter.flush();
        }
    }

    public static String getLocalizedString(String string) {
        return Log.getText("compiler.misc." + string, null, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2) {
        return Log.getText("compiler.misc." + string, string2, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3) {
        return Log.getText("compiler.misc." + string, string2, string3, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3, String string4) {
        return Log.getText("compiler.misc." + string, string2, string3, string4, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3, String string4, String string5) {
        return Log.getText("compiler.misc." + string, string2, string3, string4, string5, null, null, null);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(compilerRB);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for compiler is missing");
        }
    }

    public static String getText(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (messageRB == null) {
            Log.initResource();
        }
        try {
            Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7, string8};
            return MessageFormat.format(messageRB.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                string2 = "null";
            }
            if (string3 == null) {
                string3 = "null";
            }
            if (string4 == null) {
                string4 = "null";
            }
            if (string5 == null) {
                string5 = "null";
            }
            if (string6 == null) {
                string6 = "null";
            }
            if (string7 == null) {
                string7 = "null";
            }
            if (string8 == null) {
                string8 = "null";
            }
            Object[] objectArray = new String[]{string, string2, string3, string4, string5, string6, string7, string8};
            String string9 = "compiler message file broken: key={0} arguments={1}, {2}, {3}, {4}, {5}, {6}, {7}";
            return MessageFormat.format(string9, objectArray);
        }
    }

    private void printRawError(int n2, String string) {
        if (n2 == 0) {
            Log.printLines(this.errWriter, "error: " + string);
        } else {
            int n3 = Position.line(n2);
            int n4 = Position.column(n2);
            Log.printLines(this.errWriter, this.sourcename + ":" + n3 + ": " + string);
            this.printErrLine(n3, n4, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int n2, String string) {
        Pair pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair(this.sourcename, new Integer(n2)))) {
            this.recorded.put(pair);
            this.printRawError(n2, string);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int n2, String string) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(n2, "warning: " + string);
        }
        ++this.nwarnings;
        this.errWriter.flush();
    }
}

