/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.util;

import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;

public class Hashtable {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry[] table;

    public Hashtable(int n2, float f2) {
        int n3 = 1;
        while (n3 < n2) {
            n3 <<= 1;
        }
        this.hashSize = n3;
        this.hashMask = n3 - 1;
        this.limit = (int)((float)n3 * f2);
        this.size = 0;
        this.table = new Entry[n3];
    }

    public Hashtable(int n2) {
        this(n2, 0.75f);
    }

    public Hashtable() {
        this(32);
    }

    public static Hashtable make() {
        return new Hashtable();
    }

    private void dble() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry[] entryArray = this.table;
        this.table = new Entry[this.hashSize];
        int n2 = 0;
        while (n2 < entryArray.length) {
            Entry entry = entryArray[n2];
            Entry entry2 = null;
            while (entry != null) {
                entry2 = entry.next;
                int n3 = entry.hash & this.hashMask;
                entry.next = this.table[n3];
                this.table[n3] = entry;
                entry = entry2;
            }
            ++n2;
        }
    }

    public Object get(Object object) {
        int n2 = object.hashCode();
        Entry entry = this.table[n2 & this.hashMask];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        int n2 = object.hashCode();
        Entry entry2 = this.table[n2 & this.hashMask];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.key.equals(object)) {
                Object object3 = entry2.value;
                entry2.value = object2;
                return object3;
            }
            entry2 = entry2.next;
        }
        ++this.size;
        if (this.size > this.limit) {
            this.dble();
        }
        int n3 = n2 & this.hashMask;
        this.table[n3] = entry = new Entry(object, object2, n2, this.table[n3]);
        return null;
    }

    public Object remove(Object object) {
        int n2 = object.hashCode();
        Entry entry = null;
        Entry entry2 = this.table[n2 & this.hashMask];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.key.equals(object)) {
                if (entry != null) {
                    entry.next = entry2.next;
                } else {
                    this.table[n2 & this.hashMask] = entry2.next;
                }
                --this.size;
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    public List keys() {
        ListBuffer listBuffer = new ListBuffer();
        int n2 = 0;
        while (n2 < this.table.length) {
            Entry entry = this.table[n2];
            while (entry != null) {
                listBuffer.append(entry.key);
                entry = entry.next;
            }
            ++n2;
        }
        return listBuffer.toList();
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        int n2 = 0;
        while (n2 < this.table.length) {
            this.table[n2] = null;
            ++n2;
        }
        this.size = 0;
    }

    private static class Entry {
        Object key;
        Object value;
        int hash;
        Entry next;

        Entry(Object object, Object object2, int n2, Entry entry) {
            this.key = object;
            this.value = object2;
            this.hash = n2;
            this.next = entry;
        }
    }
}

