/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.util;

import com.sun.tools.javac.v8.util.Name;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ByteBuffer {
    public byte[] elems;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int n2) {
        this.elems = new byte[n2];
        this.length = 0;
    }

    private void copy(int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.elems, 0, byArray, 0, this.elems.length);
        this.elems = byArray;
    }

    public void appendByte(int n2) {
        if (this.length >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length++] = (byte)n2;
    }

    public void appendBytes(byte[] byArray, int n2, int n3) {
        while (this.length + n3 > this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        System.arraycopy(byArray, n2, this.elems, this.length, n3);
        this.length += n3;
    }

    public void appendBytes(byte[] byArray) {
        this.appendBytes(byArray, 0, byArray.length);
    }

    public void appendChar(int n2) {
        while (this.length + 1 >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length] = (byte)(n2 >> 8 & 0xFF);
        this.elems[this.length + 1] = (byte)(n2 & 0xFF);
        this.length += 2;
    }

    public void appendInt(int n2) {
        while (this.length + 3 >= this.elems.length) {
            this.copy(this.elems.length * 2);
        }
        this.elems[this.length] = (byte)(n2 >> 24 & 0xFF);
        this.elems[this.length + 1] = (byte)(n2 >> 16 & 0xFF);
        this.elems[this.length + 2] = (byte)(n2 >> 8 & 0xFF);
        this.elems[this.length + 3] = (byte)(n2 & 0xFF);
        this.length += 4;
    }

    public void appendLong(long l2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l2);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendFloat(float f2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeFloat(f2);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 4);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendDouble(double d2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeDouble(d2);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendName(Name name) {
        this.appendBytes(name.table.names, name.index, name.len);
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName(Name.Table table) {
        return table.fromUtf(this.elems, 0, this.length);
    }
}

